/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.messages.AaPhpInputStream;
import com.tridium.aaphp.messages.AaPhpResponse;
import javax.baja.nre.util.TextUtil;

public class AaPhpVirtualTerminalResponse
extends AaPhpResponse {
    private String rawMessageText = "";
    private String messageText = "";
    static final int CHAR_ESC = 27;
    static final int CHAR_BELL = 7;
    static final int CHAR_CR = 13;

    public AaPhpVirtualTerminalResponse(AaPhpInputStream inStream) {
        super(inStream);
        if (!this.isError() && inStream.available() > 1) {
            inStream.readString(1);
            if (inStream.available() > 1) {
                this.rawMessageText = inStream.readMessageText();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.rawMessageText.length(); ++i) {
                    char nextChar = this.rawMessageText.charAt(i);
                    if (nextChar == '\u001b') {
                        String escapedString = this.rawMessageText.substring(i + 1, i + 3);
                        int escapedChar = Integer.parseInt(escapedString, 16);
                        if (escapedChar != 7) {
                            sb.append((char)escapedChar);
                        }
                        i += 2;
                        continue;
                    }
                    sb.append(nextChar);
                }
                sb = TextUtil.replace((StringBuffer)sb, (String)"\r\n", (String)"\n");
                sb = TextUtil.replace((StringBuffer)sb, (String)"\n\r", (String)"\n");
                sb = TextUtil.replace((StringBuffer)sb, (String)"\r", (String)"\n");
                this.messageText = sb.toString();
            }
        }
    }

    public boolean isEmpty() {
        return this.messageText.length() == 0;
    }

    public String getMessageText() {
        return this.messageText;
    }
}

