/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.job;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.BAaPhpStarNetwork;
import com.tridium.aaphp.datatypes.BAaPhpTerminalJobRecord;
import com.tridium.aaphp.enums.BAaPhpTerminalJobRecordTypeEnum;
import com.tridium.aaphp.messages.AaPhpCloseVirtualTerminalRequest;
import com.tridium.aaphp.messages.AaPhpMessageConst;
import com.tridium.aaphp.messages.AaPhpOpenVirtualTerminalRequest;
import com.tridium.aaphp.messages.AaPhpSimpleAckResponse;
import com.tridium.aaphp.messages.AaPhpVirtualTerminalRequest;
import com.tridium.aaphp.messages.AaPhpVirtualTerminalResponse;
import java.util.StringTokenizer;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="setCommand", parameterType="BString", defaultValue="BString.make(\"\")", flags=2048)
@NiagaraTopic(name="textReceived")
public class BAaPhpVirtualTerminalJob
extends BSimpleJob
implements AaPhpMessageConst {
    @Generated
    public static final Action setCommand = BAaPhpVirtualTerminalJob.newAction((int)2048, (BValue)BString.make((String)""), null);
    @Generated
    public static final Topic textReceived = BAaPhpVirtualTerminalJob.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAaPhpVirtualTerminalJob.class);
    private BAaPhpDevice device;
    private BAaPhpStarNetwork network;
    private Object stringLock = new Object();
    private String keystrokes = "";
    private KeyLogBuffer klb = new KeyLogBuffer();

    @Generated
    public void setCommand(BString parameter) {
        this.invoke(setCommand, (BValue)parameter, null);
    }

    @Generated
    public void fireTextReceived(BValue event) {
        this.fire(textReceived, event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAaPhpVirtualTerminalJob() {
    }

    public BAaPhpVirtualTerminalJob(BAaPhpDevice device) {
        this.device = device;
        this.network = (BAaPhpStarNetwork)device.getNetwork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String unloggedResults = "";
        try {
            if (this.device == null) {
                throw new IllegalStateException("Must submit thru a AaPhpDevice.submitTerminalJob()");
            }
            this.logMessage("Starting job");
            this.closeVirtualTerminal(false);
            if (!this.openVirtualTerminal()) {
                this.failed((Throwable)new LocalizableRuntimeException("aaphp", "virtualTerminal.openFailed"));
                this.logMessage("failed to open virtual terminal");
                return;
            }
            while (this.isAlive()) {
                String results;
                this.heartbeat();
                String commandLine = this.getKeystrokes();
                if (commandLine.length() == 0) {
                    results = this.requestTerminalData("");
                } else {
                    this.klb.append(commandLine);
                    results = this.requestTerminalData(commandLine);
                }
                if (results.length() != 0) {
                    unloggedResults = this.logResults(unloggedResults + results);
                    this.fireTextReceived((BValue)BString.make((String)results));
                }
                Thread.sleep(this.device.getTerminalModeInterMessageDelay().getMillis());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e) {
            this.logMessage("error:" + e.toString());
            this.closeVirtualTerminal(true);
            this.failed(e);
            return;
        }
        finally {
            if (unloggedResults.length() > 0) {
                this.logResults(unloggedResults + '\n');
            }
        }
        this.closeVirtualTerminal(true);
    }

    public void doSetCommand(BString cmd) {
        this.receiveKeystrokes(cmd.getString());
    }

    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.doCancel(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveKeystrokes(String more) {
        Object object = this.stringLock;
        synchronized (object) {
            this.keystrokes = this.keystrokes + more;
        }
    }

    private String logResults(String results) {
        boolean resultsEndsWithEndl = results.endsWith("\n");
        StringTokenizer st = new StringTokenizer(results, "\n");
        BIHistory hist = this.network.getTerminalHistory();
        try (HistorySpaceConnection conn = ((BHistorySpace)hist.getSpace()).getConnection(null);){
            while (st.hasMoreTokens()) {
                String nextLine = st.nextToken();
                if (!st.hasMoreTokens() && !resultsEndsWithEndl) {
                    String string = nextLine;
                    return string;
                }
                StringBuffer prettyNextLineBuffer = new StringBuffer();
                BAaPhpVirtualTerminalJob.appendPrettyString(nextLine, prettyNextLineBuffer, true);
                conn.append(hist, (BIHistoryRecordSet)new BAaPhpTerminalJobRecord("" + this.device.getAddress(), prettyNextLineBuffer.toString(), BAaPhpTerminalJobRecordTypeEnum.line));
                this.klb.recordHistory();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKeystrokes() {
        String latestKeystrokes;
        Object object = this.stringLock;
        synchronized (object) {
            latestKeystrokes = this.keystrokes;
            this.keystrokes = "";
        }
        return latestKeystrokes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String requestTerminalData(String data) throws Exception {
        BIHistory hist = this.network.getTerminalHistory();
        try (HistorySpaceConnection conn = ((BHistorySpace)hist.getSpace()).getConnection(null);){
            AaPhpVirtualTerminalRequest req = new AaPhpVirtualTerminalRequest(((BAaPhpNetwork)this.device.getNetwork()).translateAddress(this.device.getAddress()), data);
            AaPhpVirtualTerminalResponse rsp = (AaPhpVirtualTerminalResponse)this.device.getAaPhpNetwork().sendSync(req);
            if (rsp == null) {
                this.fireTextReceived((BValue)BString.make((String)"\ndevice timeout\n"));
                conn.append(hist, (BIHistoryRecordSet)new BAaPhpTerminalJobRecord("" + this.device.getAddress(), this.klb.toString(), BAaPhpTerminalJobRecordTypeEnum.error));
                conn.append(hist, (BIHistoryRecordSet)new BAaPhpTerminalJobRecord("" + this.device.getAddress(), "Response timeout requesting virtual terminal data", BAaPhpTerminalJobRecordTypeEnum.error));
                String string = "";
                return string;
            }
            if (rsp.isError()) {
                String errorString = rsp.getErrorMsg();
                this.fireTextReceived((BValue)BString.make((String)("\n" + errorString + "\n")));
                conn.append(hist, (BIHistoryRecordSet)new BAaPhpTerminalJobRecord("" + this.device.getAddress(), this.klb.toString(), BAaPhpTerminalJobRecordTypeEnum.error));
                conn.append(hist, (BIHistoryRecordSet)new BAaPhpTerminalJobRecord("" + this.device.getAddress(), "AaPhpError: " + errorString, BAaPhpTerminalJobRecordTypeEnum.error));
                throw new Exception("PhpError:" + errorString);
            }
            if (rsp.isEmpty()) {
                String string = "";
                return string;
            }
            String string = rsp.getMessageText();
            return string;
        }
    }

    private boolean openVirtualTerminal() {
        BRelTime timeout = BRelTime.make((long)(this.device.getAaPhpNetwork().getResponseTimeout().getMillis() * 3L));
        AaPhpOpenVirtualTerminalRequest req = new AaPhpOpenVirtualTerminalRequest(((BAaPhpNetwork)this.device.getNetwork()).translateAddress(this.device.getAddress()));
        AaPhpSimpleAckResponse rsp = (AaPhpSimpleAckResponse)this.device.getAaPhpNetwork().sendSync(req, timeout, 0);
        BIHistory hist = this.network.getTerminalHistory();
        try (HistorySpaceConnection conn = ((BHistorySpace)hist.getSpace()).getConnection(null);){
            if (rsp == null) {
                conn.append(hist, (BIHistoryRecordSet)new BAaPhpTerminalJobRecord("" + this.device.getAddress(), "Timeout opening virtual terminal", BAaPhpTerminalJobRecordTypeEnum.error));
                boolean bl = false;
                return bl;
            }
            if (rsp.isError()) {
                String errorString = rsp.getErrorMsg();
                conn.append(hist, (BIHistoryRecordSet)new BAaPhpTerminalJobRecord("" + this.device.getAddress(), "Error opening virtual terminal: " + errorString, BAaPhpTerminalJobRecordTypeEnum.error));
                boolean bl = false;
                return bl;
            }
            conn.append(hist, (BIHistoryRecordSet)new BAaPhpTerminalJobRecord("" + this.device.getAddress(), "Virtual terminal session started", BAaPhpTerminalJobRecordTypeEnum.status));
        }
        return true;
    }

    private boolean closeVirtualTerminal(boolean report) {
        if (report) {
            this.klb.recordHistory();
        }
        BRelTime timeout = BRelTime.make((long)(this.device.getAaPhpNetwork().getResponseTimeout().getMillis() * 4L));
        AaPhpCloseVirtualTerminalRequest req = new AaPhpCloseVirtualTerminalRequest(((BAaPhpNetwork)this.device.getNetwork()).translateAddress(this.device.getAddress()));
        AaPhpSimpleAckResponse rsp = (AaPhpSimpleAckResponse)this.device.getAaPhpNetwork().sendSync(req, timeout, 0);
        BIHistory hist = this.network.getTerminalHistory();
        try (HistorySpaceConnection conn = ((BHistorySpace)hist.getSpace()).getConnection(null);){
            if (rsp == null) {
                if (report) {
                    conn.append(hist, (BIHistoryRecordSet)new BAaPhpTerminalJobRecord("" + this.device.getAddress(), "Eror closing virtual terminal: No response", BAaPhpTerminalJobRecordTypeEnum.error));
                }
                if (report) {
                    this.logMessage("job end, device " + this.device.getAddress() + "::no response to close terminal command");
                }
                boolean bl = false;
                return bl;
            }
            if (rsp.isError()) {
                String errorString = rsp.getErrorMsg();
                if (report) {
                    conn.append(hist, (BIHistoryRecordSet)new BAaPhpTerminalJobRecord("" + this.device.getAddress(), "Error closing virtual terminal: " + errorString, BAaPhpTerminalJobRecordTypeEnum.error));
                }
                if (report) {
                    this.logMessage("job end, device " + this.device.getAddress() + "::error closing virtual terminal:" + errorString);
                }
                boolean bl = false;
                return bl;
            }
            conn.append(hist, (BIHistoryRecordSet)new BAaPhpTerminalJobRecord("" + this.device.getAddress(), "Virtual terminal session closed", BAaPhpTerminalJobRecordTypeEnum.status));
            this.logMessage("job end, device " + this.device.getAddress());
        }
        return true;
    }

    void logMessage(String message) {
        this.log().message(message);
        if (this.device.getAaPhpNetwork() != null) {
            int severity = this.device.getAaPhpNetwork().getLog().getSeverity();
            this.device.getAaPhpNetwork().getLog().setSeverity(1);
            this.device.getAaPhpNetwork().getLog().message("Virtual Terminal Job:" + message);
            this.device.getAaPhpNetwork().getLog().setSeverity(severity);
        }
    }

    static void appendPrettyString(String inString, StringBuffer sb, boolean unprintablesOnly) {
        char[] chars = inString.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > ' ' && chars[i] < '~') {
                sb.append(chars[i]);
                continue;
            }
            if (chars[i] == '\u007f') {
                sb.append("<DEL>");
                continue;
            }
            if (chars[i] == ' ') {
                if (!unprintablesOnly) {
                    sb.append("<SP>");
                    continue;
                }
                sb.append(chars[i]);
                continue;
            }
            if (chars[i] == '\u001b') {
                sb.append("<ESC>");
                continue;
            }
            if (chars[i] == '\r') {
                if (!unprintablesOnly) {
                    sb.append("<CR>");
                    continue;
                }
                sb.append(chars[i]);
                continue;
            }
            if (chars[i] == '\n') {
                sb.append("<LF>");
                continue;
            }
            if (chars[i] == '\t') {
                if (!unprintablesOnly) {
                    sb.append("<TAB>");
                    continue;
                }
                sb.append(chars[i]);
                continue;
            }
            if (chars[i] == '\b') {
                sb.append("<BS>");
                continue;
            }
            if (chars[i] == '\u0001') {
                sb.append("<CTL-A>");
                continue;
            }
            if (chars[i] == '\u000e') {
                sb.append("<CTL-E>");
                continue;
            }
            sb.append("<0x" + TextUtil.byteToHexString((int)((byte)chars[i] & 0xFF)) + ">");
        }
    }

    class KeyLogBuffer {
        StringBuffer sb = new StringBuffer();

        KeyLogBuffer() {
        }

        public String toString() {
            return this.sb.toString();
        }

        public void append(String newString) {
            BAaPhpVirtualTerminalJob.appendPrettyString(newString, this.sb, false);
        }

        public void recordHistory() {
            if (this.sb.length() > 0) {
                BIHistory hist = BAaPhpVirtualTerminalJob.this.network.getTerminalHistory();
                try (HistorySpaceConnection conn = ((BHistorySpace)hist.getSpace()).getConnection(null);){
                    conn.append(hist, (BIHistoryRecordSet)new BAaPhpTerminalJobRecord("" + BAaPhpVirtualTerminalJob.this.device.getAddress(), this.toString(), BAaPhpTerminalJobRecordTypeEnum.keystroke));
                }
                this.sb.delete(0, this.sb.length());
            }
        }
    }
}

