/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.job;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.job.BAaPhpWriteFileJob;
import com.tridium.aaphp.messages.AaPhpOpenFileResponse;
import com.tridium.aaphp.messages.AaPhpReadFileRequest;
import com.tridium.aaphp.messages.AaPhpReadFileResponse;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBlob;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BAaPhpReadFileJob
extends BAaPhpWriteFileJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BAaPhpReadFileJob.class);
    static final String LEX_RECV_AAPHP_FILE = "recvFile.recv.start";
    static final String LEX_RECV_UPDATE = "recvFile.recv.update";
    static final String LEX_RCVD_AAPHP_FILE = "recvFile.recv.done";
    static final String LEX_RECV_FILE_TIMEOUT = "recvFile.recv.timeout";
    static final String LEX_RECV_FILE_ERROR = "recvFile.recv.aaphpError";
    static final String LEX_RECV_FILE_ERROR_N = "recvFile.recv.niagaraError";
    static final String LEX_RECV_COMPLETE = "recvFile.complete";
    int numRecvRecords = 0;
    final BOrd niagaraFile;
    final OutputStream recvDest;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAaPhpReadFileJob() {
        this.niagaraFile = null;
        this.recvDest = null;
    }

    public BAaPhpReadFileJob(BAaPhpNetwork aaphpNet, int unitNumberAddress, String aaphpFileOrd, BOrd niagaraFile, OutputStream dest) {
        super(aaphpNet, unitNumberAddress, BBlob.DEFAULT, aaphpFileOrd);
        this.niagaraFile = niagaraFile;
        this.recvDest = dest;
    }

    @Override
    AaPhpOpenFileResponse openAaPhpFile() {
        AaPhpOpenFileResponse openAaPhpFileRsp = super.openAaPhpFile();
        this.numRecvRecords = openAaPhpFileRsp.getFileSize();
        return openAaPhpFileRsp;
    }

    private void recvRecord(char fileNum, int recNum, int a, int b) throws EOFException {
        AaPhpReadFileResponse recvRsp = (AaPhpReadFileResponse)this.aaphpNet.sendSync(new AaPhpReadFileRequest(this.unitNumberAddress, recNum, fileNum));
        if (recvRsp == null || recvRsp.isError()) {
            if (recvRsp == null) {
                throw BAaPhpReadFileJob.lexError(LEX_RECV_FILE_TIMEOUT, new Object[]{Integer.toString(recNum), this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress), ""});
            }
            if (recvRsp.isError()) {
                if (recvRsp.getErrorClass().equals("04") && recvRsp.getErrorNumber().equals("00")) {
                    throw new EOFException();
                }
                String dumpData = BAaPhpReadFileJob.dumpToString(recvRsp.getRecvData(), 0, recvRsp.getRecvData().length);
                throw BAaPhpReadFileJob.lexError(LEX_RECV_FILE_ERROR, new Object[]{Integer.toString(recNum), this.aaphpFileOrdFriendly, Integer.toString(this.unitNumberAddress), "\n" + dumpData});
            }
        } else {
            try {
                this.recvDest.write(recvRsp.getRecvData());
                this.recvDest.flush();
            }
            catch (IOException ioe) {
                String dumpData = BAaPhpReadFileJob.dumpToString(recvRsp.getRecvData(), 0, recvRsp.getRecvData().length);
                throw BAaPhpReadFileJob.lexError(LEX_RECV_FILE_ERROR_N, new Object[]{Integer.toString(recNum), this.aaphpFileOrdFriendly, this.niagaraFile, "\n" + dumpData, "\n" + ioe.getLocalizedMessage()});
            }
        }
    }

    private void recvAaPhpFile() {
        this.lexLog(LEX_RECV_AAPHP_FILE);
        long delta = 0L;
        long sumDelta = 0L;
        long avgDelta = 0L;
        long remainingTime = 0L;
        long tick1 = 0L;
        long tick2 = 0L;
        try {
            int a = 0;
            for (int recNum = 0; recNum < this.numRecvRecords; ++recNum) {
                tick1 = Clock.ticks();
                if (recNum > 5) {
                    this.logMessage(BAaPhpDevice.LEXICON.getText(LEX_RECV_UPDATE, new Object[]{BRelTime.toString((long)remainingTime)}));
                }
                this.recvRecord(this.fileNum, recNum, a, a + 128);
                this.progress((int)((float)recNum / (float)this.numRecvRecords * 100.0f));
                tick2 = Clock.ticks();
                delta = tick2 - tick1;
                avgDelta = (sumDelta += delta) / (long)(recNum + 1);
                remainingTime = (long)(this.numRecvRecords - recNum) * avgDelta;
                a += 128;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.lexLog(LEX_RCVD_AAPHP_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Context cx) throws Exception {
        long tick1 = Clock.ticks();
        try {
            this.closeAaPhpFile(true);
            this.openAaPhpFile();
            this.recvAaPhpFile();
        }
        finally {
            this.closeAaPhpFile(false);
            this.recvDest.close();
        }
        long tick2 = Clock.ticks();
        this.logMessage(BAaPhpDevice.LEXICON.getText(LEX_RECV_COMPLETE, new Object[]{BRelTime.toString((long)(tick2 - tick1))}));
    }

    @Override
    void logMessage(String message) {
        this.log().message(message);
        if (this.aaphpNet != null) {
            int severity = this.aaphpNet.getLog().getSeverity();
            this.aaphpNet.getLog().setSeverity(1);
            this.aaphpNet.getLog().message("Read File Job:" + message);
            this.aaphpNet.getLog().setSeverity(severity);
        }
    }
}

