/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.point;

import com.tridium.ndriver.BNNetwork;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.point.BMicrosProxyExt;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.control.BBooleanPoint;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="out", type="baja:StatusNumeric", defaultValue="new BStatusNumeric()", flags=267), @NiagaraProperty(name="facets", type="baja:Facets", defaultValue="BFacets.makeNumeric(UnitDatabase.getUnit(\"celsius\"), 2)"), @NiagaraProperty(name="propagateFlags", type="baja:Status", defaultValue="BStatus.nullStatus"), @NiagaraProperty(name="inOccupancySelect", type="baja:StatusBoolean", defaultValue="new BStatusBoolean(false)", flags=11), @NiagaraProperty(name="inPreArrivalSelect", type="baja:StatusEnum", defaultValue="new BStatusEnum()", flags=11), @NiagaraProperty(name="inOccupancySetpoint", type="baja:StatusNumeric", defaultValue="new BStatusNumeric(21)", flags=8), @NiagaraProperty(name="inPreArrivalSetpoint", type="baja:StatusNumeric", defaultValue="new BStatusNumeric(18)", flags=8), @NiagaraProperty(name="fallbackSetpoint", type="baja:StatusNumeric", defaultValue="new BStatusNumeric(5)", flags=8), @NiagaraProperty(name="inPreArrivalScaleCs0", type="int", defaultValue="25", flags=8, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"percent\")"), @Facet(name="BFacets.MIN", value="BInteger.make(0)"), @Facet(name="BFacets.MAX", value="BInteger.make(100)")}), @NiagaraProperty(name="inPreArrivalScaleCs1", type="int", defaultValue="50", flags=8, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"percent\")"), @Facet(name="BFacets.MIN", value="BInteger.make(0)"), @Facet(name="BFacets.MAX", value="BInteger.make(100)")}), @NiagaraProperty(name="inPreArrivalScaleCs2", type="int", defaultValue="75", flags=8, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"percent\")"), @Facet(name="BFacets.MIN", value="BInteger.make(0)"), @Facet(name="BFacets.MAX", value="BInteger.make(100)")}), @NiagaraProperty(name="inPreArrivalScaleCs3", type="int", defaultValue="100", flags=8, facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"percent\")"), @Facet(name="BFacets.MIN", value="BInteger.make(0)"), @Facet(name="BFacets.MAX", value="BInteger.make(100)")})})
public class BMicrosSetpointSelect
extends BComponent
implements BIStatus,
BINumeric {
    public static final Property out = BMicrosSetpointSelect.newProperty((int)267, (BValue)new BStatusNumeric(), null);
    public static final Property facets = BMicrosSetpointSelect.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"celsius"), (int)2), null);
    public static final Property propagateFlags = BMicrosSetpointSelect.newProperty((int)0, (BValue)BStatus.nullStatus, null);
    public static final Property inOccupancySelect = BMicrosSetpointSelect.newProperty((int)11, (BValue)new BStatusBoolean(false), null);
    public static final Property inPreArrivalSelect = BMicrosSetpointSelect.newProperty((int)11, (BValue)new BStatusEnum(), null);
    public static final Property inOccupancySetpoint = BMicrosSetpointSelect.newProperty((int)8, (BValue)new BStatusNumeric(21.0), null);
    public static final Property inPreArrivalSetpoint = BMicrosSetpointSelect.newProperty((int)8, (BValue)new BStatusNumeric(18.0), null);
    public static final Property fallbackSetpoint = BMicrosSetpointSelect.newProperty((int)8, (BValue)new BStatusNumeric(5.0), null);
    public static final Property inPreArrivalScaleCs0 = BMicrosSetpointSelect.newProperty((int)8, (int)25, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"percent")), (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0))), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)100))));
    public static final Property inPreArrivalScaleCs1 = BMicrosSetpointSelect.newProperty((int)8, (int)50, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"percent")), (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0))), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)100))));
    public static final Property inPreArrivalScaleCs2 = BMicrosSetpointSelect.newProperty((int)8, (int)75, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"percent")), (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0))), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)100))));
    public static final Property inPreArrivalScaleCs3 = BMicrosSetpointSelect.newProperty((int)8, (int)100, (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"percent")), (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0))), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)100))));
    public static final Type TYPE = Sys.loadType(BMicrosSetpointSelect.class);
    private BMicrosProxyExt parentProxy;
    private Logger log;
    private static final BIcon icon = BIcon.std((String)"control/util/switch.png");
    private static final String INVALID_FACET = "invalidSelect";
    private static final String LINK_ERR_MSG = TYPE.getTypeName() + " must be parented by MicrosProxyExt";
    private static final int MINSELECT = 0;
    private static final int MAXSELECT = 3;
    private boolean isLinked;

    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    public void setOut(BStatusNumeric v) {
        this.set(out, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BStatus getPropagateFlags() {
        return (BStatus)this.get(propagateFlags);
    }

    public void setPropagateFlags(BStatus v) {
        this.set(propagateFlags, (BValue)v, null);
    }

    public BStatusBoolean getInOccupancySelect() {
        return (BStatusBoolean)this.get(inOccupancySelect);
    }

    public void setInOccupancySelect(BStatusBoolean v) {
        this.set(inOccupancySelect, (BValue)v, null);
    }

    public BStatusEnum getInPreArrivalSelect() {
        return (BStatusEnum)this.get(inPreArrivalSelect);
    }

    public void setInPreArrivalSelect(BStatusEnum v) {
        this.set(inPreArrivalSelect, (BValue)v, null);
    }

    public BStatusNumeric getInOccupancySetpoint() {
        return (BStatusNumeric)this.get(inOccupancySetpoint);
    }

    public void setInOccupancySetpoint(BStatusNumeric v) {
        this.set(inOccupancySetpoint, (BValue)v, null);
    }

    public BStatusNumeric getInPreArrivalSetpoint() {
        return (BStatusNumeric)this.get(inPreArrivalSetpoint);
    }

    public void setInPreArrivalSetpoint(BStatusNumeric v) {
        this.set(inPreArrivalSetpoint, (BValue)v, null);
    }

    public BStatusNumeric getFallbackSetpoint() {
        return (BStatusNumeric)this.get(fallbackSetpoint);
    }

    public void setFallbackSetpoint(BStatusNumeric v) {
        this.set(fallbackSetpoint, (BValue)v, null);
    }

    public int getInPreArrivalScaleCs0() {
        return this.getInt(inPreArrivalScaleCs0);
    }

    public void setInPreArrivalScaleCs0(int v) {
        this.setInt(inPreArrivalScaleCs0, v, null);
    }

    public int getInPreArrivalScaleCs1() {
        return this.getInt(inPreArrivalScaleCs1);
    }

    public void setInPreArrivalScaleCs1(int v) {
        this.setInt(inPreArrivalScaleCs1, v, null);
    }

    public int getInPreArrivalScaleCs2() {
        return this.getInt(inPreArrivalScaleCs2);
    }

    public void setInPreArrivalScaleCs2(int v) {
        this.setInt(inPreArrivalScaleCs2, v, null);
    }

    public int getInPreArrivalScaleCs3() {
        return this.getInt(inPreArrivalScaleCs3);
    }

    public void setInPreArrivalScaleCs3(int v) {
        this.setInt(inPreArrivalScaleCs3, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        try {
            this.parentProxy = (BMicrosProxyExt)this.getParent();
            if (this.parentProxy != null) {
                this.log = ((BNNetwork)this.parentProxy.getNetwork()).log();
                this.linkTo((BComponent)this.parentProxy, (Slot)BMicrosProxyExt.preArrival, (Slot)inPreArrivalSelect);
                BBooleanPoint parentPoint = (BBooleanPoint)this.parentProxy.getParentPoint();
                if (parentPoint != null) {
                    this.linkTo((BComponent)parentPoint, (Slot)BBooleanPoint.out, (Slot)inOccupancySelect);
                }
                this.isLinked = true;
            }
        }
        catch (RuntimeException e) {
            if (this.log != null) {
                this.log.log(Level.CONFIG, LINK_ERR_MSG, e);
            }
            CommonUtil.globalLog.log(Level.WARNING, LINK_ERR_MSG, e);
        }
    }

    public void changed(Property property, Context context) {
        block8: {
            if (!this.isRunning() || !this.isLinked || property.equals(out) || property.equals(facets)) {
                return;
            }
            if (this.getInOccupancySelect().getBoolean() && this.getInOccupancySetpoint().getStatus().isValid()) {
                this.applyOutValueFromExisting(this.getInOccupancySetpoint());
                return;
            }
            if (this.getInPreArrivalSelect().getStatus().isValid() && this.getInPreArrivalSetpoint().getStatus().isValid()) {
                int selectValue = this.getInPreArrivalSelect().getValue().getOrdinal();
                if (selectValue < 0) {
                    selectValue = 0;
                } else if (selectValue >= 3) {
                    selectValue = 3;
                }
                double preSetPoint = this.getInPreArrivalSetpoint().getNumeric();
                double preDivideBy = this.getInScaleValue(selectValue);
                try {
                    this.applyNewOutValue(new BStatusNumeric(preSetPoint / 100.0 * preDivideBy));
                    return;
                }
                catch (RuntimeException e) {
                    this.log.info("SetpointSelect could not calculate % (" + preSetPoint + "/100)*" + preDivideBy);
                    if (!this.log.isLoggable(Level.FINE)) break block8;
                    this.log.log(Level.FINE, "Setpoint calculation error", e);
                }
            }
        }
        this.useFallbackValue();
    }

    private void useFallbackValue() {
        if (!this.getFallbackSetpoint().isNull()) {
            this.applyOutValueFromExisting(this.getFallbackSetpoint());
        } else {
            this.log.info(this.getSlotPathOrd() + " Cannot use null fallback ?");
        }
    }

    private void applyOutValueFromExisting(BStatusNumeric value) {
        if (value != null) {
            this.applyNewOutValue((BStatusNumeric)value.newCopy());
        }
    }

    private void applyNewOutValue(BStatusNumeric value) {
        if (value != null) {
            value.setStatus(this.propagate(value.getStatus()));
            if (!this.getOut().equals((Object)value)) {
                this.setOut(value);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(this.parentProxy.getName() + ' ' + this.getName() + " output = " + value.toString());
                }
            }
            BStatus s = this.getStatus();
            this.setOutStatus(BStatus.make((int)s.getBits(), (BFacets)BFacets.makeRemove((BFacets)s.getFacets(), (String)INVALID_FACET)));
        } else {
            this.setOutStatus(BStatus.make((BStatus)this.getStatus(), (String)INVALID_FACET, (boolean)true));
        }
    }

    private void setOutStatus(BStatus status) {
        this.getOut().setStatus(status);
    }

    private BStatus propagate(BStatus s) {
        return BStatus.make((int)(s.getBits() & this.getPropagateFlags().getBits()));
    }

    private int getInScaleValue(int select) {
        switch (select) {
            default: {
                return this.getInPreArrivalScaleCs0();
            }
            case 1: {
                return this.getInPreArrivalScaleCs1();
            }
            case 2: {
                return this.getInPreArrivalScaleCs2();
            }
            case 3: 
        }
        return this.getInPreArrivalScaleCs3();
    }

    public BFacets getSlotFacets(Slot slot) {
        if ("out".equals(slot.getName())) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BStatus getStatus() {
        return this.getOut().getStatus();
    }

    public double getNumeric() {
        return this.getOut().getValue();
    }

    public final BFacets getNumericFacets() {
        return this.getOut().getStatus().getFacets();
    }

    public boolean isParentLegal(BComponent parent) {
        return CommonUtil.isParentLegal((BComplex)parent, (BComplex)this, BMicrosProxyExt.TYPE);
    }

    public String toString(Context cx) {
        return this.getOut().toString(cx);
    }

    public String toTraceString() {
        Property[] properties;
        StringBuilder dbg = new StringBuilder(this.getName()).append(":\n\t");
        for (Property p : properties = new Property[]{out, inOccupancySelect, inPreArrivalSelect, inPreArrivalSetpoint, inOccupancySetpoint, fallbackSetpoint, inPreArrivalScaleCs0, inPreArrivalScaleCs1, inPreArrivalScaleCs2, inPreArrivalScaleCs3}) {
            dbg.append(p.getName()).append(" : ").append(this.get(p)).append("\n\t");
        }
        if (this.parentProxy != null) {
            try {
                dbg.append("ReadValue : ").append(this.parentProxy.getReadValue());
            }
            catch (Exception e) {
                dbg.append("Cannot access parent proxy?");
            }
        }
        return dbg.toString();
    }

    public BIcon getIcon() {
        return icon;
    }
}

