/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.point;

import com.tridium.ndriver.point.BNProxyExt;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.datatype.BMicrosGuestData;
import com.tridiumemea.micros.datatype.config.BMicrosLinkConfig;
import com.tridiumemea.micros.enums.BMicrosRoomEquipmentServiceEnum;
import com.tridiumemea.micros.message.MicrosDictionary;
import com.tridiumemea.micros.point.BMicrosPointDeviceExt;
import java.util.logging.Level;
import javax.baja.control.BBooleanPoint;
import javax.baja.driver.point.BDefaultProxyConversion;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="roomNumber", type="baja:String", defaultValue="BString.make(MicrosDictionary.UNSET_ROOM_NUMBER)"), @NiagaraProperty(name="guestReservationNumber", type="int", defaultValue="MicrosDictionary.UNSET_GUEST_NUMBER", flags=65), @NiagaraProperty(name="preArrival", type="baja:StatusEnum", defaultValue="new BStatusEnum(BMicrosRoomEquipmentServiceEnum.DEFAULT, BStatus.stale)", flags=65603), @NiagaraProperty(override=true, name="readValue", type="StatusValue", flags=1, defaultValue="new BStatusString(\"-\")"), @NiagaraProperty(override=true, name="enabled", type="boolean", flags=4, defaultValue="true"), @NiagaraProperty(override=true, name="deviceFacets", type="Facets", flags=4, defaultValue="BFacets.NULL"), @NiagaraProperty(override=true, name="conversion", type="ProxyConversion", flags=4, defaultValue="BDefaultProxyConversion.DEFAULT"), @NiagaraProperty(override=true, name="writeValue", type="StatusValue", flags=7, defaultValue="new BStatusString(\"-\")"), @NiagaraProperty(override=true, name="tuningPolicyName", type="String", flags=4, defaultValue="defaultPolicy")})
public final class BMicrosProxyExt
extends BNProxyExt {
    public static final Property roomNumber = BMicrosProxyExt.newProperty((int)0, (BValue)BString.make((String)MicrosDictionary.UNSET_ROOM_NUMBER), null);
    public static final Property guestReservationNumber = BMicrosProxyExt.newProperty((int)65, (int)MicrosDictionary.UNSET_GUEST_NUMBER, null);
    public static final Property preArrival = BMicrosProxyExt.newProperty((int)65603, (BValue)new BStatusEnum((BEnum)BMicrosRoomEquipmentServiceEnum.DEFAULT, BStatus.stale), null);
    public static final Property readValue = BMicrosProxyExt.newProperty((int)1, (BValue)new BStatusString("-"), null);
    public static final Property enabled = BMicrosProxyExt.newProperty((int)4, (boolean)true, null);
    public static final Property deviceFacets = BMicrosProxyExt.newProperty((int)4, (BValue)BFacets.NULL, null);
    public static final Property conversion = BMicrosProxyExt.newProperty((int)4, (BValue)BDefaultProxyConversion.DEFAULT, null);
    public static final Property writeValue = BMicrosProxyExt.newProperty((int)7, (BValue)new BStatusString("-"), null);
    public static final Property tuningPolicyName = BMicrosProxyExt.newProperty((int)4, (String)"defaultPolicy", null);
    public static final Type TYPE = Sys.loadType(BMicrosProxyExt.class);
    private String oldRoomNumber = MicrosDictionary.UNSET_ROOM_NUMBER;
    private BMicrosNetwork network;
    private static final Lexicon lex = Lexicon.make(BMicrosProxyExt.class);
    private static final String RE_CS_OUT_OF_RANGE = "MicrosProxyExt: RoomEquipment Enum out of range @ '";
    private static final String RE_CS_OUT_OF_RANGE_P2 = "' for room: ";
    private static final String STOP_ERR_MSG = "MicrosProxyExt: Could not unregister proxy ext in stopped()";
    private static final String DUPLICATE_ROOM_NUMBER = lex.getText("microsProxyExt.duplicate.room.number");
    private static final String INVALID_ROOM_NUMBER = lex.getText("microsProxyExt.invalid.room.number");

    public String getRoomNumber() {
        return this.getString(roomNumber);
    }

    public void setRoomNumber(String v) {
        this.setString(roomNumber, v, null);
    }

    public int getGuestReservationNumber() {
        return this.getInt(guestReservationNumber);
    }

    public void setGuestReservationNumber(int v) {
        this.setInt(guestReservationNumber, v, null);
    }

    public BStatusEnum getPreArrival() {
        return (BStatusEnum)this.get(preArrival);
    }

    public void setPreArrival(BStatusEnum v) {
        this.set(preArrival, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    private BMicrosNetwork getMicrosNetwork() {
        return (BMicrosNetwork)this.getNetwork();
    }

    public void readSubscribed(Context cx) throws Exception {
    }

    public void readUnsubscribed(Context cx) throws Exception {
    }

    public boolean write(Context cx) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Type getDeviceExtType() {
        return BMicrosPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readonly;
    }

    public void started() throws Exception {
        super.started();
        this.readReset();
        if (!this.isRunning()) {
            return;
        }
        this.network = this.getMicrosNetwork();
        if (this.network == null) {
            CommonUtil.globalLog.warning(this.getParent().getName() + " cannot find network");
            return;
        }
        this.checkForDuplicateRoomNumber();
        this.network.getDevice().getPoints().registerProxyExt(this);
        this.oldRoomNumber = this.getRoomNumber();
        this.updateRoomEquipmentStatus();
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(roomNumber)) {
            this.checkForDuplicateRoomNumber();
            if (!this.isUnsetRoomNumber() && this.oldRoomNumber != null) {
                this.network.getDevice().getPoints().updateProxyExt(this.oldRoomNumber, this);
                this.oldRoomNumber = this.getRoomNumber();
            }
        }
    }

    public void stopped() throws Exception {
        if (!this.isFault()) {
            try {
                this.network.getDevice().getPoints().unregisterProxyExt(this);
            }
            catch (RuntimeException e) {
                this.network.log().log(Level.INFO, STOP_ERR_MSG, e);
            }
        } else {
            this.network.log().log(Level.INFO, "Point not removed from proxyExtMap due to config error: " + this.getName() + ':' + this.getRoomNumber());
        }
        super.stopped();
    }

    private void checkForDuplicateRoomNumber() {
        this.network.log().fine(() -> "checkForDuplicateRoomNumber:" + this.getRoomNumber());
        String causeOfFault = "";
        if (this.isUnsetRoomNumber()) {
            causeOfFault = INVALID_ROOM_NUMBER;
            this.readReset();
            this.network.log().finest(() -> "BMicrosProxyExt: existing unset room number " + this.getSlotPathOrd() + ':' + this.getRoomNumber() + ' ' + this.getStatus());
        } else {
            BMicrosProxyExt dup = this.network.getDevice().getPoints().lookupProxyExt(this.getRoomNumber());
            if (dup != null && dup != this) {
                String msg = DUPLICATE_ROOM_NUMBER + " [" + this.getParent().getName() + ": " + this.getRoomNumber() + ']';
                this.setRoomNumber(MicrosDictionary.UNSET_ROOM_NUMBER);
                this.network.log().info(msg);
                causeOfFault = msg;
            }
        }
        if (!causeOfFault.isEmpty()) {
            this.configFatal(causeOfFault);
        } else {
            this.setFaultCause(causeOfFault);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            this.executePoint();
        }
    }

    boolean isUnsetRoomNumber() {
        return this.getRoomNumber().equals(MicrosDictionary.UNSET_ROOM_NUMBER);
    }

    public void setRoomEquipmentValueRecieved(Integer cs) {
        int currentBits = this.getPreArrival().getStatus().getBits();
        if (!BMicrosRoomEquipmentServiceEnum.DEFAULT.getRange().isOrdinal(cs.intValue())) {
            StringBuilder fault = new StringBuilder(RE_CS_OUT_OF_RANGE);
            fault.append(cs).append(RE_CS_OUT_OF_RANGE_P2).append(this.getRoomNumber());
            this.getMicrosNetwork().log().warning(fault.toString());
            this.setFaultCause(fault.toString());
            if (!this.getPreArrival().getStatus().isFault()) {
                this.updateRoomEquipmentStatus(currentBits | 2);
            }
        } else {
            this.getPreArrival().setValue((BEnum)BMicrosRoomEquipmentServiceEnum.make(cs));
            this.setFaultCause("");
            if (this.getPreArrival().getStatus().isStale()) {
                this.updateRoomEquipmentStatus(currentBits ^ 0x10);
            }
            if (this.getPreArrival().getStatus().isFault()) {
                this.updateRoomEquipmentStatus(currentBits ^ 2);
            }
        }
    }

    public void updateRoomEquipmentStatus() {
        int newBits;
        int oldBits = this.getPreArrival().getStatus().getBits();
        if (this.network.getLinkConfig().getPreArrivalConfig().getEnablePreArrival()) {
            newBits = oldBits & 0xFFFFFFFE;
            newBits |= 0x10;
        } else {
            newBits = oldBits | 1;
        }
        this.updateRoomEquipmentStatus(newBits);
    }

    private void updateRoomEquipmentStatus(int newBits) {
        this.getPreArrival().setStatus(BStatus.make((BStatus)this.getPreArrival().getStatus(), (int)newBits));
    }

    public void updateData(BStruct newData) {
        BStruct currentData = (BStruct)this.getMixIn(newData.getType());
        if (currentData != null) {
            currentData.copyFrom((BComplex)newData);
        } else {
            this.network.log().warning(this.getSlotPathOrd() + " Could not find slot to update for " + newData);
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return CommonUtil.isParentLegal((BComplex)parent, (BComplex)this, BBooleanPoint.TYPE);
    }

    public void checkIn(Integer guestNumber) {
        this.readOk((BStatusValue)new BStatusBoolean(true));
        if (guestNumber != null) {
            this.setGuestReservationNumber(guestNumber);
        }
    }

    public void checkOut() {
        BMicrosLinkConfig linkConfig = this.network.getLinkConfig();
        this.readOk((BStatusValue)new BStatusBoolean(false));
        this.setGuestReservationNumber(MicrosDictionary.UNSET_GUEST_NUMBER);
        if (linkConfig.getEnableGuestData()) {
            this.updateData(new BMicrosGuestData());
        }
    }
}

