/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.point;

import com.tridium.ndriver.discover.BINDiscoveryObject;
import com.tridium.ndriver.discover.BNDiscoveryPreferences;
import com.tridium.ndriver.point.BNPointDeviceExt;
import com.tridiumemea.micros.BMicrosDevice;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.comm.BMicrosListener;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.datatype.BMicrosGuestData;
import com.tridiumemea.micros.datatype.BMicrosRoomRights;
import com.tridiumemea.micros.datatype.config.BMicrosLinkConfig;
import com.tridiumemea.micros.job.BMicrosDatabaseSyncJob;
import com.tridiumemea.micros.message.roomguest.MicrosGuest;
import com.tridiumemea.micros.point.BMicrosPointFolder;
import com.tridiumemea.micros.point.BMicrosProxyExt;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.point.BProxyExt;
import javax.baja.job.JobLogItem;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(override=true, name="discoveryPreferences", type="BNDiscoveryPreferences", defaultValue="new BNDiscoveryPreferences()", flags=4)
public final class BMicrosPointDeviceExt
extends BNPointDeviceExt {
    public static final Property discoveryPreferences = BMicrosPointDeviceExt.newProperty((int)4, (BValue)new BNDiscoveryPreferences(), null);
    public static final Type TYPE = Sys.loadType(BMicrosPointDeviceExt.class);
    private final HashMap<String, BMicrosProxyExt> proxyExtMap = new HashMap();
    private static final Lexicon lex = Lexicon.make(BMicrosNetwork.class);
    private BMicrosNetwork network;
    private Logger log;
    private static final String guestLicenseFeature = "guest.data";
    private static final String rightsLicenseFeature = "room.rights";
    private static final String ABORT_CHECKOUTS = "BMicrosPointDeviceExt: Aborted Assumed Checkout Routine";
    private static final String AUTO_CHECKOUT_LOG = "  " + lex.getText("ds.assume.checkout");

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.network = (BMicrosNetwork)this.getNetwork();
        if (this.network == null) {
            return;
        }
        this.log = this.network.log();
        this.toggleMixIn(TOGGLE_OPTION.GUEST_DATA);
        this.toggleMixIn(TOGGLE_OPTION.ROOM_RIGHTS);
    }

    public void stopped() {
        this.getComponentSpace().disableMixIn(BMicrosGuestData.TYPE);
        this.getComponentSpace().disableMixIn(BMicrosRoomRights.TYPE);
    }

    public void toggleMixIn(TOGGLE_OPTION toggle) {
        boolean isPropEnabled;
        Type propMixInType;
        String propLicenseAttribute;
        BMicrosLinkConfig linkConfig = this.network.getLinkConfig();
        switch (toggle) {
            case GUEST_DATA: {
                propLicenseAttribute = guestLicenseFeature;
                propMixInType = BMicrosGuestData.TYPE;
                isPropEnabled = linkConfig.getEnableGuestData();
                break;
            }
            case ROOM_RIGHTS: {
                propLicenseAttribute = rightsLicenseFeature;
                propMixInType = BMicrosRoomRights.TYPE;
                isPropEnabled = linkConfig.getRoomRightsConfig().getEnableRoomRightsData();
                break;
            }
            default: {
                return;
            }
        }
        if (isPropEnabled && this.checkLicenseAttribute(propLicenseAttribute)) {
            this.getComponentSpace().enableMixIn(propMixInType);
            this.perProxyMixInBehaviourChanges(propMixInType, BEHAVIOR.SET_READONLY);
        } else {
            this.getComponentSpace().disableMixIn(propMixInType);
            this.perProxyMixInBehaviourChanges(propMixInType, BEHAVIOR.REMOVE_MIXIN);
        }
    }

    private void perProxyMixInBehaviourChanges(Type mixInType, BEHAVIOR behavior) {
        block3: {
            if (this.isRunning() && this.network.getEnabled()) {
                Runnable amendProxies = () -> {
                    HashMap<String, BMicrosProxyExt> hashMap = this.proxyExtMap;
                    synchronized (hashMap) {
                        for (Map.Entry<String, BMicrosProxyExt> entry : this.proxyExtMap.entrySet()) {
                            BMicrosProxyExt currentExt = entry.getValue();
                            Property p = currentExt.getProperty(BMicrosPointDeviceExt.getMixInSlotName(mixInType));
                            if (p == null) continue;
                            if (behavior == BEHAVIOR.SET_READONLY) {
                                int readOnlyFlag = currentExt.getFlags((Slot)p) | 1;
                                currentExt.setFlags((Slot)p, readOnlyFlag);
                                continue;
                            }
                            currentExt.remove(p);
                        }
                    }
                };
                try {
                    this.network.getAsync().post(amendProxies);
                }
                catch (BajaRuntimeException be) {
                    String errMsg = "Cannot modify proxyExt mixIn " + mixInType + " to " + (Object)((Object)behavior) + " when network or worker is disabled.";
                    if (!this.log.isLoggable(Level.FINE)) break block3;
                    this.log.log(Level.FINE, errMsg, be);
                }
            }
        }
    }

    private static String getMixInSlotName(Type appliedToType) {
        return appliedToType.getModule().getModuleName() + '_' + appliedToType.getTypeName();
    }

    public final boolean isGuestDataLicensed() {
        return this.checkLicenseAttribute(guestLicenseFeature);
    }

    public final boolean isRoomRightsLicensed() {
        return this.checkLicenseAttribute(rightsLicenseFeature);
    }

    private boolean checkLicenseAttribute(String attribute) {
        if (this.network == null) {
            return true;
        }
        try {
            return this.network.getLicenseFeature().getb(attribute, true);
        }
        catch (FeatureNotLicensedException fnle) {
            this.log.info("MicrosFidelio feature disabled by current license: " + attribute);
            return false;
        }
        catch (LicenseDatabaseException unexpected) {
            this.log.log(Level.WARNING, "Unexpected error checking license attribute: " + attribute, this.log.isLoggable(Level.FINE) ? unexpected : null);
            return true;
        }
    }

    public Type getDeviceType() {
        return BMicrosDevice.TYPE;
    }

    public Type getPointFolderType() {
        return BMicrosPointFolder.TYPE;
    }

    public Type getProxyExtType() {
        return BMicrosProxyExt.TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return CommonUtil.isParentLegal((BComplex)parent, (BComplex)this, BMicrosDevice.TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BMicrosProxyExt lookupProxyExt(String roomNumber) {
        HashMap<String, BMicrosProxyExt> hashMap = this.proxyExtMap;
        synchronized (hashMap) {
            return this.proxyExtMap.get(roomNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerProxyExt(BMicrosProxyExt proxyExt) {
        if (proxyExt.isUnsetRoomNumber()) {
            return;
        }
        this.log.finest(() -> "Adding proxyExtMap entry: " + proxyExt.getRoomNumber());
        HashMap<String, BMicrosProxyExt> hashMap = this.proxyExtMap;
        synchronized (hashMap) {
            this.proxyExtMap.put(proxyExt.getRoomNumber(), proxyExt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterProxyExt(BMicrosProxyExt proxyExt) {
        if (proxyExt.isUnsetRoomNumber()) {
            return;
        }
        this.log.finest(() -> "Removing proxyExtMap entry: " + proxyExt.getRoomNumber());
        HashMap<String, BMicrosProxyExt> hashMap = this.proxyExtMap;
        synchronized (hashMap) {
            this.proxyExtMap.remove(proxyExt.getRoomNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateProxyExt(String oldRoomNumber, BMicrosProxyExt proxyExt) {
        HashMap<String, BMicrosProxyExt> hashMap = this.proxyExtMap;
        synchronized (hashMap) {
            this.proxyExtMap.remove(oldRoomNumber);
            this.proxyExtMap.put(proxyExt.getRoomNumber(), proxyExt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllProxyExt() {
        HashMap<String, BMicrosProxyExt> hashMap = this.proxyExtMap;
        synchronized (hashMap) {
            this.proxyExtMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProxyExtCount() {
        HashMap<String, BMicrosProxyExt> hashMap = this.proxyExtMap;
        synchronized (hashMap) {
            return this.proxyExtMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllRoomEquipmentStatus() {
        HashMap<String, BMicrosProxyExt> hashMap = this.proxyExtMap;
        synchronized (hashMap) {
            this.proxyExtMap.entrySet().stream().map(Map.Entry::getValue).forEach(BMicrosProxyExt::updateRoomEquipmentStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllPointsStaleDuringDataSync() {
        HashMap<String, BMicrosProxyExt> hashMap = this.proxyExtMap;
        synchronized (hashMap) {
            this.proxyExtMap.entrySet().stream().map(Map.Entry::getValue).forEach(BProxyExt::readReset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unseenRoomCheckout(BMicrosDatabaseSyncJob currentJob) {
        int checkOutCount = 0;
        BMicrosListener listener = this.network.getEventListener();
        StringBuilder jobLogMsgSb = new StringBuilder(32);
        boolean departurePolityIsResetRE = this.network.getLinkConfig().getPreArrivalConfig().isDeparturePolicyReset();
        HashMap<String, BMicrosProxyExt> hashMap = this.proxyExtMap;
        synchronized (hashMap) {
            for (Map.Entry<String, BMicrosProxyExt> entry : this.proxyExtMap.entrySet()) {
                BMicrosProxyExt room;
                if (!currentJob.isAlive()) {
                    this.log.log(Level.WARNING, ABORT_CHECKOUTS);
                    return checkOutCount;
                }
                if (listener.getSwapFlagBuffer().contains(entry.getKey()) || (room = entry.getValue()).isUnoperational() || room.isUnsetRoomNumber()) continue;
                room.checkOut();
                if (departurePolityIsResetRE) {
                    MicrosGuest.Departure.resetRoomEquipment(room);
                }
                ++checkOutCount;
                jobLogMsgSb.append(AUTO_CHECKOUT_LOG);
                JobLogItem logItem = new JobLogItem(0, jobLogMsgSb.toString(), room.getRoomNumber());
                currentJob.logUnseenRoomCheckout(logItem);
                jobLogMsgSb.append(room.getRoomNumber());
                this.log.info(jobLogMsgSb.toString());
                jobLogMsgSb.setLength(0);
            }
        }
        return checkOutCount;
    }

    public BINDiscoveryObject[] getDiscoveryObjects(BNDiscoveryPreferences bnDiscoveryPreferences) throws Exception {
        return new BINDiscoveryObject[0];
    }

    private static enum BEHAVIOR {
        SET_READONLY,
        REMOVE_MIXIN;

    }

    public static enum TOGGLE_OPTION {
        GUEST_DATA,
        ROOM_RIGHTS;

    }
}

