/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.message.linkdown;

import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.message.MicrosMessage;
import com.tridiumemea.micros.message.MicrosUnsolicitedNotification;
import com.tridiumemea.micros.message.linkdown.MicrosLinkEndRequest;
import java.util.logging.Level;

public final class MicrosLinkEndResponseOrNotification
extends MicrosMessage
implements MicrosUnsolicitedNotification {
    private static final String LE_ERR_SEND = "MicrosLinkEndResponseOrNotification: Error sending Link End Ack Message ";
    private final boolean factoryDeterminedIsResponse;

    public MicrosLinkEndResponseOrNotification(boolean isResponse) {
        this.factoryDeterminedIsResponse = isResponse;
    }

    public boolean isResponse() {
        return this.factoryDeterminedIsResponse;
    }

    public Object getTag() {
        return "LinkEnd";
    }

    @Override
    public void unsolicitedAction(BMicrosNetwork network) {
        if (network.getEnabled() && !network.getLinkStatus().isLinkInActive()) {
            MicrosLinkEndRequest ackLinkEnd = new MicrosLinkEndRequest(network.getDevice().getAddress());
            try {
                network.sendAsync(ackLinkEnd);
            }
            catch (Exception e) {
                network.log().log(Level.WARNING, LE_ERR_SEND, e);
            }
        }
        network.getShutdownUtil().commonLinkDownSteps(lex.getText("le.rcv.unsol"));
    }
}

