/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.message;

import com.tridium.ndriver.io.TypedInputStream;
import com.tridiumemea.micros.comm.exception.MicrosMessageParserException;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.message.MicrosMessage;
import java.util.logging.Level;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BTime;
import javax.baja.sys.BajaRuntimeException;

final class MicrosMessageParser {
    private static final String NO_DATA_IN_FRAME = "No data in frame!";
    private static final String UNABLE_TO_PARSE_INT = ": Unable to parse Integer: ";
    private static final String DATE_PARSE_ERR = "Could not parse field date: ";
    private static final String TIME_PARSE_ERR = "Could not parse field time: ";
    private static final short OFFSET_BY_2000_YEARS = 2000;
    private static final byte REMOVE_A_MONTH_FOR_ZERO_BASED_ORDINAL = 1;
    private static final byte ZERO = 0;
    private static final byte TWO = 2;
    private static final byte FOUR = 4;
    private static final byte SIX = 6;

    private MicrosMessageParser() {
    }

    static void parse(MicrosMessage msg, TypedInputStream in) {
        String readStr = in.readString();
        if (readStr.length() <= 0) {
            throw new BajaRuntimeException(NO_DATA_IN_FRAME);
        }
        String[] dataArray = TextUtil.splitAndTrim((String)readStr, (char)'|');
        NumberFormatException fieldNotFound = null;
        for (String data : dataArray) {
            if (data.length() < 2) continue;
            String fieldType = data.substring(0, 2);
            Object newData = null;
            String dataStr = data.substring(2);
            switch (fieldType) {
                case "DA": {
                    newData = MicrosMessageParser.parseFieldDate(dataStr);
                    break;
                }
                case "TI": {
                    newData = MicrosMessageParser.parseFieldTime(dataStr);
                    break;
                }
                case "G#": 
                case "CS": {
                    try {
                        newData = Integer.valueOf(dataStr);
                    }
                    catch (NumberFormatException nfe) {
                        String err = MicrosMessageParser.class.getName() + UNABLE_TO_PARSE_INT + fieldType + ' ' + dataStr + " (" + msg.toString() + ')';
                        CommonUtil.globalLog.log(Level.WARNING, err, nfe);
                        fieldNotFound = nfe;
                    }
                    break;
                }
                default: {
                    if (dataStr.length() <= 0) break;
                    newData = dataStr;
                }
            }
            msg.add(fieldType, newData);
        }
        if (fieldNotFound != null) {
            throw fieldNotFound;
        }
    }

    private static BAbsTime parseFieldDate(String dateData) {
        if (dateData.length() == 6 && MicrosMessageParser.isNumeric(dateData)) {
            int year = Integer.parseInt(dateData.substring(0, 2));
            BMonth month = BMonth.make((int)(Integer.parseInt(dateData.substring(2, 4)) - 1));
            int day = Integer.parseInt(dateData.substring(4, 6));
            return BAbsTime.make((int)(year + 2000), (BMonth)month, (int)day);
        }
        throw new MicrosMessageParserException(DATE_PARSE_ERR + dateData);
    }

    private static BTime parseFieldTime(String timeData) {
        if (timeData.length() == 6 && MicrosMessageParser.isNumeric(timeData)) {
            int hour = Integer.parseInt(timeData.substring(0, 2));
            int minute = Integer.parseInt(timeData.substring(2, 4));
            int second = Integer.parseInt(timeData.substring(4, 6));
            return BTime.make((int)hour, (int)minute, (int)second);
        }
        throw new MicrosMessageParserException(TIME_PARSE_ERR + timeData);
    }

    private static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

