/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.message;

import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.io.TypedInputStream;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.message.MicrosMessageBuilder;
import com.tridiumemea.micros.message.MicrosMessageField;
import com.tridiumemea.micros.message.MicrosMessageParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.nre.util.Array;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BTime;
import javax.baja.sys.Clock;
import javax.baja.util.Lexicon;

public abstract class MicrosMessage
extends NMessage {
    private final Array<MicrosMessageField> fieldArray = new Array(MicrosMessageField.class);
    protected static final Lexicon lex = Lexicon.make(BMicrosNetwork.class);
    private static final String COULD_NOT_FIND_FIELD = "Could not find field type: ";
    private MicrosMessageField cachedIsAvailableField;

    protected MicrosMessage() {
    }

    protected MicrosMessage(BIpAddress address) {
        super((BAddress)address);
    }

    protected final void add(String fieldType) {
        this.fieldArray.add((Object)MicrosMessageField.make(fieldType));
    }

    public final void add(String fieldType, Object data) {
        this.fieldArray.add((Object)MicrosMessageField.make(fieldType, data));
    }

    protected final void addTimestamp() {
        BAbsTime date = Clock.time((int)1000);
        this.add("DA", date);
        this.add("TI", BTime.make((BAbsTime)date));
    }

    public final String getRecordID() {
        String id = "";
        if (this.fieldArray.size() > 0) {
            MicrosMessageField field = (MicrosMessageField)this.fieldArray.get(0);
            id = field.getFieldType();
        }
        return id;
    }

    public final boolean isAvailable(String fieldType) {
        for (MicrosMessageField microsMessageField : this.getFields()) {
            if (!microsMessageField.getFieldType().equals(fieldType)) continue;
            this.cachedIsAvailableField = microsMessageField;
            return true;
        }
        return false;
    }

    final MicrosMessageField[] getFields() {
        return (MicrosMessageField[])this.fieldArray.trim();
    }

    public final MicrosMessageField get(String fieldType) {
        if (this.cachedIsAvailableField != null && this.cachedIsAvailableField.getFieldType().equals(fieldType)) {
            MicrosMessageField retVal = this.cachedIsAvailableField;
            this.cachedIsAvailableField = null;
            return retVal;
        }
        MicrosMessageField f = null;
        for (MicrosMessageField microsMessageField : this.getFields()) {
            if (!microsMessageField.getFieldType().equals(fieldType)) continue;
            f = microsMessageField;
            break;
        }
        if (f == null) {
            throw new IllegalArgumentException(COULD_NOT_FIND_FIELD + fieldType);
        }
        return f;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        for (MicrosMessageField microsMessageField : this.getFields()) {
            sb.append(microsMessageField.toString()).append('|');
        }
        sb.trimToSize();
        if (sb.length() > 0) {
            return sb.toString();
        }
        return "MicrosMessage could not summarize fields";
    }

    public String toTraceString() {
        return new StringBuilder(32).append(this.toString()).append(" [").append(this.getAddress() != null ? this.getAddress() : "Unknown").append(']').toString();
    }

    public final boolean toOutputStream(OutputStream out) throws IOException {
        byte[] msgAsBytes = MicrosMessageBuilder.build(this);
        out.write(msgAsBytes);
        return false;
    }

    public final void fromInputStream(InputStream in) {
        MicrosMessageParser.parse(this, (TypedInputStream)in);
    }
}

