/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.job;

import com.tridiumemea.micros.job.BMicrosDatabaseSyncJob;
import javax.baja.job.JobLogItem;
import javax.baja.util.Lexicon;

interface DatabaseSyncLoggable {
    default public void updateJobProgress(JobLogItem logItem, boolean isGuestIn, boolean roomFound) {
        BMicrosDatabaseSyncJob job = (BMicrosDatabaseSyncJob)this;
        job.log().add(logItem);
        if (!roomFound) {
            job.setUnknownRoomCount(job.getUnknownRoomCount() + 1);
        }
        if (isGuestIn) {
            job.setGuestInCount(job.getGuestInCount() + 1);
        } else {
            job.setGuestOutCount(job.getGuestOutCount() + 1);
        }
        job.setTimeLastRecordWasSeen();
    }

    default public void logUnseenRoomCheckout(JobLogItem logItem) {
        BMicrosDatabaseSyncJob job = (BMicrosDatabaseSyncJob)this;
        job.log().add(logItem);
    }

    default public void writeJobLogSummary(int proxyExtCount, int swapFlaggedBufferSize) {
        boolean SF_unreportedRooms;
        BMicrosDatabaseSyncJob job = (BMicrosDatabaseSyncJob)this;
        int totalReceived = job.getTotalRecievedCount();
        job.log().add(new JobLogItem(0, "    " + LABEL.JOB_SUMMARY_HEADER));
        job.log().add(new JobLogItem(0, LABEL.RCV_GUEST_IN_COUNT, this.strOf(job.getGuestInCount())));
        job.log().add(new JobLogItem(0, LABEL.RCV_GUEST_OUT_COUNT, this.strOf(job.getGuestOutCount())));
        job.log().add(new JobLogItem(this.iconFor(totalReceived > 0), LABEL.TOTAL_RCV_RECORD_COUNT, this.strOf(totalReceived)));
        job.log().add(new JobLogItem(this.iconFor(job.getUnknownRoomCount() == 0), LABEL.ROOM_UNKNOWN_COUNT, this.strOf(job.getUnknownRoomCount())));
        job.log().add(new JobLogItem(0, LABEL.REGISTERED_PROXY_EXT_COUNT, this.strOf(proxyExtCount)));
        job.log().add(new JobLogItem(this.iconFor(job.getAssumedCheckOutCount() == 0), LABEL.ASSUMED_CHECKOUT_COUNT, this.strOf(job.getAssumedCheckOutCount())));
        job.log().add(new JobLogItem(0, LABEL.DURATION, job.getDuration().toString()));
        StringBuilder detail = new StringBuilder(32).append(totalReceived).append('/').append(swapFlaggedBufferSize);
        boolean bl = SF_unreportedRooms = swapFlaggedBufferSize != totalReceived;
        if (SF_unreportedRooms) {
            detail.append(' ').append("(Room Status will have changed ok, but SF tagged guest record was not logged in job summary)");
        }
        job.log().add(new JobLogItem(this.iconFor(SF_unreportedRooms), LABEL.JOB_VS_LISTENER_COUNT, detail.toString()));
    }

    default public int iconFor(boolean b) {
        return b ? 3 : 0;
    }

    default public String strOf(int i) {
        return Integer.toString(i);
    }

    public static final class LABEL {
        private static final Lexicon lex = Lexicon.make(BMicrosDatabaseSyncJob.class);
        private static final String ASSUMED_CHECKOUT_COUNT = lex.getText("ds.assume.out.count");
        private static final String DURATION = lex.getText("ds.duration");
        private static final String TOTAL_RCV_RECORD_COUNT = lex.getText("ds.total.rcv.count");
        private static final String REGISTERED_PROXY_EXT_COUNT = lex.getText("ds.reg.proxyExt.count");
        private static final String RCV_GUEST_IN_COUNT = lex.getText("ds.rcv.guestIn.count");
        private static final String RCV_GUEST_OUT_COUNT = lex.getText("ds.rcv.guestOut.count");
        private static final String ROOM_UNKNOWN_COUNT = lex.getText("ds.unknown.room.count");
        private static final String JOB_VS_LISTENER_COUNT = lex.getText("ds.job.vs.listener.count");
        private static final String JOB_SUMMARY_HEADER = lex.getText("ds.job.summary.header");
        private static final String SF_NOT_LOGGED = "(Room Status will have changed ok, but SF tagged guest record was not logged in job summary)";

        private LABEL() {
        }
    }
}

