/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.datatype.config;

import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.comm.protocol.LinkRestartUtil;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.datatype.config.BMicrosDatabaseSyncConfig;
import com.tridiumemea.micros.datatype.config.BMicrosPreArrivalConfig;
import com.tridiumemea.micros.datatype.config.BMicrosRoomRightsConfig;
import com.tridiumemea.micros.point.BMicrosPointDeviceExt;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.baja.data.BIDataValue;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.units.UnitDatabase;
import javax.baja.util.ExecutorUtil;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="msgRetryCount", type="int", defaultValue="1", facets={@Facet(name="BFacets.MIN", value="1"), @Facet(name="BFacets.MAX", value="5")}), @NiagaraProperty(name="msgResponseTimeout", type="baja:RelTime", defaultValue="BRelTime.makeSeconds(10)", facets={@Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"second\")"), @Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(1)"), @Facet(name="BFacets.MAX", value="BRelTime.makeSeconds(600)")}), @NiagaraProperty(name="durationToBlockCommsAfterSocketOpen", type="baja:RelTime", defaultValue="BRelTime.makeSeconds(4)", flags=260, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="BBoolean.FALSE"), @Facet(name="BFacets.UNITS", value="UnitDatabase.getUnit(\"second\")"), @Facet(name="BFacets.MIN", value="BRelTime.makeSeconds(1)"), @Facet(name="BFacets.MAX", value="BRelTime.makeSeconds(30)")}), @NiagaraProperty(name="inhibitLinkEndNextShutdown", type="boolean", defaultValue="false", flags=65858), @NiagaraProperty(name="resetLinkOnNegotiationClash", type="boolean", defaultValue="false", flags=260), @NiagaraProperty(name="enableGuestData", type="boolean", defaultValue="true", flags=256), @NiagaraProperty(name="requestVersion", type="boolean", defaultValue="true", flags=260), @NiagaraProperty(name="roomRightsConfig", type="micros:MicrosRoomRightsConfig", defaultValue="new BMicrosRoomRightsConfig()", flags=256), @NiagaraProperty(name="preArrivalConfig", type="micros:MicrosPreArrivalConfig", defaultValue="new BMicrosPreArrivalConfig()", flags=256), @NiagaraProperty(name="databaseSyncConfig", type="micros:MicrosDatabaseSyncConfig", defaultValue="new BMicrosDatabaseSyncConfig()", flags=256)})
@NiagaraAction(name="restartLink", flags=20)
public final class BMicrosLinkConfig
extends BComponent {
    public static final Property msgRetryCount = BMicrosLinkConfig.newProperty((int)0, (int)1, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (int)1), (BFacets)BFacets.make((String)"max", (int)5)));
    public static final Property msgResponseTimeout = BMicrosLinkConfig.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)10), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"second")), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeSeconds((int)600))));
    public static final Property durationToBlockCommsAfterSocketOpen = BMicrosLinkConfig.newProperty((int)260, (BValue)BRelTime.makeSeconds((int)4), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.FALSE), (BFacets)BFacets.make((String)"units", (BIDataValue)UnitDatabase.getUnit((String)"second"))), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1))), (BFacets)BFacets.make((String)"max", (BIDataValue)BRelTime.makeSeconds((int)30))));
    public static final Property inhibitLinkEndNextShutdown = BMicrosLinkConfig.newProperty((int)65858, (boolean)false, null);
    public static final Property resetLinkOnNegotiationClash = BMicrosLinkConfig.newProperty((int)260, (boolean)false, null);
    public static final Property enableGuestData = BMicrosLinkConfig.newProperty((int)256, (boolean)true, null);
    public static final Property requestVersion = BMicrosLinkConfig.newProperty((int)260, (boolean)true, null);
    public static final Property roomRightsConfig = BMicrosLinkConfig.newProperty((int)256, (BValue)new BMicrosRoomRightsConfig(), null);
    public static final Property preArrivalConfig = BMicrosLinkConfig.newProperty((int)256, (BValue)new BMicrosPreArrivalConfig(), null);
    public static final Property databaseSyncConfig = BMicrosLinkConfig.newProperty((int)256, (BValue)new BMicrosDatabaseSyncConfig(), null);
    public static final Action restartLink = BMicrosLinkConfig.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BMicrosLinkConfig.class);
    private final Object rebootLock = new Object();
    private volatile Clock.Ticket ticket = Clock.expiredTicket;
    private BMicrosNetwork network;
    private BMicrosPointDeviceExt points;
    private LinkRestartUtil restartUtil;
    private boolean oldRoomRights_enable;
    private boolean oldPreArrival_enable;
    private static final BIcon ICON = BIcon.std((String)"gears.png");

    public int getMsgRetryCount() {
        return this.getInt(msgRetryCount);
    }

    public void setMsgRetryCount(int v) {
        this.setInt(msgRetryCount, v, null);
    }

    public BRelTime getMsgResponseTimeout() {
        return (BRelTime)this.get(msgResponseTimeout);
    }

    public void setMsgResponseTimeout(BRelTime v) {
        this.set(msgResponseTimeout, (BValue)v, null);
    }

    public BRelTime getDurationToBlockCommsAfterSocketOpen() {
        return (BRelTime)this.get(durationToBlockCommsAfterSocketOpen);
    }

    public void setDurationToBlockCommsAfterSocketOpen(BRelTime v) {
        this.set(durationToBlockCommsAfterSocketOpen, (BValue)v, null);
    }

    public boolean getInhibitLinkEndNextShutdown() {
        return this.getBoolean(inhibitLinkEndNextShutdown);
    }

    public void setInhibitLinkEndNextShutdown(boolean v) {
        this.setBoolean(inhibitLinkEndNextShutdown, v, null);
    }

    public boolean getResetLinkOnNegotiationClash() {
        return this.getBoolean(resetLinkOnNegotiationClash);
    }

    public void setResetLinkOnNegotiationClash(boolean v) {
        this.setBoolean(resetLinkOnNegotiationClash, v, null);
    }

    public boolean getEnableGuestData() {
        return this.getBoolean(enableGuestData);
    }

    public void setEnableGuestData(boolean v) {
        this.setBoolean(enableGuestData, v, null);
    }

    public boolean getRequestVersion() {
        return this.getBoolean(requestVersion);
    }

    public void setRequestVersion(boolean v) {
        this.setBoolean(requestVersion, v, null);
    }

    public BMicrosRoomRightsConfig getRoomRightsConfig() {
        return (BMicrosRoomRightsConfig)this.get(roomRightsConfig);
    }

    public void setRoomRightsConfig(BMicrosRoomRightsConfig v) {
        this.set(roomRightsConfig, (BValue)v, null);
    }

    public BMicrosPreArrivalConfig getPreArrivalConfig() {
        return (BMicrosPreArrivalConfig)this.get(preArrivalConfig);
    }

    public void setPreArrivalConfig(BMicrosPreArrivalConfig v) {
        this.set(preArrivalConfig, (BValue)v, null);
    }

    public BMicrosDatabaseSyncConfig getDatabaseSyncConfig() {
        return (BMicrosDatabaseSyncConfig)this.get(databaseSyncConfig);
    }

    public void setDatabaseSyncConfig(BMicrosDatabaseSyncConfig v) {
        this.set(databaseSyncConfig, (BValue)v, null);
    }

    public void restartLink() {
        this.invoke(restartLink, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.network = (BMicrosNetwork)this.getParent();
        this.points = this.network.getDevice().getPoints();
        this.restartUtil = new LinkRestartUtil(this.network);
        this.oldRoomRights_enable = this.getRoomRightsConfig().getEnableRoomRightsData();
        this.oldPreArrival_enable = this.getPreArrivalConfig().getEnablePreArrival();
    }

    public IPropertyValidator getPropertyValidator(final Property property, Context context) {
        if (property.equals(enableGuestData)) {
            return new IPropertyValidator(){

                public void validateSet(Validatable validatable, Context context) {
                    BMicrosLinkConfig linkConfig = (BMicrosLinkConfig)validatable.getExistingComplex();
                    BMicrosNetwork network = (BMicrosNetwork)linkConfig.getParent();
                    BMicrosPointDeviceExt points = network.getDevice().getPoints();
                    network.log().fine(() -> "Checking licensing for LinkConfig property " + property.getName());
                    if (!points.isGuestDataLicensed() && !BMicrosLinkConfig.this.getEnableGuestData()) {
                        String errMsg = property.getName() + " Feature not licensed";
                        network.log().info(errMsg);
                        throw new FeatureNotLicensedException(errMsg);
                    }
                }
            };
        }
        return null;
    }

    public void stopped() throws Exception {
        this.ticket.cancel();
        this.ticket = Clock.expiredTicket;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(enableGuestData)) {
            this.points.toggleMixIn(BMicrosPointDeviceExt.TOGGLE_OPTION.GUEST_DATA);
            this.restartBroker(p);
        } else if (p.equals(roomRightsConfig)) {
            boolean enabledChanged;
            boolean bl = enabledChanged = this.oldRoomRights_enable != this.getRoomRightsConfig().getEnableRoomRightsData();
            if (enabledChanged) {
                this.oldRoomRights_enable = !this.oldRoomRights_enable;
                this.points.toggleMixIn(BMicrosPointDeviceExt.TOGGLE_OPTION.ROOM_RIGHTS);
                this.restartBroker(p);
            }
        } else if (p.equals(preArrivalConfig)) {
            boolean enabledChanged;
            boolean bl = enabledChanged = this.oldPreArrival_enable != this.getPreArrivalConfig().getEnablePreArrival();
            if (enabledChanged) {
                this.oldPreArrival_enable = !this.oldPreArrival_enable;
                this.network.getDevice().getPoints().updateAllRoomEquipmentStatus();
                this.restartBroker(p);
            }
        } else if (p.equals(requestVersion)) {
            this.network.getDevice().resetVersionProps();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRestartLink() {
        this.network.log().info("Restarting link to update with Link Config changes");
        Object object = this.rebootLock;
        synchronized (object) {
            this.restartUtil.restartLink();
        }
    }

    public void restartBroker(Property p) {
        this.network.log().fine(() -> "Link Restart Requested For: " + p.getName() + "ticketIsExpired: " + this.ticket.isExpired());
        this.ticket.cancel();
        this.ticket = Clock.schedule((BComponent)this.getParentComponent(), (BRelTime)BRelTime.make((long)50L), (Action)restartLink, null);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        BMicrosLinkConfig.getExecutorService().execute((Runnable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    private static ExecutorService getExecutorService() {
        return ExecutorServiceLazyHolder.INSTANCE;
    }

    public boolean isParentLegal(BComponent parent) {
        return CommonUtil.isParentLegal((BComplex)parent, (BComplex)this, BMicrosNetwork.TYPE);
    }

    public BIcon getIcon() {
        return ICON;
    }

    private static final class ExecutorServiceLazyHolder {
        private static final ExecutorService INSTANCE = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)"LinkConfig", (long)2L, (TimeUnit)TimeUnit.MINUTES);

        private ExecutorServiceLazyHolder() {
        }
    }
}

