/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.comm.flag;

import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.comm.BMicrosListener;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public final class MicrosMessageFlag {
    private final Set<Flag> activeFlags = Collections.synchronizedSet(EnumSet.noneOf(Flag.class));
    private BMicrosListener listener;

    private MicrosMessageFlag() {
    }

    public MicrosMessageFlag(BMicrosListener listener) {
        this.listener = listener;
    }

    public boolean isRaised(Flag flag) {
        this.logAccess(flag);
        return this.activeFlags.contains((Object)flag);
    }

    public void raise(Flag flag) {
        this.logAccess(flag);
        this.activeFlags.add(flag);
    }

    public void lower(Flag flag) {
        this.logAccess(flag);
        this.activeFlags.remove((Object)flag);
    }

    private void logAccess(Flag flag) {
        BMicrosNetwork network = (BMicrosNetwork)this.listener.getParent();
        if (network != null && network.log() != null) {
            network.log().fine(() -> "factoryFlag:" + flag.name() + ": isRaised? " + this.activeFlags.contains((Object)flag));
        }
    }

    public static enum Flag {
        LINK_END,
        LINK_MSG,
        DATA_START;

    }
}

