/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros;

import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BTcpCommConfig;
import com.tridiumemea.micros.BMicrosDevice;
import com.tridiumemea.micros.BMicrosDeviceFolder;
import com.tridiumemea.micros.comm.BMicrosListener;
import com.tridiumemea.micros.comm.BMicrosTcpCommConfig;
import com.tridiumemea.micros.comm.protocol.DatabaseSyncUtil;
import com.tridiumemea.micros.comm.protocol.LinkActivationUtil;
import com.tridiumemea.micros.comm.protocol.LinkShutdownUtil;
import com.tridiumemea.micros.comm.protocol.SocketHandshakeUtil;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.datatype.config.BMicrosLinkConfig;
import com.tridiumemea.micros.enums.BMicrosLinkStatusEnum;
import com.tridiumemea.micros.job.BMicrosDatabaseSyncJob;
import com.tridiumemea.micros.message.MicrosMessage;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.point.BTuningPolicyMap;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(override=true, name="tuningPolicies", type="BTuningPolicyMap", flags=4, defaultValue="new BTuningPolicyMap()"), @NiagaraProperty(name="tcpConfig", type="micros:MicrosTcpCommConfig", defaultValue="new BMicrosTcpCommConfig()", flags=4), @NiagaraProperty(name="linkConfig", type="micros:MicrosLinkConfig", defaultValue="new BMicrosLinkConfig()"), @NiagaraProperty(name="linkStatus", type="micros:MicrosLinkStatusEnum", defaultValue="BMicrosLinkStatusEnum.notActive", flags=65611), @NiagaraProperty(name="lastLinkActivationTime", type="baja:AbsTime", defaultValue="BAbsTime.NULL", flags=65603), @NiagaraProperty(name="eventListener", type="micros:MicrosListener", defaultValue="new BMicrosListener()", flags=4), @NiagaraProperty(name="databaseSyncJobOrd", type="baja:Ord", defaultValue="BOrd.DEFAULT", flags=65603), @NiagaraProperty(name="device", type="micros:MicrosDevice", defaultValue="new BMicrosDevice()")})
@NiagaraActions(value={@NiagaraAction(name="pingDevice", flags=16), @NiagaraAction(name="ping", flags=20, override=true), @NiagaraAction(name="databaseSync", flags=144), @NiagaraAction(name="databaseSyncEvaluateTimeout", flags=2053), @NiagaraAction(name="lowerCommInhibitFlag", flags=2053)})
public final class BMicrosNetwork
extends BNNetwork {
    public static final Property tuningPolicies = BMicrosNetwork.newProperty((int)4, (BValue)new BTuningPolicyMap(), null);
    public static final Property tcpConfig = BMicrosNetwork.newProperty((int)4, (BValue)new BMicrosTcpCommConfig(), null);
    public static final Property linkConfig = BMicrosNetwork.newProperty((int)0, (BValue)new BMicrosLinkConfig(), null);
    public static final Property linkStatus = BMicrosNetwork.newProperty((int)65611, (BValue)BMicrosLinkStatusEnum.notActive, null);
    public static final Property lastLinkActivationTime = BMicrosNetwork.newProperty((int)65603, (BValue)BAbsTime.NULL, null);
    public static final Property eventListener = BMicrosNetwork.newProperty((int)4, (BValue)new BMicrosListener(), null);
    public static final Property databaseSyncJobOrd = BMicrosNetwork.newProperty((int)65603, (BValue)BOrd.DEFAULT, null);
    public static final Property device = BMicrosNetwork.newProperty((int)0, (BValue)new BMicrosDevice(), null);
    public static final Action pingDevice = BMicrosNetwork.newAction((int)16, null);
    public static final Action ping = BMicrosNetwork.newAction((int)20, null);
    public static final Action databaseSync = BMicrosNetwork.newAction((int)144, null);
    public static final Action databaseSyncEvaluateTimeout = BMicrosNetwork.newAction((int)2053, null);
    public static final Action lowerCommInhibitFlag = BMicrosNetwork.newAction((int)2053, null);
    public static final Type TYPE = Sys.loadType(BMicrosNetwork.class);
    private LinkActivationUtil activationUtil;
    private LinkShutdownUtil shutdownUtil;
    private SocketHandshakeUtil sockUtil;
    private DatabaseSyncUtil dsUtil;
    private static final Lexicon lex = Lexicon.make(BMicrosNetwork.class);
    private static final String DEFAULT_START_STATE_TXT = lex.getText("network.defaultState");
    private static final String ADVISE_AGAINST_SYNC_ON_ACTIVE = "syncOnLinkActive = true. You should check this is not locking out other hotel systems (eg. phone, reception, EFT) when used. Recent Fidelio systems will return no records for the first minute of connection to discourage this behaviour.";

    public BMicrosTcpCommConfig getTcpConfig() {
        return (BMicrosTcpCommConfig)this.get(tcpConfig);
    }

    public void setTcpConfig(BMicrosTcpCommConfig v) {
        this.set(tcpConfig, (BValue)v, null);
    }

    public BMicrosLinkConfig getLinkConfig() {
        return (BMicrosLinkConfig)this.get(linkConfig);
    }

    public void setLinkConfig(BMicrosLinkConfig v) {
        this.set(linkConfig, (BValue)v, null);
    }

    public BMicrosLinkStatusEnum getLinkStatus() {
        return (BMicrosLinkStatusEnum)this.get(linkStatus);
    }

    public void setLinkStatus(BMicrosLinkStatusEnum v) {
        this.set(linkStatus, (BValue)v, null);
    }

    public BAbsTime getLastLinkActivationTime() {
        return (BAbsTime)this.get(lastLinkActivationTime);
    }

    public void setLastLinkActivationTime(BAbsTime v) {
        this.set(lastLinkActivationTime, (BValue)v, null);
    }

    public BMicrosListener getEventListener() {
        return (BMicrosListener)this.get(eventListener);
    }

    public void setEventListener(BMicrosListener v) {
        this.set(eventListener, (BValue)v, null);
    }

    public BOrd getDatabaseSyncJobOrd() {
        return (BOrd)this.get(databaseSyncJobOrd);
    }

    public void setDatabaseSyncJobOrd(BOrd v) {
        this.set(databaseSyncJobOrd, (BValue)v, null);
    }

    public BMicrosDevice getDevice() {
        return (BMicrosDevice)this.get(device);
    }

    public void setDevice(BMicrosDevice v) {
        this.set(device, (BValue)v, null);
    }

    public void pingDevice() {
        this.invoke(pingDevice, null, null);
    }

    public void databaseSync() {
        this.invoke(databaseSync, null, null);
    }

    public void databaseSyncEvaluateTimeout() {
        this.invoke(databaseSyncEvaluateTimeout, null, null);
    }

    public void lowerCommInhibitFlag() {
        this.invoke(lowerCommInhibitFlag, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.activationUtil = new LinkActivationUtil(this);
        this.shutdownUtil = new LinkShutdownUtil(this);
        this.sockUtil = new SocketHandshakeUtil(this);
        this.dsUtil = new DatabaseSyncUtil(this);
        this.getTuningPolicies().stopped();
        this.getHealth().setLastFailCause(DEFAULT_START_STATE_TXT);
    }

    public void stopped() throws Exception {
        this.shutdownUtil.sendLinkEndToConnectedServer();
        this.shutdownUtil.commonLinkDownSteps(lex.getText("le.shutdown"));
        this.getDevice().getPoints().removeAllProxyExt();
        super.stopped();
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if (this.isRunning()) {
            if (prop.equals(linkStatus)) {
                if (this.getLinkStatus().isLinkActive()) {
                    this.setLastLinkActivationTime(BAbsTime.now());
                    if (this.getLinkConfig().getDatabaseSyncConfig().getSyncOnLinkActive()) {
                        this.log().warning(ADVISE_AGAINST_SYNC_ON_ACTIVE);
                        this.databaseSync();
                    }
                }
            } else if (prop.equals(enabled) && this.getEnabled() && !this.getMonitor().getPingEnabled()) {
                this.pingDevice();
            }
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (!this.isRunning()) {
            throw new BajaRuntimeException("Not Running");
        }
        if (action.equals(ping) || action.equals(databaseSync)) {
            this.getAsync().post((Runnable)new Invocation((BComponent)this, action, arg, cx));
            return null;
        }
        return super.post(action, arg, cx);
    }

    public final void doPingDevice(Context cx) {
        if (!this.isRunning() || this.isFatalFault()) {
            return;
        }
        if (cx != null && cx.getUser() != null) {
            this.log().fine(() -> "pingDevice by " + cx.getUser());
        }
        this.getDevice().ping();
    }

    public void doLowerCommInhibitFlag() {
        this.log().fine(() -> "doLowerCommInhibitFlag (commInhibit was: " + this.sockUtil.isCommInhibitFlag() + ')');
        this.sockUtil.lowerCommInhibitFlag();
    }

    public final void sendAsync(MicrosMessage msg) throws Exception {
        this.getTcpConfig().checkAndFormatMsg(msg);
        this.getTcpConfig().tcomm().sendMessage((NMessage)msg);
    }

    public void doDatabaseSync(Context cx) {
        new BMicrosDatabaseSyncJob(this, BMicrosDatabaseSyncJob.SOURCE.LOCAL, cx);
    }

    public void doDatabaseSyncEvaluateTimeout() {
        this.dsUtil.checkJobTimeout();
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "microsFidelio");
    }

    public Type getDeviceFolderType() {
        return BMicrosDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BMicrosDevice.TYPE;
    }

    public BINavNode[] getNavChildren() {
        Array a = new Array((Object[])super.getNavChildren());
        a.add((Object)this.getDevice());
        return (BINavNode[])a.trim();
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value.getType().is(BMicrosDevice.TYPE) || value.getType().is(BTcpCommConfig.TYPE)) {
            throw new LocalizableRuntimeException("micros", "microsNetwork.thereCanBeOnlyOne");
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return CommonUtil.isParentLegal((BComplex)parent, (BComplex)this, BDriverContainer.TYPE);
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (property.equals(enabled)) {
            return new IPropertyValidator(){

                public void validateSet(Validatable validatable, Context context) {
                    if (validatable.getProposedValue(BDeviceNetwork.enabled) != null) {
                        boolean isTransitionToDisabled;
                        boolean bl = isTransitionToDisabled = !((BIBoolean)validatable.getProposedValue(BDeviceNetwork.enabled)).getBoolean();
                        if (isTransitionToDisabled) {
                            BMicrosNetwork network = (BMicrosNetwork)validatable.getExistingComplex();
                            BMicrosNetwork.this.log().fine(() -> "validator: Enabled is being switched to false, considering LinkEnd with server");
                            network.getShutdownUtil().sendLinkEndToConnectedServer();
                            network.getShutdownUtil().commonLinkDownSteps(lex.getText("network.disabled"));
                        }
                    }
                }
            };
        }
        return null;
    }

    public String getNetworkName() {
        String logName = this.getName();
        if (logName == null) {
            logName = "microsNetwork";
        }
        if (logName.length() > 0 && Character.isUpperCase(logName.charAt(0))) {
            logName = logName.substring(0, 1).toLowerCase() + logName.substring(1);
        }
        return logName;
    }

    public void spy(SpyWriter out) throws Exception {
        String BEGIN_AHREF = "<li><a href='" + out.getPath().getBody();
        String END_AHREF = "</a></li>";
        String workerLink = BEGIN_AHREF + "/async'>Async Worker" + "</a></li>";
        String commLink = BEGIN_AHREF + "/tcpConfig'>tcpConfig Stats" + "</a></li>";
        out.write("<ul>");
        out.write(workerLink);
        out.write(commLink);
        out.write("</ul>");
        out.startProps("Network Info");
        out.prop((Object)"iAm", (Object)((Object)((Object)this)).getClass().getName());
        out.prop((Object)"version", (Object)this.getType().getModule().getVendorVersion(RuntimeProfile.rt));
        out.prop((Object)"currentSession", this.getDevice().getAddress().getSessionId());
        out.prop((Object)"socketHandshakeRequired", this.sockUtil.isSocketHandshakeRequired());
        out.prop((Object)"commInhibitFlag", this.sockUtil.isCommInhibitFlag());
        out.endProps();
        if (this.getEventListener() != null) {
            this.getEventListener().spyDataAdditions(out);
        }
        this.getDevice().spyDataAdditions(out);
        super.spy(out);
    }

    public LinkActivationUtil getActivationUtil() {
        return this.activationUtil;
    }

    public LinkShutdownUtil getShutdownUtil() {
        return this.shutdownUtil;
    }

    public SocketHandshakeUtil getSockUtil() {
        return this.sockUtil;
    }

    public DatabaseSyncUtil getDsUtil() {
        return this.dsUtil;
    }
}

