/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui.driver;

import com.tridium.batchJob.ui.BJobStepDetailsView;
import com.tridium.batchJob.ui.JobTable;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.ui.util.LabelUtil;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.LexiconText;

@NiagaraType(agent={@AgentOn(types={"batchJob:DeviceStepDetails"})})
public class BDeviceStepDetailsView
extends BJobStepDetailsView {
    @Generated
    public static final Type TYPE = Sys.loadType(BDeviceStepDetailsView.class);
    private BLabel deviceLabel;
    private BLabel startedLabel;
    private BLabel endedLabel;
    private BLabel stateLabel;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void loadDetails(BWidget owner, BObject base, BJobStepDetails jobStepDetails, BGridPane upperPane, BButtonPane buttons, JobTable.LogModel logModel) throws Exception {
        BDeviceStepDetails details = (BDeviceStepDetails)jobStepDetails;
        this.deviceLabel = new BLabel();
        BLabel typeLabel = new BLabel();
        this.startedLabel = new BLabel();
        this.endedLabel = new BLabel();
        this.stateLabel = new BLabel();
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceStepDetailsView.device"), (BWidget)this.deviceLabel);
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceStepDetailsView.type"), (BWidget)typeLabel);
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceStepDetailsView.started"), (BWidget)this.startedLabel);
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceStepDetailsView.ended"), (BWidget)this.endedLabel);
        LabelUtil.addLabelWidgetPair((BPane)upperPane, (LexiconText)LexiconText.make((String)"batchJob", (String)"DeviceStepDetailsView.state"), (BWidget)this.stateLabel);
        String device = details.getDeviceDisplayName();
        if (device.length() == 0) {
            device = details.getDeviceId().toString();
        }
        this.deviceLabel.setText(device);
        typeLabel.setText(details.getStepDescription());
        this.startedLabel.setText(details.getStartTime().toString());
        this.endedLabel.setText(details.getStartTime().toString());
        this.stateLabel.setText(details.getState().toString());
        logModel.load(details.readLog().toString());
        this.refreshLogCommand = new BJobStepDetailsView.RefreshLogCommand(this, (BJobStepDetails)details);
        this.refreshLogCommand.setEnabled(!details.getState().isComplete());
        buttons.add(this.refreshLogCommand);
        if (details.isMounted() && !details.getState().isComplete()) {
            this.registerForComponentEvents((BComponent)details, Integer.MAX_VALUE);
        }
    }

    @Override
    public void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSourceComponent() instanceof BDeviceStepDetails && evt.getId() == 0) {
            if (evt.getSlot() == BDeviceStepDetails.deviceId) {
                this.deviceLabel.setText(evt.getValue().toString());
            } else if (evt.getSlot() == BDeviceStepDetails.startTime) {
                this.startedLabel.setText(evt.getValue().toString());
            } else if (evt.getSlot() == BDeviceStepDetails.endTime) {
                this.endedLabel.setText(evt.getValue().toString());
            } else if (evt.getSlot() == BDeviceStepDetails.state) {
                if (((BJobState)evt.getValue()).isComplete()) {
                    try {
                        this.model.load(((BDeviceStepDetails)evt.getSourceComponent()).readLog().toString());
                        this.refreshLogCommand.setEnabled(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.stateLabel.setText(evt.getValue().toString());
            }
        }
    }
}

