/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui;

import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.ui.theme.Theme;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.ui.BJobStepFactory;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;

public class JobStepChooser {
    private List<BJobStepFactory> factories = null;
    private final Type stageType;
    private static final Lexicon lex = Lexicon.make((String)"batchJob");
    private static final int NEW_STEP_DIALOG_WIDTH_BUFFER = 50;
    private static final int NEW_STEP_MAX_DIALOG_WIDTH = 600;
    private static final int NEW_STEP_DIALOG_HEIGHT = 400;
    public static final Logger LOGGER = Logger.getLogger("batchJob");

    public JobStepChooser(Type stageType) {
        this.stageType = stageType;
    }

    public Type getStageType() {
        return this.stageType;
    }

    public BJobStep choose(BWidget owner, BBatchJob currentBatchJob, BObject jobTarget, Context cx) throws Exception {
        BJobStepFactory factory = this.chooseFactory(owner, currentBatchJob, jobTarget, cx);
        return factory == null ? null : factory.makeStep(owner, currentBatchJob, jobTarget, cx);
    }

    public BJobStepFactory chooseFactory(BWidget owner, BBatchJob currentBatchJob, BObject jobTarget, Context cx) throws Exception {
        List<BJobStepFactory> validFactories = this.getAllFactories().stream().filter(f -> this.isStepFactoryValidForTarget((BJobStepFactory)((Object)f), currentBatchJob, jobTarget)).sorted(Comparator.comparing(f -> f.getType().getDisplayName(cx))).collect(Collectors.toList());
        return this.chooseFactory(owner, currentBatchJob, jobTarget, validFactories, cx);
    }

    private boolean isStepFactoryValidForTarget(BJobStepFactory factory, BBatchJob currentBatchJob, BObject jobTarget) {
        try {
            return factory.isValidFor(currentBatchJob, jobTarget, this.stageType, null);
        }
        catch (Exception ignore) {
            LOGGER.fine("Unexpected exception during validity check for job step:" + factory.getTypeDisplayName(null));
            return false;
        }
    }

    public BJobStepFactory chooseFactory(BWidget owner, BBatchJob currentBatchJob, BObject jobTarget, List<BJobStepFactory> factories, Context cx) throws Exception {
        if (factories.size() == 0) {
            BDialog.error((BWidget)owner, (String)lex.getText("JobStepChooser.noFactories.dlgTitle"), (Object)lex.getText("JobStepChooser.noFactories.dlgMessage"));
            return null;
        }
        CommandBindings bindings = new CommandBindings();
        FactoryModel factoryModel = new FactoryModel(factories, cx);
        BCommandBoundTable factoryTable = new BCommandBoundTable((TableModel)factoryModel, new CommandBindings.TableController(bindings));
        DialogCommand ok = DialogCommand.makeOk((BWidget)factoryTable);
        DialogCommand cancel = DialogCommand.makeCancel((BWidget)factoryTable);
        bindings.addCommand((Command)ok, BCommandEnablePolicy.singleSelection);
        bindings.addCommand((Command)cancel, BCommandEnablePolicy.always);
        bindings.setDoubleClickCommand((Command)ok);
        BLabel dlgLabel = new BLabel(lex.getText("JobStepChooser.dlgMessage"));
        dlgLabel.setHalign(BHalign.left);
        BBorderPane contentPane = new BBorderPane((BWidget)new BEdgePane((BWidget)dlgLabel, (BWidget)new BBox(300.0, 0.0), (BWidget)new BBox(0.0, 200.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)factoryTable, BBorder.inset, BInsets.DEFAULT), 10.0, 0.0, 4.0, 0.0)), 4.0, 10.0, 4.0, 10.0);
        BScrollPane scroll = new BScrollPane((BWidget)contentPane);
        scroll.setViewportBackground(Theme.scrollPane().getControlBackground());
        scroll.setBorderPolicy(BScrollBarPolicy.asNeeded);
        BConstrainedPane cpane = new BConstrainedPane((BWidget)scroll);
        contentPane.computePreferredSize();
        cpane.setMaxWidth(600.0);
        cpane.setFixedSize(contentPane.getPreferredWidth() + 50.0, 400.0);
        if (1 == BCommandDialog.open((BWidget)owner, (String)lex.getText("JobStepChooser.dlgTitle"), (Object)cpane, (DialogCommand[])new DialogCommand[]{ok, cancel})) {
            return factoryModel.getFactoryAt(factoryTable.getSelection().getRow());
        }
        return null;
    }

    private List<BJobStepFactory> getAllFactories() {
        if (this.factories == null) {
            this.factories = Arrays.stream(Sys.getRegistry().getConcreteTypes(BJobStepFactory.TYPE.getTypeInfo())).map(t -> (BJobStepFactory)t.getInstance()).collect(Collectors.toList());
        }
        return this.factories;
    }

    private static class FactoryModel
    extends TableModel {
        private final List<BJobStepFactory> factories;
        private final Context cx;

        public FactoryModel(List<BJobStepFactory> factories, Context cx) {
            this.factories = factories;
            this.cx = cx;
        }

        public int getRowCount() {
            return this.factories.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("JobStepChooser.name");
                }
                case 1: {
                    return lex.getText("JobStepChooser.summary");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BImage getRowIcon(int row) {
            return BImage.make((BIcon)this.getFactoryAt(row).asObject().getIcon());
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.getFactoryAt(row).getType().getDisplayName(this.cx);
                }
                case 1: {
                    return this.getFactoryAt(row).getDescription(this.cx);
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BJobStepFactory getFactoryAt(int row) {
            return this.factories.get(row);
        }
    }
}

