/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.ui.JobTable;
import com.tridium.batchJob.ui.ViewQueryParameter;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.batchJob.BIJobQueryManager;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.io.BIEncodable;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
public abstract class BBatchJobList
extends BWbComponentView
implements CommandBindings.Support {
    @Generated
    public static final Type TYPE = Sys.loadType(BBatchJobList.class);
    private Model model;
    private BTable table;
    private DisposeCommand disposeCommand;
    private CancelCommand cancelCommand;
    private BBatchJobService batchJobService = null;
    private static Lexicon lex = Lexicon.make((String)"batchJob");
    public static final int COL_JOB_START = 0;
    public static final int COL_JOB_END = 1;
    public static final int COL_JOB_USER = 2;
    public static final int COL_BUTTONS = 3;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBatchJobList() {
        this.autoRegisterForComponentEvents = false;
        CommandBindings bindings = new CommandBindings();
        bindings.setSupport((CommandBindings.Support)this);
        LogCommand logCommand = new LogCommand();
        bindings.addCommand((Command)logCommand, BCommandEnablePolicy.singleSelection);
        OpenCommand openCommand = new OpenCommand();
        bindings.addCommand((Command)openCommand, BCommandEnablePolicy.singleSelection);
        this.cancelCommand = new CancelCommand();
        bindings.addCommand((Command)this.cancelCommand, BCommandEnablePolicy.anySelection);
        this.disposeCommand = new DisposeCommand();
        bindings.addCommand((Command)this.disposeCommand, BCommandEnablePolicy.anySelection);
        bindings.setDoubleClickCommand((Command)logCommand);
        this.model = new Model();
        this.table = JobTable.makeListTable(this.model, bindings, 3 + this.getColumnOffset(), openCommand, this.disposeCommand);
        this.table.setMultipleSelection(true);
        this.setContent((BWidget)new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)new BButtonPane(bindings.getCommands()), BInsets.make((double)4.0, (double)5.0, (double)4.0, (double)5.0)), null, null, (BWidget)new BBorderPane((BWidget)new BScrollPane((BWidget)this.table), BBorder.inset, BInsets.DEFAULT)), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.model.load();
    }

    protected abstract Type getJobType();

    public void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSourceComponent() instanceof BBatchJobService) {
            if (evt.getId() == 5 && evt.getSlot() == BBatchJobService.jobDisposed) {
                this.model.handleJobDisposed((BAbsTime)evt.getValue());
            }
        } else if (evt.getSourceComponent() instanceof BJobService) {
            if (evt.getId() == 1 && evt.getValue().getType().equals(this.getJobType())) {
                BBatchJob job = (BBatchJob)evt.getValue();
                this.model.updateJob(job);
                this.registerForComponentEvents((BComponent)job, 1);
            }
        } else if (evt.getSourceComponent().getType().equals(this.getJobType())) {
            this.model.updateJob((BBatchJob)evt.getSourceComponent());
        }
    }

    public BBatchJobService getBatchJobService() {
        if (this.batchJobService == null) {
            this.batchJobService = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get(this.getCurrentValue());
        }
        return this.batchJobService;
    }

    public BIJobQueryManager getQueryManager() {
        return this.getBatchJobService().getJobQueryManager();
    }

    protected void setModel(Model model) {
        this.model = model;
        this.table.setModel((TableModel)model);
        model.updateTable(true);
    }

    protected int getColumnOffset() {
        return 0;
    }

    public void setBoundCommandEnabled(Command command, boolean bindingBasedState) {
        if (command == this.disposeCommand) {
            int[] rows;
            for (int row : rows = this.model.getSelection().getRows()) {
                if (this.model.summary(row).getJobState().isComplete()) continue;
                command.setEnabled(false);
                return;
            }
        } else if (command == this.cancelCommand) {
            int[] rows;
            for (int row : rows = this.model.getSelection().getRows()) {
                if (this.model.summary(row).getJobState() == BJobState.running || this.model.summary(row).getJobState() == BJobState.unknown) continue;
                command.setEnabled(false);
                return;
            }
        }
        command.setEnabled(bindingBasedState);
    }

    private class CancelCommand
    extends Command {
        public CancelCommand() {
            super((BWidget)BBatchJobList.this, lex, "BatchJobList.cancelCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BBatchJobList.this.model.getTable(), (String)lex.getText("BatchJobList.cancelCommand.dlgTitle"), (Object)lex.getText("BatchJobList.cancelCommand.dlgMessage"))) {
                    BBatchJobList.this.model.cancel(BBatchJobList.this.model.getTable().getSelection().getRows());
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    private class DisposeCommand
    extends Command {
        public DisposeCommand() {
            super((BWidget)BBatchJobList.this, lex, "BatchJobList.disposeCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                if (4 == BDialog.confirm((BWidget)BBatchJobList.this.model.getTable(), (String)lex.getText("BatchJobList.disposeCommand.dlgTitle"), (Object)lex.getText("BatchJobList.disposeCommand.dlgMessage"))) {
                    BBatchJobList.this.model.dispose(BBatchJobList.this.model.getTable().getSelection().getRows());
                }
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    private class LogCommand
    extends Command {
        public LogCommand() {
            super((BWidget)BBatchJobList.this, lex, "BatchJobList.logCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BBatchJob job = BBatchJobList.this.model.summary(BBatchJobList.this.model.getTable().getSelection().getRow()).getJob(BBatchJobList.this.getCurrentValue());
                JobTable.showLogDialog((BWidget)BBatchJobList.this.model.getTable(), (BJob)job);
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    private class OpenCommand
    extends Command {
        public OpenCommand() {
            super((BWidget)BBatchJobList.this, lex, "BatchJobList.openCommand");
        }

        public CommandArtifact doInvoke() {
            try {
                BOrd ord;
                BIBatchJobSummary summary = BBatchJobList.this.model.summary(BBatchJobList.this.model.getTable().getSelection().getRow());
                BBatchJob job = summary.getJob(BBatchJobList.this.getCurrentValue());
                if (job.getParent() instanceof BJobService) {
                    ord = BOrd.make((BOrd)BBatchJobList.this.getBatchJobService().getAbsoluteOrd(), (BOrd)job.getHandleOrd());
                } else {
                    BBatchJobLogFile logFile = BBatchJobLogFile.find((BBatchJob)job, (BObject)BBatchJobList.this.getCurrentValue());
                    ord = BOrd.make((BOrd)BBatchJobList.this.getBatchJobService().getAbsoluteOrd(), (BOrd)logFile.getOrdInSession());
                    ord = BOrd.make((BOrd)ord, (OrdQuery)new ViewQuery("?displayTzId=" + ViewQueryParameter.encode((BIEncodable)BString.make((String)job.getStartTime().getTimeZone().getId()))));
                }
                BBatchJobList.this.getWbShell().hyperlink(ord);
            }
            catch (Exception e) {
                CommandUtil.error((Command)this, (Throwable)e);
            }
            return null;
        }
    }

    protected class Model
    extends TableModel {
        protected List<BIBatchJobSummary> rows = new ArrayList<BIBatchJobSummary>();
        protected Map<BAbsTime, BIBatchJobSummary> summaryByStartTime = new HashMap<BAbsTime, BIBatchJobSummary>();

        protected Model() {
        }

        public synchronized void updateJob(BBatchJob job) {
            BIBatchJobSummary summary = this.summaryByStartTime.get(job.getStartTime());
            if (summary == null) {
                this.getSelection().deselectAll();
                summary = BBatchJobList.this.getQueryManager().makeJobSummary(job);
                this.rows.add(0, summary);
                this.summaryByStartTime.put(job.getStartTime(), summary);
            } else {
                summary.updateJob(job);
            }
            this.updateTable(true);
        }

        public synchronized void handleJobDisposed(BAbsTime jobStart) {
            BIBatchJobSummary summary = this.summaryByStartTime.get(jobStart);
            if (summary != null) {
                this.getSelection().deselectAll();
                this.rows.remove(summary);
                this.summaryByStartTime.remove(jobStart);
                this.updateTable(false);
            }
        }

        public synchronized void dispose(int[] rows) {
            for (int row : rows) {
                BBatchJobList.this.getBatchJobService().disposeJob(this.summary(row).getStartTime());
            }
        }

        public synchronized void cancel(int[] rows) throws Exception {
            for (int row : rows) {
                this.summary(row).getJob(BBatchJobList.this.getCurrentValue()).cancel();
            }
        }

        public synchronized void load() throws Exception {
            BIBatchJobSummary summary;
            this.getSelection().deselectAll();
            BJobService jobSvc = (BJobService)BOrd.make((String)"service:baja:JobService").get(BBatchJobList.this.getCurrentValue());
            jobSvc.lease(2);
            ArrayList<BIBatchJobSummary> tempRows = new ArrayList<BIBatchJobSummary>();
            HashMap<BAbsTime, BIBatchJobSummary> tempSummaryByStartTime = new HashMap<BAbsTime, BIBatchJobSummary>();
            Class jobClass = BBatchJobList.this.getJobType().getTypeClass();
            SlotCursor c = jobSvc.getProperties();
            while (c.next(jobClass)) {
                BBatchJob job = (BBatchJob)c.get();
                if (job.getJobState().isComplete()) continue;
                summary = BBatchJobList.this.getQueryManager().makeJobSummary(job);
                tempRows.add(summary);
                tempSummaryByStartTime.put(job.getStartTime(), summary);
            }
            c = BBatchJobList.this.getQueryManager().listJobSummaries(BBatchJobList.this.getJobType(), BBatchJobList.this.getCurrentValue());
            Throwable throwable = null;
            try {
                while (c.next()) {
                    summary = (BIBatchJobSummary)c.get();
                    tempRows.add(summary);
                    tempSummaryByStartTime.put(summary.getStartTime(), summary);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (c != null) {
                    if (throwable != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        c.close();
                    }
                }
            }
            tempRows.sort(Comparator.comparing(BIBatchJobSummary::getStartTime).reversed());
            this.summaryByStartTime = tempSummaryByStartTime;
            this.rows = tempRows;
            this.updateTable(true);
            BBatchJobList.this.registerForComponentEvents((BComponent)jobSvc, 2);
            BBatchJobList.this.registerForComponentEvents((BComponent)BBatchJobList.this.getBatchJobService(), 1);
        }

        public int getRowCount() {
            return this.rows.size();
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lex.getText("BatchJobList.col.jobStart");
                }
                case 1: {
                    return lex.getText("BatchJobList.col.jobEnd");
                }
                case 2: {
                    return lex.getText("BatchJobList.col.user");
                }
                case 3: {
                    return "";
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.summary(row).getStartTime().toString();
                }
                case 1: {
                    return this.summary(row).getEndTime() == null ? "" : this.summary(row).getEndTime().toString();
                }
                case 2: {
                    return this.summary(row).getSubmitUser();
                }
                case 3: {
                    return this.summary(row).getJobState();
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BIBatchJobSummary summary(int row) {
            return this.rows.get(row);
        }

        public BImage getRowIcon(int row) {
            return JobTable.stateToIcon(this.summary(row).getJobState());
        }
    }
}

