/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.svg.batik;

import com.tridium.gx.awt.BImageDecoder;
import com.tridium.gx.awt.ImageAnimator;
import com.tridium.svg.batik.BatikOrdUtils;
import com.tridium.svg.batik.OrdParsedURLProtocolHandler;
import com.tridium.svg.batik.OrdRegistryEntry;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.AccessController;
import javax.baja.agent.BIAgent;
import javax.baja.gx.BTransform;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import org.apache.batik.anim.dom.AnimatedAttributeListener;
import org.apache.batik.anim.dom.AnimatedLiveAttributeValue;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.anim.dom.SVGOMAnimationElement;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.SVGAnimationEngine;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.css.engine.CSSNavigableDocumentListener;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.ext.awt.image.spi.ImageTagRegistry;
import org.apache.batik.ext.awt.image.spi.RegistryEntry;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.ParsedURLProtocolHandler;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@NiagaraType(agent={@AgentOn(types={"file:SvgFile"}, requiredPermissions="r")})
public class BSvgDecoder
extends BImageDecoder
implements BIAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BSvgDecoder.class);
    private static final RenderingHints HINTS = new RenderingHints(null);
    private static final Color TRANSPARENT;
    private BufferedImage image;
    private ImageAnimator animator;
    private static final String ENABLE_SVG_HYPERLINKING_SYSPROP = "niagara.svg.hyperlinking.enabled";
    private static final boolean ENABLE_SVG_HYPERLINKING;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void decode(BOrd ord, byte[] bytes, BTransform.Scale scale) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            String uri = BatikOrdUtils.toBatikUrl(ord);
            SAXSVGDocumentFactory f = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
            SVGOMDocument document = (SVGOMDocument)f.createDocument(uri, (InputStream)inputStream);
            UserAgentAdapter userAgent = new UserAgentAdapter();
            BridgeContext bridgeContext = AccessController.doPrivileged(() -> new BridgeContext(userAgent, new DocumentLoader(userAgent)){

                @Override
                public SVGAnimationEngine getAnimationEngine() {
                    if (this.animationEngine == null) {
                        this.animationEngine = new SVGAnimationEngine(this.document, this){

                            protected float tick(float time, boolean hyperlinking) {
                                if (ENABLE_SVG_HYPERLINKING) {
                                    return super.tick(time, hyperlinking);
                                }
                                return super.tick(time, false);
                            }
                        };
                        this.setAnimationLimitingMode();
                    }
                    return this.animationEngine;
                }
            });
            bridgeContext.setDynamicState(2);
            GVTBuilder builder = new GVTBuilder();
            GraphicsNode gvtRoot = builder.build(bridgeContext, (Document)document);
            this.image = BSvgDecoder.initImage(bridgeContext, scale);
            if (scale != null) {
                AffineTransform trans = new AffineTransform();
                trans.scale(scale.getX(), scale.getY());
                gvtRoot.setTransform(trans);
            }
            this.image = BSvgDecoder.initImage(bridgeContext, scale);
            BSvgDecoder.renderImage(this.image, gvtRoot);
            this.animator = BSvgDecoder.hasAnimationElement((Node)document) ? new SvgAnimator(document, bridgeContext, gvtRoot, scale) : null;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public ImageAnimator getAnimator() {
        return this.animator;
    }

    private static BufferedImage initImage(BridgeContext bridgeContext, BTransform.Scale scale) {
        Dimension2D dim = bridgeContext.getDocumentSize();
        if (scale == null) {
            return new BufferedImage((int)(dim.getWidth() + 0.5), (int)(dim.getHeight() + 0.5), 2);
        }
        return new BufferedImage((int)(scale.getX() * dim.getWidth() + 0.5), (int)(scale.getY() * dim.getHeight() + 0.5), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearBackground(Graphics2D g2d, int width, int height) {
        Graphics2D newG = (Graphics2D)g2d.create();
        try {
            newG.setBackground(TRANSPARENT);
            newG.clearRect(0, 0, width, height);
        }
        finally {
            newG.dispose();
        }
    }

    private static void renderImage(BufferedImage image, GraphicsNode gvtRoot) {
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.addRenderingHints(HINTS);
        BSvgDecoder.clearBackground(g2d, image.getWidth(), image.getHeight());
        gvtRoot.paint(g2d);
    }

    private static boolean hasAnimationElement(Node node) {
        if (node instanceof SVGOMAnimationElement) {
            return true;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!BSvgDecoder.hasAnimationElement(children.item(i))) continue;
            return true;
        }
        return false;
    }

    static {
        HINTS.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        HINTS.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        HINTS.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        TRANSPARENT = new Color(0, 0, 0, 0);
        ParsedURL.registerHandler((ParsedURLProtocolHandler)new OrdParsedURLProtocolHandler());
        ImageTagRegistry.getRegistry().register((RegistryEntry)new OrdRegistryEntry());
        ENABLE_SVG_HYPERLINKING = AccessController.doPrivileged(() -> Boolean.getBoolean(ENABLE_SVG_HYPERLINKING_SYSPROP));
    }

    private static class SvgAnimator
    implements ImageAnimator,
    AnimatedAttributeListener,
    CSSNavigableDocumentListener {
        private final BridgeContext bridgeContext;
        private final GraphicsNode gvtRoot;
        private long baseMillis;
        private final BufferedImage[] animImages;
        private int curImage;
        private boolean changed = false;

        private SvgAnimator(SVGOMDocument document, BridgeContext bridgeContext, GraphicsNode gvtRoot, BTransform.Scale scale) {
            this.bridgeContext = bridgeContext;
            this.gvtRoot = gvtRoot;
            this.baseMillis = System.currentTimeMillis();
            this.animImages = new BufferedImage[2];
            this.curImage = 0;
            this.animImages[0] = BSvgDecoder.initImage(bridgeContext, scale);
            this.animImages[1] = BSvgDecoder.initImage(bridgeContext, scale);
            BSvgDecoder.renderImage(this.animImages[this.curImage], gvtRoot);
            document.addAnimatedAttributeListener((AnimatedAttributeListener)this);
            document.addCSSNavigableDocumentListener((CSSNavigableDocumentListener)this);
            SVGAnimationEngine engine = bridgeContext.getAnimationEngine();
            engine.start(0L);
            engine.setCurrentTime(0.0f);
        }

        public boolean animate() {
            this.changed = false;
            float elapsed = (float)(System.currentTimeMillis() - this.baseMillis) / 1000.0f;
            this.bridgeContext.getAnimationEngine().setCurrentTime(elapsed);
            if (this.changed) {
                int otherImage = (this.curImage + 1) % 2;
                BSvgDecoder.renderImage(this.animImages[otherImage], this.gvtRoot);
                this.curImage = otherImage;
            }
            return this.changed;
        }

        public Image getAnimatedImage() {
            return this.animImages[this.curImage];
        }

        public void animatedAttributeChanged(Element e, AnimatedLiveAttributeValue alav) {
            this.changed = true;
        }

        public void otherAnimationChanged(Element e, String type) {
            this.changed = true;
        }

        public void nodeInserted(Node newNode) {
            this.changed = true;
        }

        public void nodeToBeRemoved(Node oldNode) {
            this.changed = true;
        }

        public void subtreeModified(Node rootOfModifications) {
            this.changed = true;
        }

        public void characterDataModified(Node text) {
            this.changed = true;
        }

        public void attrModified(Element e, Attr attr, short attrChange, String prevValue, String newValue) {
            this.changed = true;
        }

        public void overrideStyleTextChanged(CSSStylableElement e, String text) {
            this.changed = true;
        }

        public void overrideStylePropertyRemoved(CSSStylableElement e, String name) {
            this.changed = true;
        }

        public void overrideStylePropertyChanged(CSSStylableElement e, String name, String val, String prio) {
            this.changed = true;
        }
    }
}

