/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.app;

import com.tridium.sys.Nre;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.app.BAppContainer;
import javax.baja.app.BIAppComponent;
import javax.baja.app.BIAppFolder;
import javax.baja.license.BILicensed;
import javax.baja.license.Feature;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="version", type="String", defaultValue="", flags=1)})
@NiagaraAction(name="update", flags=20)
public abstract class BApp
extends BComponent
implements BIService,
BIStatus,
ServiceListener,
BIAppComponent,
BILicensed {
    @Generated
    public static final Property status = BApp.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BApp.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property enabled = BApp.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property version = BApp.newProperty((int)1, (String)"", null);
    @Generated
    public static final Action update = BApp.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BApp.class);
    private static final BIcon icon = BIcon.std((String)"app.png");
    private static final Logger log = Logger.getLogger("app");
    private static final Type[] noTypes = new Type[0];
    private boolean fatalFault;
    private String fatalFaultCause = "";
    private boolean servicesFault;
    private String servicesFaultCause = "";
    private boolean configFault;
    private String configFaultCause = "";
    private BAppContainer container = null;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public String getVersion() {
        return this.getString(version);
    }

    @Generated
    public void setVersion(String v) {
        this.setString(version, v, null);
    }

    @Generated
    public void update() {
        this.invoke(update, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getRequiredServices() {
        return noTypes;
    }

    public String getAppId() {
        return this.getType().toString();
    }

    @Override
    public String getAppDisplayName(Context cx) {
        return this.getDisplayName(cx);
    }

    @Override
    public BIcon getAppDisplayIcon() {
        return this.getIcon();
    }

    protected void enabled() {
    }

    protected void disabled() {
    }

    protected void appOk() {
    }

    protected void appFail() {
    }

    protected static final Type[] append(Type[] a, Type b) {
        return BApp.append(a, new Type[]{b});
    }

    protected static final Type[] append(Type[] a, Type[] b) {
        Type[] types = new Type[a.length + b.length];
        System.arraycopy(a, 0, types, 0, a.length);
        System.arraycopy(b, 0, types, a.length, b.length);
        return types;
    }

    public void serviceStarted() throws Exception {
    }

    public void serviceStopped() throws Exception {
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public final boolean isParentLegal(BComponent parent) {
        return parent instanceof BIAppFolder;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 15: {
                this.fwServiceStarted();
                break;
            }
            case 16: {
                this.fwServiceStopped();
                break;
            }
            case 13: {
                this.fwDescendantsStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwServiceStarted() {
        this.setVersion(this.getType().getVendorVersion().toString());
        this.container = (BAppContainer)Sys.getService((Type)BAppContainer.TYPE);
        AccessController.doPrivileged(() -> Nre.getServiceManager()).addServiceListener((ServiceListener)this);
        this.checkLicense();
        this.update();
    }

    private void fwServiceStopped() {
        AccessController.doPrivileged(() -> Nre.getServiceManager()).removeServiceListener((ServiceListener)this);
    }

    private void fwDescendantsStarted() {
        this.update();
    }

    private void fwChanged(Property prop) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(enabled)) {
            this.update();
        }
    }

    public final boolean isDisabled() {
        return this.getStatus().isDisabled();
    }

    public final boolean isFault() {
        return this.getStatus().isFault();
    }

    public final boolean isOperational() {
        if (this.fatalFault) {
            return false;
        }
        return BApp.isOperational(this.getStatus());
    }

    private static boolean isOperational(BStatus status) {
        return !status.isDisabled() && !status.isFault();
    }

    public void doUpdate() {
        boolean newEnabled;
        if (!this.isRunning()) {
            return;
        }
        log.fine("App Update: " + this.getType());
        this.checkServices();
        boolean oldEnabled = !this.isDisabled();
        BStatus oldStatus = this.getStatus();
        int newBits = 0;
        if (!this.getEnabled()) {
            newBits |= 1;
        }
        String cause = "";
        if (this.fatalFault) {
            newBits |= 2;
            cause = this.fatalFaultCause;
        } else if (this.servicesFault) {
            newBits |= 2;
            cause = this.servicesFaultCause;
        } else if (this.configFault) {
            newBits |= 2;
            cause = this.configFaultCause;
        }
        if (!this.getFaultCause().equals(cause)) {
            this.setFaultCause(cause);
        }
        if (oldStatus.getBits() == newBits) {
            return;
        }
        BStatus newStatus = BStatus.make((int)newBits);
        this.setStatus(newStatus);
        if (BApp.isOperational(oldStatus) && !BApp.isOperational(newStatus)) {
            this.appFail();
        } else if (!BApp.isOperational(oldStatus) && BApp.isOperational(newStatus)) {
            this.appOk();
        }
        boolean bl = newEnabled = !this.isDisabled();
        if (oldEnabled != newEnabled) {
            if (newEnabled) {
                this.enabled();
            } else {
                this.disabled();
            }
        }
        if (Sys.atSteadyState()) {
            this.container.fireAppsModified(null);
        }
    }

    private void checkServices() {
        this.servicesFault = false;
        Type[] requiredServices = this.getRequiredServices();
        for (int i = 0; i < requiredServices.length; ++i) {
            try {
                Sys.getService((Type)requiredServices[i]);
                continue;
            }
            catch (ServiceNotFoundException ex) {
                this.servicesFault = true;
                this.servicesFaultCause = "Missing required service: " + requiredServices[i].toString();
                break;
            }
        }
        if (!this.servicesFault) {
            this.servicesFaultCause = "";
        }
    }

    public final boolean isFatalFault() {
        return this.fatalFault;
    }

    public final boolean isConfigFault() {
        return this.configFault;
    }

    public final boolean isServicesFault() {
        return this.servicesFault;
    }

    public final void configOk() {
        this.configFault = false;
        this.configFaultCause = "";
        this.update();
    }

    public final void configFail(String cause) {
        this.configFault = true;
        this.configFaultCause = cause;
        this.update();
    }

    public final void configFatal(String cause) {
        this.fatalFault = true;
        this.fatalFaultCause = cause;
        this.update();
    }

    public Feature getLicenseFeature() {
        return null;
    }

    private void checkLicense() {
        try {
            Feature feature = this.getLicenseFeature();
            if (feature != null) {
                feature.check();
            }
        }
        catch (Exception e) {
            this.fatalFault = true;
            this.fatalFaultCause = "Unlicensed: " + e;
            Logger.getLogger("service").log(Level.SEVERE, "Unlicensed: " + this.toPathString(), e);
        }
    }

    public final void serviceEvent(BServiceEvent event) {
        if (event.getId() == 0 || event.getId() == 1) {
            this.update();
        }
    }
}

