/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui.certExt;

import com.tridium.crypto.core.cert.CertificateParseException;
import com.tridium.crypto.core.cert.NGeneralName;
import com.tridium.crypto.core.cert.ext.NCRLDistributionPoints;
import com.tridium.crypto.core.cert.ext.NX509Extension;
import com.tridium.platcrypto.ui.certExt.BCrlDistributionPointPane;
import com.tridium.platcrypto.ui.certExt.BICertExtensionParameterPane;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.baja.gx.BSize;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.commands.HtmlHelpCommand;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.ReasonFlags;

@NiagaraType
public class BCrlDistributionPointsPane
extends BScrollPane
implements BICertExtensionParameterPane<NCRLDistributionPoints> {
    @Generated
    public static final Type TYPE = Sys.loadType(BCrlDistributionPointsPane.class);
    private final Map<Integer, DistributionPoint> points = new LinkedHashMap<Integer, DistributionPoint>();
    private final AtomicInteger rowCounter = new AtomicInteger();
    private static final Lexicon LEX = Lexicon.make((String)TYPE.getModule().getModuleName());
    private static final String TEXT_KEY = "txt";
    private static final String EDIT_KEY = "edit";
    private static final String DELETE_KEY = "del";
    private static final String EXT_NAME = LEX.getText("cert.field.crlDistributionPoints");
    private static final String HELP_LEX_KEY = "crl";
    private static final String OID = Extension.cRLDistributionPoints.getId();
    public static final DistributionPoint[] EMPTY_POINT_ARRAY = new DistributionPoint[0];
    private static final String FULL_NAME_DESC = "CrlDistributionPoints.fullNameDesc";
    private static final String REASONS_DESC = "CrlDistributionPoints.reasonsDesc";
    private static final String CRL_ISSUER_DESC = "CrlDistributionPoints.crlIssuerDesc";
    private static final String ADD_POINT_BASE = LEX.getText("CrlDistributionPoints.commands.addPoint");
    private static final String POINT_HELP = LEX.getText("CrlDistributionPoints.pointLabel.help");
    private static final String POINT_TITLE = LEX.getText("CrlDistributionPoints.pointTitle");
    private static final String EDIT_POINT_BASE = LEX.getText("CrlDistributionPoints.commands.edit");
    private static final String REMOVE_POINT_BASE = LEX.getText("CrlDistributionPoints.commands.remove");
    private static final String POINT_LABEL = LEX.getText("CrlDistributionPoints.pointLabel");
    private final BGridPane pointsPane = new BGridPane(3);
    private final BButton addButton = new BButton((Command)new AddRowCommand());
    private final BButton helpButton = new BButton((Command)new HtmlHelpCommand((BWidget)this, POINT_TITLE, POINT_HELP, BSize.make((double)300.0, (double)100.0), null));

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCrlDistributionPointsPane() {
        BEdgePane edge = new BEdgePane();
        this.pointsPane.setSize(300.0, 300.0);
        edge.setTop((BWidget)this.pointsPane);
        BFlowPane addPane = new BFlowPane();
        addPane.setAlign(BHalign.center);
        addPane.add("addBtn", (BValue)this.addButton);
        addPane.add("helpBtn", (BValue)this.helpButton);
        edge.setBottom((BWidget)addPane);
        this.setContent((BWidget)edge);
    }

    @Override
    public String getExtensionOid() {
        return OID;
    }

    @Override
    public String getExtensionName() {
        return EXT_NAME;
    }

    @Override
    public String getHelpLexiconKey() {
        return HELP_LEX_KEY;
    }

    @Override
    public void loadFromJson(String json, Map<String, Object> properties) throws CertificateParseException, IOException {
        if (!json.isEmpty()) {
            NCRLDistributionPoints points = (NCRLDistributionPoints)NX509Extension.decodeFromString((String)json);
            Extension ext = points.getExtension();
            CRLDistPoint crlDistPoint = CRLDistPoint.getInstance((Object)ext.getParsedValue());
            Arrays.stream(crlDistPoint.getDistributionPoints()).forEach(point -> this.addDistributionPoint((DistributionPoint)point));
        }
    }

    @Override
    public NCRLDistributionPoints toExtension(boolean isCritical) throws IOException {
        return NCRLDistributionPoints.make((boolean)isCritical, (DistributionPoint[])this.points.values().toArray(EMPTY_POINT_ARRAY));
    }

    @Override
    public String toDisplayText(Context cx) {
        return this.points.values().stream().map(point -> BCrlDistributionPointsPane.toDisplayText(point)).collect(Collectors.joining("\n"));
    }

    private static String toDisplayText(DistributionPoint point) {
        GeneralName[] crlNames;
        GeneralNames crlGeneralName;
        ReasonFlags reasonFlags;
        GeneralName[] distPointNames;
        StringBuilder text = new StringBuilder(POINT_LABEL).append(':');
        DistributionPointName distributionPointName = point.getDistributionPoint();
        if (distributionPointName != null && (distPointNames = ((GeneralNames)distributionPointName.getName()).getNames()).length > 0) {
            NGeneralName generalName = NGeneralName.make((GeneralName)distPointNames[0]);
            String distPointName = LEX.getText("cert.field.san." + generalName.getTagNo()) + ':' + generalName.getValueAsString() + (distPointNames.length > 1 ? " ..." : "");
            text.append("\n  ").append(LEX.getText(FULL_NAME_DESC, new Object[]{distPointName}));
        }
        if ((reasonFlags = point.getReasons()) != null) {
            ArrayList<String> chosenReasons = new ArrayList<String>();
            for (int i = 0; i < BCrlDistributionPointPane.REASON_LIST.size(); ++i) {
                if ((reasonFlags.intValue() & BCrlDistributionPointPane.REASON_LIST.get(i)) == 0) continue;
                chosenReasons.add(LEX.getText("cert.field.crlDistributionReason." + i));
            }
            text.append("\n  ").append(LEX.getText(REASONS_DESC, new Object[]{String.join((CharSequence)",", chosenReasons)}));
        }
        if ((crlGeneralName = point.getCRLIssuer()) != null && (crlNames = crlGeneralName.getNames()).length > 0) {
            NGeneralName generalName = NGeneralName.make((GeneralName)crlNames[0]);
            String crlName = LEX.getText("cert.field.san." + generalName.getTagNo()) + ':' + generalName.getValueAsString() + (crlNames.length > 1 ? " ..." : "");
            text.append("\n  ").append(LEX.getText(CRL_ISSUER_DESC, new Object[]{crlName}));
        }
        return text.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDistributionPoint(DistributionPoint point) {
        Map<Integer, DistributionPoint> map = this.points;
        synchronized (map) {
            int rowIndex = this.rowCounter.getAndIncrement();
            this.points.put(rowIndex, point);
            String value = BCrlDistributionPointsPane.toDisplayText(point);
            BTextEditorPane text = new BTextEditorPane(value, 7, 50, false);
            BButton editButton = new BButton((Command)new EditRowCommand(rowIndex));
            BButton deleteButton = new BButton((Command)new DeleteRowCommand(rowIndex));
            this.pointsPane.add(TEXT_KEY + rowIndex, (BValue)text);
            this.pointsPane.add(EDIT_KEY + rowIndex, (BValue)editButton);
            this.pointsPane.add(DELETE_KEY + rowIndex, (BValue)deleteButton);
            this.pointsPane.relayout();
            this.relayout();
        }
    }

    class DeleteRowCommand
    extends Command {
        final int rowIndex;

        public DeleteRowCommand(int rowIndex) {
            super((BWidget)BCrlDistributionPointsPane.this, LEX, REMOVE_POINT_BASE);
            this.rowIndex = rowIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() throws Exception {
            Map map = BCrlDistributionPointsPane.this.points;
            synchronized (map) {
                BCrlDistributionPointsPane.this.points.remove(this.rowIndex);
            }
            BCrlDistributionPointsPane.this.pointsPane.remove(BCrlDistributionPointsPane.TEXT_KEY + this.rowIndex);
            BCrlDistributionPointsPane.this.pointsPane.remove(BCrlDistributionPointsPane.EDIT_KEY + this.rowIndex);
            BCrlDistributionPointsPane.this.pointsPane.remove(BCrlDistributionPointsPane.DELETE_KEY + this.rowIndex);
            BCrlDistributionPointsPane.this.pointsPane.relayout();
            return null;
        }
    }

    class EditRowCommand
    extends Command {
        final int rowIndex;

        public EditRowCommand(int rowIndex) {
            super((BWidget)BCrlDistributionPointsPane.this, LEX, EDIT_POINT_BASE);
            this.rowIndex = rowIndex;
        }

        public CommandArtifact doInvoke() throws Exception {
            BCrlDistributionPointPane panel = new BCrlDistributionPointPane((DistributionPoint)BCrlDistributionPointsPane.this.points.get(this.rowIndex));
            int dialogResult = BDialog.open((BWidget)BCrlDistributionPointsPane.this, (String)POINT_TITLE, (Object)((Object)panel), (int)3);
            if (dialogResult == 1) {
                BCrlDistributionPointsPane.this.points.put(this.rowIndex, panel.getPoint());
                String updated = BCrlDistributionPointsPane.toDisplayText(panel.getPoint());
                BTextEditorPane text = (BTextEditorPane)BCrlDistributionPointsPane.this.pointsPane.get(BCrlDistributionPointsPane.TEXT_KEY + this.rowIndex).as(BTextEditorPane.class);
                text.setText(updated);
            }
            return null;
        }
    }

    class AddRowCommand
    extends Command {
        public AddRowCommand() {
            super((BWidget)BCrlDistributionPointsPane.this, LEX, ADD_POINT_BASE);
        }

        public CommandArtifact doInvoke() throws Exception {
            BCrlDistributionPointPane panel = new BCrlDistributionPointPane(null);
            int dialogResult = BDialog.open((BWidget)BCrlDistributionPointsPane.this, (String)POINT_TITLE, (Object)((Object)panel), (int)3);
            if (dialogResult == 1) {
                BCrlDistributionPointsPane.this.addDistributionPoint(panel.getPoint());
            }
            return null;
        }
    }
}

