/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui.certExt;

import com.tridium.crypto.core.cert.CertificateParseException;
import com.tridium.crypto.core.cert.ext.NBasicConstraints;
import com.tridium.crypto.core.cert.ext.NX509Extension;
import com.tridium.platcrypto.ui.certExt.BICertExtensionParameterPane;
import com.tridium.workbench.fieldeditors.BBooleanFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BSize;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.commands.HtmlHelpCommand;
import org.bouncycastle.asn1.x509.Extension;

@NiagaraType
@NiagaraAction(name="selectionChange")
public class BBasicConstraintsPane
extends BScrollPane
implements BICertExtensionParameterPane<NBasicConstraints> {
    @Generated
    public static final Action selectionChange = BBasicConstraintsPane.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBasicConstraintsPane.class);
    private static final Lexicon LEX = Lexicon.make((String)TYPE.getModule().getModuleName());
    private static final String SUBJECT_TYPE = LEX.getText("cert.BasicConstraintEditor.subjectType.label");
    private static final String END_ENTITY_TYPE = LEX.getText("cert.BasicConstraintEditor.subjectType.EndEntity");
    private static final String CA_TYPE = LEX.getText("cert.BasicConstraintEditor.subjectType.CA");
    private static final String PATH_LENGTH = LEX.getText("cert.BasicConstraintEditor.pathLength.label");
    private static final String HELP_TEXT = LEX.getText("cert.BasicConstraintEditor.pathLength.help");
    private static final String NONE = LEX.getText("cert.BasicConstraintEditor.pathLength.none");
    private static final String OPTIONAL = LEX.getText("cert.BasicConstraintEditor.pathLength.optional");
    private static final String EXT_NAME = LEX.getText("cert.field.basicConstraints");
    private static final String HELP_LEX_KEY = "bc";
    private static final String OID = Extension.basicConstraints.getId();
    private static final BFacets PATH_LENGTH_FACETS = BFacets.make((String)"min", (BIDataValue)BInteger.DEFAULT, (String)"max", (BIDataValue)BInteger.MAX);
    private static final Logger LOG = Logger.getLogger("platCrypto");
    private final BGridPane layoutPane = new BGridPane(1);
    private final BBooleanFE subjectTypeIsCa = new BBooleanFE();
    private final BCheckBox none = new BCheckBox(NONE);
    private final BIntegerFE maxPathLength = new BIntegerFE();
    private final BButton helpButton = new BButton((Command)new HtmlHelpCommand((BWidget)this, PATH_LENGTH, HELP_TEXT, BSize.make((double)300.0, (double)100.0), null));

    @Generated
    public void selectionChange() {
        this.invoke(selectionChange, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBasicConstraintsPane() {
        BGridPane subjectPane = new BGridPane(2);
        BLabel subjectLbl = new BLabel(SUBJECT_TYPE);
        subjectPane.add("lbl", (BValue)subjectLbl);
        subjectPane.add("isCa", (BValue)this.subjectTypeIsCa);
        this.layoutPane.add("subject", (BValue)subjectPane);
        BGridPane constraintPane = new BGridPane(5);
        BLabel constraintLbl = new BLabel(PATH_LENGTH);
        constraintPane.add("lbl", (BValue)constraintLbl);
        this.none.setEnabled(false);
        this.none.setSelected(true);
        constraintPane.add("none", (BValue)this.none);
        this.maxPathLength.setEnabled(false);
        constraintPane.add("max", (BValue)this.maxPathLength);
        BLabel optionalLbl = new BLabel(OPTIONAL);
        constraintPane.add("opt", (BValue)optionalLbl);
        constraintPane.add("help", (BValue)this.helpButton);
        this.layoutPane.add("constraint", (BValue)constraintPane);
        this.setContent((BWidget)this.layoutPane);
        this.linkTo((BComponent)this.subjectTypeIsCa, (Slot)BWbPlugin.setModified, (Slot)selectionChange);
        this.linkTo((BComponent)this.none, (Slot)BLabel.actionPerformed, (Slot)selectionChange);
    }

    @Override
    public String getExtensionOid() {
        return OID;
    }

    @Override
    public String getExtensionName() {
        return EXT_NAME;
    }

    @Override
    public String getHelpLexiconKey() {
        return HELP_LEX_KEY;
    }

    @Override
    public void loadFromJson(String json, Map<String, Object> properties) throws CertificateParseException, IOException {
        boolean isCAVal = false;
        int maxPathLengthVal = 0;
        if (!json.isEmpty()) {
            NBasicConstraints constraints = (NBasicConstraints)NX509Extension.decodeFromString((String)json);
            isCAVal = constraints.isCA();
            if (constraints.getPathLenConstraint() != null) {
                maxPathLengthVal = constraints.getPathLenConstraint().intValue();
            }
        }
        BFacets subjectTypeFacets = BFacets.make((String)"falseText", (BIDataValue)BString.make((String)END_ENTITY_TYPE), (String)"trueText", (BIDataValue)BString.make((String)CA_TYPE));
        this.subjectTypeIsCa.loadValue((BObject)BBoolean.make((boolean)isCAVal), (Context)subjectTypeFacets);
        this.none.setSelected(maxPathLengthVal == 0);
        this.maxPathLength.loadValue((BObject)BInteger.make((int)maxPathLengthVal), (Context)PATH_LENGTH_FACETS);
        this.doSelectionChange();
    }

    @Override
    public NBasicConstraints toExtension(boolean isCritical) throws IOException {
        try {
            boolean isCa = ((BBoolean)this.subjectTypeIsCa.saveValue().as(BBoolean.class)).getBoolean();
            boolean noPathLength = this.none.getSelected();
            int pathLength = ((BInteger)this.maxPathLength.saveValue().as(BInteger.class)).getInt();
            return isCa && !noPathLength && pathLength > 0 ? NBasicConstraints.make((boolean)isCritical, (int)pathLength) : NBasicConstraints.make((boolean)isCritical, (boolean)isCa);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public String toDisplayText(Context cx) throws Exception {
        boolean isCa = ((BBoolean)this.subjectTypeIsCa.saveValue().as(BBoolean.class)).getBoolean();
        boolean noPathLength = this.none.getSelected();
        int pathLength = ((BInteger)this.maxPathLength.saveValue().as(BInteger.class)).getInt();
        return SUBJECT_TYPE + '=' + (isCa ? CA_TYPE : END_ENTITY_TYPE) + ", " + PATH_LENGTH + '=' + (isCa && !noPathLength && pathLength > 0 ? Integer.valueOf(pathLength) : NONE);
    }

    public void doSelectionChange() {
        try {
            boolean isCa = ((BBoolean)this.subjectTypeIsCa.saveValue().as(BBoolean.class)).getBoolean();
            boolean isPathConstraint = !this.none.getSelected();
            this.none.setEnabled(isCa);
            this.maxPathLength.setEnabled(isCa && isPathConstraint);
            if (!isPathConstraint) {
                this.maxPathLength.loadValue((BObject)BInteger.DEFAULT, (Context)PATH_LENGTH_FACETS);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Failed to save sub-editor in: " + this.getClass().getSimpleName() + "#doSelectionChange", e);
        }
    }
}

