/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.crypto.core.cert.NoOpHostnameVerifier;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.core.IExtCryptoManager;
import com.tridium.platcrypto.core.IProviderInfo;
import com.tridium.platcrypto.core.NExemptionStore;
import com.tridium.platcrypto.core.NKeyStore;
import com.tridium.platcrypto.core.NProviderInfo;
import com.tridium.platcrypto.core.NTrustStore;
import com.tridium.platcrypto.ui.CryptoWbClientSocketFactory;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.security.crypto.ITrustStore;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;

@NiagaraType
public class BWbCertManager
extends BComponent
implements IExtCryptoManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BWbCertManager.class);
    private static Logger log = Logger.getLogger("platCrypto");
    private static final BIcon icon = BIcon.std((String)"files/certificate.png");
    private ICoreCryptoManager cryptoManager = null;
    private NTrustStore userTrustStore = null;
    private NTrustStore userUntrustedStore = null;
    private NTrustStore systemTrustStore = null;
    private NKeyStore keyStore = null;
    private NExemptionStore exemptionStore = null;
    private NProviderInfo providerInfo = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BWbCertManager make() throws Exception {
        return new BWbCertManager();
    }

    public BWbCertManager() throws Exception {
        log.finest("WbCryptoFactory started");
        ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
        this.cryptoManager = CoreCryptoManager.get((ISecurityInfoProvider)provider);
        try {
            AccessController.doPrivileged(() -> {
                HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new NoOpHostnameVerifier());
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public ITrustStore getUserTrustStore() throws Exception {
        if (this.userTrustStore == null) {
            this.userTrustStore = new NTrustStore(this.cryptoManager.getUserTrustStore());
        }
        return this.userTrustStore;
    }

    public ITrustStore getUserUntrustedStore() throws Exception {
        if (this.userUntrustedStore == null) {
            this.userUntrustedStore = new NTrustStore(this.cryptoManager.getUserUntrustedStore());
        }
        return this.userUntrustedStore;
    }

    public ITrustStore getSystemTrustStore() throws Exception {
        if (this.systemTrustStore == null) {
            this.systemTrustStore = new NTrustStore(this.cryptoManager.getSystemTrustStore());
        }
        return this.systemTrustStore;
    }

    public synchronized IKeyStore getKeyStore() throws Exception {
        if (this.keyStore == null) {
            this.keyStore = new NKeyStore(this.cryptoManager.getKeyStore());
        }
        return this.keyStore;
    }

    public synchronized ICoreExemptionStore getExemptionStore() throws Exception {
        if (this.exemptionStore == null) {
            this.exemptionStore = new NExemptionStore(this.cryptoManager.getExemptionStore());
        }
        return this.exemptionStore;
    }

    public synchronized IProviderInfo getProviderInfo() throws Exception {
        if (this.providerInfo == null) {
            this.providerInfo = new NProviderInfo(this.cryptoManager.getProviderInfo());
        }
        return this.providerInfo;
    }

    public File getBaseDir() {
        try {
            return new File(BWbCertManager.getFilePath(BOrd.make((String)"file:~etc/workbench")));
        }
        catch (Exception e) {
            return new File(Sys.getNiagaraUserHome(), "etc" + File.separator + "workbench");
        }
    }

    @Deprecated
    public ServerSocketFactory getServerSocketFactory(BSslTlsEnum type, boolean clientAuth, String serverAlias) throws Exception {
        throw new UnsupportedOperationException("not supported by workbench");
    }

    @Deprecated
    public SocketFactory getClientSocketFactory(BSslTlsEnum type) throws Exception {
        return this.getClientSocketFactory(new ClientTlsParameters(type.getTag()));
    }

    public SocketFactory getClientSocketFactory(ClientTlsParameters tlsParams) throws Exception {
        ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
        return new CryptoWbClientSocketFactory(provider, tlsParams);
    }

    public ICoreCryptoManager getCoreCryptoManager() {
        return this.cryptoManager;
    }

    private static String getFilePath(BOrd ord) throws IOException {
        OrdQuery[] o = ord.parse();
        FilePath p = (FilePath)o[o.length - 1];
        File f = BFileSystem.INSTANCE.pathToLocalFile(p);
        return f.getPath();
    }

    public BIcon getIcon() {
        return icon;
    }
}

