/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.ui;

import com.tridium.platcrypto.ui.BCertViewDialog;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.security.cert.CertificateEncodingException;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509Certificate;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;

@NiagaraType
@NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BCertRequestDialog
extends BCertViewDialog {
    @Generated
    public static final Action cancelButtonPressed = BCertRequestDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCertRequestDialog.class);
    static Lexicon lex = Lexicon.make((String)"platCrypto");
    static final BImage logo = BImage.make((String)lex.get("cert.x32.icon", "module://icons/x32/lock.png"));
    private BButton okButton;
    protected BButton cancelButton;
    protected boolean closeResult = false;

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static boolean request(BWidget owner, IX509Certificate cert) throws Exception {
        BCertRequestDialog dialog = new BCertRequestDialog(owner, cert);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getResult();
    }

    private BCertRequestDialog(BWidget parent, IX509Certificate cert) throws Exception {
        super(parent, lex.getText("csr.view.dialog.title"));
        this.cert = cert;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
    }

    @Override
    protected BWidget buildHeader() {
        return new BWizardHeader(logo, this.cert.getSubject(), lex.getText("csr.view.dialog.info", new Object[]{this.cert.getSubject()}));
    }

    @Override
    protected BWidget buildContent() throws Exception {
        BEdgePane edgePane = new BEdgePane();
        String msg = this.certCheck();
        if (msg != null && msg.trim().length() > 0) {
            edgePane.setTop(this.buildInfo(this.certCheck()));
        }
        edgePane.setCenter(super.buildContent());
        return edgePane;
    }

    private BWidget buildInfo(String msg) {
        BLabel label = new BLabel(lex.getText("cert.request.dialog.warnings") + System.lineSeparator() + msg, BHalign.left);
        StyleUtils.addStyleClass((IStylable)label, (String)"warning");
        return new BBorderPane((BWidget)label, 0.0, 0.0, 5.0, 0.0);
    }

    private String certCheck() throws CertificateEncodingException {
        StringBuilder msg = new StringBuilder();
        X500Name subject = this.cert.getSubjectDN();
        if (subject.getRDNs(BCStyle.CN).length <= 0) {
            msg.append(lex.getText("cert.request.dialog.common.name.warning")).append(System.lineSeparator());
        }
        if (subject.getRDNs(BCStyle.O).length <= 0) {
            msg.append(lex.getText("cert.request.dialog.organisation.warning")).append(System.lineSeparator());
        }
        if (subject.getRDNs(BCStyle.L).length <= 0) {
            msg.append(lex.getText("cert.request.dialog.city.warning")).append(System.lineSeparator());
        }
        if (subject.getRDNs(BCStyle.ST).length <= 0) {
            msg.append(lex.getText("cert.request.dialog.state.warning")).append(System.lineSeparator());
        }
        if (subject.getRDNs(BCStyle.C).length <= 0) {
            msg.append(lex.getText("cert.request.dialog.country.warning")).append(System.lineSeparator());
        }
        if (this.cert.getKeySize() < 2048) {
            msg.append(lex.getText("cert.request.dialog.keysize.warning")).append(System.lineSeparator());
        }
        return msg.toString();
    }

    @Override
    protected BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(true);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkB", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        this.cancelButton.setEnabled(true);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    @Override
    public void doOkButtonPressed(BWidgetEvent event) {
        this.closeResult = true;
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.closeResult = false;
        this.close();
    }

    public boolean getResult() {
        return this.closeResult;
    }
}

