/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program;

import java.util.Enumeration;
import java.util.Properties;
import javax.baja.nre.util.SortUtil;

public class MacroProperties
extends Properties {
    @Override
    public Object put(Object key, Object value) {
        return super.put(key, value);
    }

    public MacroProperties copy() {
        MacroProperties copy = new MacroProperties();
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            copy.put(key, this.get(key));
        }
        return copy;
    }

    public void append(Properties props) {
        if (props == null) {
            return;
        }
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            this.put(key, props.get(key));
        }
    }

    public String resolve(String key, String def) {
        String value = (String)this.get(key);
        if (value == null) {
            return def;
        }
        return this.resolve(key);
    }

    public String resolve(String key) {
        String value = (String)this.get(key);
        if (value == null) {
            throw new IllegalStateException("Missing property: " + key);
        }
        StringBuilder r = new StringBuilder();
        StringBuilder temp = new StringBuilder();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            try {
                char c = value.charAt(i);
                if (c != '%') {
                    r.append(c);
                    continue;
                }
                if ((c = value.charAt(++i)) == '%') {
                    r.append('%');
                    continue;
                }
                temp.setLength(0);
                int j = i;
                while ((c = value.charAt(j++)) != '%') {
                    temp.append(c);
                }
                String macro = temp.toString();
                r.append(this.resolve(macro));
                i = j - 1;
                continue;
            }
            catch (IllegalStateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalStateException("Invalid macro prop: " + key + "=" + value + "\n  " + e);
            }
        }
        return r.toString();
    }

    public void dump() {
        Object[] keys = new String[this.size()];
        Object[] values = new String[this.size()];
        Enumeration<Object> e = this.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            keys[i] = (String)e.nextElement();
            try {
                values[i] = this.resolve((String)keys[i]);
            }
            catch (Exception x) {
                System.out.println("Can't resolve " + (String)keys[i]);
            }
            ++i;
        }
        SortUtil.sort((Object[])keys, (Object[])values);
        for (i = 0; i < keys.length; ++i) {
            System.out.println((String)keys[i] + "=" + (String)values[i]);
        }
    }
}

