/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.CertificateNotTrustedException;
import com.tridium.crypto.core.cert.SigningUtil;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.program.BProgram;
import com.tridium.sys.Nre;
import com.tridium.sys.module.ModuleClassLoader;
import com.tridium.sys.module.NModule;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.KeyStore;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.ModuleInfo;
import javax.baja.security.BPermissions;
import javax.baja.status.BStatus;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIUnlinkable;
import javax.baja.sys.BLink;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="className", type="String", defaultValue="", flags=1), @NiagaraProperty(name="classFile", type="BBlob", defaultValue="BBlob.DEFAULT", flags=1), @NiagaraProperty(name="dependencies", type="String", defaultValue="", flags=1), @NiagaraProperty(name="signature", type="BBlob", defaultValue="BBlob.DEFAULT", flags=1), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3)})
public class BCode
extends BVector
implements IPropertyValidator,
BIUnlinkable {
    @Generated
    public static final Property className = BCode.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property classFile = BCode.newProperty((int)1, (BValue)BBlob.DEFAULT, null);
    @Generated
    public static final Property dependencies = BCode.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property signature = BCode.newProperty((int)1, (BValue)BBlob.DEFAULT, null);
    @Generated
    public static final Property status = BCode.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BCode.newProperty((int)3, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCode.class);
    public static final Logger log = Logger.getLogger("sys.program");
    protected static Lexicon lex = Lexicon.make((String)"program");
    public static final String SIGNATURE_SUFFIX = "#sig";
    static final Object loadLock = new Object();
    static ProgramClassLoader classLoader;
    static Map<String, byte[]> loadClassFiles;
    static Map<String, ModuleClassLoader> loadDependsMap;
    static ModuleClassLoader[] loadDepends;

    @Generated
    public String getClassName() {
        return this.getString(className);
    }

    @Generated
    public void setClassName(String v) {
        this.setString(className, v, null);
    }

    @Generated
    public BBlob getClassFile() {
        return (BBlob)this.get(classFile);
    }

    @Generated
    public void setClassFile(BBlob v) {
        this.set(classFile, (BValue)v, null);
    }

    @Generated
    public String getDependencies() {
        return this.getString(dependencies);
    }

    @Generated
    public void setDependencies(String v) {
        this.setString(dependencies, v, null);
    }

    @Generated
    public BBlob getSignature() {
        return (BBlob)this.get(signature);
    }

    @Generated
    public void setSignature(BBlob v) {
        this.set(signature, (BValue)v, null);
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Object newInstance() throws Exception {
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        try {
            String className = this.getClassName();
            if (className.length() == 0) {
                throw new IllegalStateException("Empty className");
            }
            if (className.equals("ProgramImpl") || className.equals("RobotImpl")) {
                throw new IllegalStateException("Must run programs thru program:com.tridium.program.RecompileTool");
            }
            BBlob classFile = this.getClassFile();
            if (classFile.length() == 0) {
                throw new IllegalStateException("Empty classFile");
            }
            BBlob signature = this.getSignature();
            CoreCryptoManager ccm = AccessController.doPrivileged(() -> {
                try {
                    return CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
                }
                catch (Exception e) {
                    return null;
                }
            });
            KeyStore[] trustStores = AccessController.doPrivileged(() -> {
                KeyStore ks = ccm.getKeyStore().getKeyStore();
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null, null);
                Enumeration<String> aliases = ks.aliases();
                while (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    Certificate cert = ks.getCertificate(alias);
                    if (cert == null || cert.getType() == null || !cert.getType().equals("X.509")) continue;
                    keyStore.setCertificateEntry(alias, cert);
                }
                return new KeyStore[]{ccm.getSystemTrustStore().getKeyStore(), ccm.getUserTrustStore().getKeyStore(), keyStore};
            });
            Boolean checkSigning = signature.length() > 0 || AccessController.doPrivileged(() -> Boolean.getBoolean("program.requireSigning")) != false;
            if (checkSigning.booleanValue()) {
                try {
                    SigningUtil.verifySignature((byte[])classFile.copyBytes(), (byte[])signature.copyBytes(), (KeyStore[])trustStores);
                    if (!SigningUtil.isTimestamped((byte[])classFile.copyBytes(), (byte[])signature.copyBytes())) {
                        log.warning(lex.getText("program.notTimestamped", new Object[]{this.toPathString()}));
                    }
                }
                catch (Exception e) {
                    BCode.handleVerificationFailed(e, ccm);
                }
            } else {
                log.warning(lex.getText("program.notSigned"));
            }
            ModuleClassLoader[] depends = this.resolveDependencies();
            ArrayList<ProgramClassEntry> innerClasses = new ArrayList<ProgramClassEntry>();
            SlotCursor c = this.getProperties();
            while (c.next(BBlob.class)) {
                if (!c.property().isDynamic() || SlotPath.unescape((String)c.property().getName()).endsWith(SIGNATURE_SUFFIX)) continue;
                byte[] innerBytes = ((BBlob)c.get()).copyBytes();
                if (checkSigning.booleanValue()) {
                    signature = (BBlob)this.get(c.property().getName() + SlotPath.escape((String)SIGNATURE_SUFFIX));
                    if (signature == null) {
                        signature = BBlob.DEFAULT;
                    }
                    try {
                        SigningUtil.verifySignature((byte[])innerBytes, (byte[])signature.copyBytes(), (KeyStore[])trustStores);
                    }
                    catch (Exception e) {
                        BCode.handleVerificationFailed(e, ccm);
                    }
                }
                innerClasses.add(new ProgramClassEntry(SlotPath.unescape((String)c.property().getName()), innerBytes));
            }
            Class<?> cls = BCode.loadClass(className, classFile.copyBytes(), innerClasses.toArray(new ProgramClassEntry[0]), depends);
            return cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.setStatus(BStatus.fault);
            this.setFaultCause(e.getMessage());
            throw e;
        }
    }

    private static void handleVerificationFailed(Exception e, CoreCryptoManager ccm) throws Exception {
        if (e instanceof CertificateNotTrustedException) {
            ICoreTrustStore untrustedStore = ccm.getUserUntrustedStore();
            Certificate cert = ((CertificateNotTrustedException)e).getCertificate();
            try {
                if (cert instanceof X509Certificate) {
                    CertUtils.addUniqueCertificate((X509Certificate)((X509Certificate)cert), (ICoreTrustStore)untrustedStore);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new LocalizableException("program", "program.certNotTrusted", (Throwable)e);
        }
        throw new LocalizableException("program", "program.failedVerification", (Throwable)e);
    }

    public String[] parseDependencies() {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(this.getDependencies(), ";");
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            if (name.length() <= 0 || BProgram.isSpecialModule(name)) continue;
            list.add(name);
        }
        return list.toArray(new String[0]);
    }

    private ModuleClassLoader[] resolveDependencies() throws Exception {
        ArrayList<ModuleClassLoader> list = new ArrayList<ModuleClassLoader>();
        for (String name : this.parseDependencies()) {
            String moduleName;
            block6: {
                moduleName = null;
                try {
                    ModuleInfo mInfo = Sys.getRegistry().moduleForDependency(name);
                    moduleName = mInfo.getModuleName();
                }
                catch (ModuleNotFoundException e) {
                    if (name.contains("-")) break block6;
                    moduleName = name;
                }
            }
            if (moduleName == null) continue;
            BModule module = Sys.loadModule((String)moduleName);
            try {
                for (NModule nmodule : AccessController.doPrivileged(() -> Nre.getModuleManager()).loadModuleParts(module.getModuleName())) {
                    ModuleClassLoader cl = nmodule.getClassLoader();
                    if (cl == null || list.contains(cl)) continue;
                    list.add(cl);
                }
            }
            catch (ModuleNotFoundException moduleNotFoundException) {
                // empty catch block
            }
        }
        return list.toArray(new ModuleClassLoader[0]);
    }

    public void clearInnerClassFiles() {
        Property[] props;
        for (Property prop : props = this.getDynamicPropertiesArray()) {
            this.remove(prop);
        }
    }

    public void clearInnerClassSignatures() {
        SlotCursor c = this.getProperties();
        while (c.next(BBlob.class)) {
            if (!c.property().isDynamic() || !SlotPath.unescape((String)c.property().getName()).endsWith(SIGNATURE_SUFFIX)) continue;
            this.remove(c.property());
        }
    }

    public void addInnerClassFile(String innerClassName, BBlob innerClassFile) throws Exception {
        String propName = SlotPath.escape((String)innerClassName);
        Property p = this.getProperty(propName);
        if (p == null) {
            this.add(propName, (BValue)innerClassFile, 1);
        } else {
            this.set(propName, (BValue)innerClassFile);
        }
    }

    public void addInnerClassSignature(String innerClassName, BBlob innerClassSignature) {
        String propName = SlotPath.escape((String)(innerClassName + SIGNATURE_SUFFIX));
        Property p = this.getProperty(propName);
        if (p == null) {
            this.add(propName, (BValue)innerClassSignature, 1);
        } else {
            this.set(propName, (BValue)innerClassSignature);
        }
    }

    public static String generateClassName() {
        BUuid uuid = BUuid.make();
        return "Prog_" + Long.toHexString(uuid.getMostSignificant()) + Long.toHexString(uuid.getLeastSignificant());
    }

    static Class<?> loadClass(String name, byte[] classFile, ModuleClassLoader[] depends) throws ClassNotFoundException {
        return BCode.loadClass(name, classFile, null, depends);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class<?> loadClass(String name, byte[] classFile, ProgramClassEntry[] innerClasses, ModuleClassLoader[] depends) throws ClassNotFoundException {
        Object object = loadLock;
        synchronized (object) {
            if (classLoader == null) {
                classLoader = AccessController.doPrivileged(() -> new ProgramClassLoader());
                loadDependsMap = new HashMap<String, ModuleClassLoader>();
                loadClassFiles = new HashMap<String, byte[]>();
            }
            for (ModuleClassLoader moduleClassLoader : depends) {
                String moduleName = moduleClassLoader.module.getModulePartName();
                if (loadDependsMap.get(moduleName) != null) continue;
                loadDependsMap.put(moduleName, moduleClassLoader);
            }
            loadDepends = loadDependsMap.values().toArray(new ModuleClassLoader[0]);
            loadClassFiles.put(name, classFile);
            if (innerClasses != null) {
                for (ProgramClassEntry programClassEntry : innerClasses) {
                    loadClassFiles.put(programClassEntry.name, programClassEntry.classFile);
                }
            }
        }
        return classLoader.loadClass(name);
    }

    public final BPermissions getPermissions(Context cx) {
        BPermissions permissions = super.getPermissions(cx);
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissions().isSuperUser()) {
            int mask = 0;
            if (permissions.hasOperatorRead()) {
                mask |= 1;
            }
            if (permissions.hasAdminRead()) {
                mask |= 0x10;
            }
            permissions = BPermissions.make((int)mask);
        }
        return permissions;
    }

    protected final LinkCheck doCheckLink(BComponent source, Slot sourceSlot, Slot targetSlot, Context cx) {
        return LinkCheck.makeInvalid((String)Lexicon.make((BModule)Sys.getBajaModule(), (Context)cx).getText("linkcheck.invalidLinkTarget"));
    }

    public final void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (Sys.isStationStarted() && value.getType().is(BLink.TYPE)) {
            throw new LocalizableRuntimeException("baja", "linkcheck.invalidLinkTarget");
        }
    }

    public final IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    public final IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public final void validateSet(Validatable validatable, Context context) {
        BCode.checkSuperUser(context);
    }

    public final void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        BCode.checkSuperUser(context);
    }

    private static void checkSuperUser(Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissions().isSuperUser()) {
            throw new LocalizableRuntimeException("baja", "RestrictedProgramObjException");
        }
    }

    private static class ProgramCodeSource
    extends CodeSource {
        static URL PROGRAM_URL;

        ProgramCodeSource() {
            super(PROGRAM_URL, (Certificate[])null);
        }

        static {
            try {
                PROGRAM_URL = new URL("program:");
            }
            catch (MalformedURLException e) {
                PROGRAM_URL = null;
            }
        }
    }

    private static class ProgramProtectionDomain
    extends ProtectionDomain {
        private static CodeSource PROGRAM_CODE_SOURCE = new ProgramCodeSource();
        private static PermissionCollection GLOBAL_PERMISSIONS = AccessController.doPrivileged(() -> Policy.getPolicy().getPermissions(new CodeSource(null, (Certificate[])null)));

        ProgramProtectionDomain(ClassLoader classLoader) {
            super(PROGRAM_CODE_SOURCE, GLOBAL_PERMISSIONS, classLoader, null);
        }
    }

    static class ProgramClassLoader
    extends SecureClassLoader {
        static ProgramProtectionDomain PROGRAM_PROTECTION_DOMAIN = null;

        ProgramClassLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            ModuleClassLoader[] depends = null;
            ModuleClassLoader[] moduleClassLoaderArray = loadLock;
            synchronized (loadLock) {
                byte[] classFile = loadClassFiles.get(name);
                if (classFile != null) {
                    loadClassFiles.remove(name);
                } else {
                    depends = (ModuleClassLoader[])loadDepends.clone();
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                if (PROGRAM_PROTECTION_DOMAIN == null) {
                    PROGRAM_PROTECTION_DOMAIN = new ProgramProtectionDomain(this);
                }
                if (classFile != null) {
                    return this.defineClass(name, classFile, 0, classFile.length, PROGRAM_PROTECTION_DOMAIN);
                }
                for (ModuleClassLoader depend : depends) {
                    Class cls = depend.nload(name, false);
                    if (cls == null) continue;
                    return cls;
                }
                throw new ClassNotFoundException(name);
            }
        }
    }

    static class ProgramClassEntry {
        String name;
        byte[] classFile;

        public ProgramClassEntry(String name, byte[] classFile) {
            this.name = name;
            this.classFile = classFile;
        }
    }
}

