/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.util;

import com.tridium.history.db.BLocalHistoryDatabase;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import javax.baja.history.BCapacity;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.DuplicateHistoryException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Sys;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

public class HistoryGen {
    private String dbDir;

    public static void main(String[] args) {
        int recordCount;
        int historyCount;
        int stationCount;
        String supervisor;
        try {
            if (args.length < 4) {
                throw new Exception("Not enough arguments!");
            }
            supervisor = args[0];
            stationCount = Integer.parseInt(args[1]);
            historyCount = Integer.parseInt(args[2]);
            recordCount = Integer.parseInt(args[3]);
        }
        catch (Exception e) {
            System.out.println("Usage: HistoryGen <supervisor station> <station count> <history count> <record count>");
            return;
        }
        Thread.currentThread().setPriority(10);
        BRelTime interval = BRelTime.make((long)900000L);
        float min = 0.0f;
        float max = 100.0f;
        int stationQualifier = 0;
        File niagaraUserHome = Sys.getNiagaraUserHome();
        File stationsDir = new File(niagaraUserHome, "stations");
        File stationHome = new File(stationsDir, supervisor);
        File historyDbDir = new File(stationHome, "history");
        HistoryGen gen = new HistoryGen(historyDbDir.getAbsolutePath());
        for (int station = 0; station < stationCount; ++station) {
            for (int history = 0; history < historyCount; ++history) {
                boolean success = false;
                while (!success) {
                    try {
                        BAbsTime start = BAbsTime.now();
                        BHistoryConfig cfg = new BHistoryConfig();
                        cfg.setId(BHistoryId.make("/station" + station + "-" + stationQualifier + "/history" + history));
                        cfg.setTimeZone(BTimeZone.getLocal());
                        cfg.setRecordType(BTypeSpec.make((String)"history:NumericTrendRecord"));
                        cfg.setInterval(BCollectionInterval.make(interval));
                        cfg.setCapacity(BCapacity.UNLIMITED);
                        gen.generate(cfg, start, recordCount, min, max);
                        success = true;
                    }
                    catch (IOException ioe) {
                        System.out.println("Unable to generate a history: ");
                        ioe.getCause().printStackTrace();
                    }
                    catch (DuplicateHistoryException e) {
                        ++stationQualifier;
                        success = false;
                    }
                }
            }
        }
    }

    private HistoryGen(String dbDir) {
        this.dbDir = dbDir;
    }

    public void generate(BHistoryConfig cfg, BAbsTime start, int recordCount, float min, float max) throws IOException {
        BLocalHistoryDatabase db = new BLocalHistoryDatabase(new File(this.dbDir));
        db.open();
        try (HistorySpaceConnection conn = db.getConnection(null);){
            BNumericTrendRecord rec = (BNumericTrendRecord)cfg.makeRecord();
            BAbsTime t = start;
            BRelTime interval = cfg.getInterval().getInterval();
            Random rand = new Random();
            conn.createHistory(cfg);
            BIHistory h = conn.getHistory(cfg.getId());
            for (int i = 0; i < recordCount; ++i) {
                rec.setTimestamp(t);
                rec.setValue(min + rand.nextFloat() * (max - min));
                conn.append(h, rec);
                t = t.add(interval);
            }
        }
        db.close();
    }
}

