/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.rollup;

import com.tridium.history.rollup.RollupValue;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BTrendFlags;
import javax.baja.history.BTrendRecord;
import javax.baja.status.BStatus;

public abstract class TrendRecordRollupValue
implements RollupValue {
    BStatus excludeStatus = BStatus.make((int)23);
    BTrendFlags excludeFlags = BTrendFlags.hidden;
    BTrendFlags excludeMergeFlags = BTrendFlags.hidden;

    public TrendRecordRollupValue() {
    }

    public TrendRecordRollupValue(BStatus excludeStatus, BTrendFlags excludeFlags, BTrendFlags excludeMergeFlags) {
        if (excludeStatus != null) {
            this.excludeStatus = excludeStatus;
        }
        if (excludeFlags != null) {
            this.excludeFlags = excludeFlags;
        }
        if (excludeMergeFlags != null) {
            this.excludeMergeFlags = excludeMergeFlags;
        }
    }

    public boolean includeElement(BStatus statusFlags, BTrendFlags elementFlags) {
        boolean statusOk = true;
        if (statusFlags != null) {
            statusOk = (this.excludeStatus.getBits() & statusFlags.getBits()) == 0;
        }
        boolean trendFlagsOk = true;
        if (elementFlags != null) {
            trendFlagsOk = (this.excludeFlags.getBits() & elementFlags.getBits()) == 0;
        }
        return statusOk && trendFlagsOk;
    }

    public BTrendFlags mergeFlags(BTrendFlags elementFlags) {
        int bits = this.excludeMergeFlags.getBits() & elementFlags.getBits();
        return BTrendFlags.make(bits ^= elementFlags.getBits());
    }

    @Override
    public final synchronized void addElement(BHistoryRecord rec) {
        if (rec instanceof BTrendRecord && this.includeElement(((BTrendRecord)rec).getStatus(), ((BTrendRecord)rec).getTrendFlags())) {
            this.doAddElement(rec);
        }
    }

    protected abstract void doAddElement(BHistoryRecord var1);
}

