/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.rollup;

import com.tridium.history.rollup.BRollupInterval;
import com.tridium.history.rollup.RollupValue;
import javax.baja.collection.AbstractCursor;
import javax.baja.collection.BITable;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Cursor;
import javax.baja.timezone.BTimeZone;

public class RollupCursor
extends AbstractCursor<BHistoryRecord> {
    private static final BRelTime NONE = BRelTime.make((long)0L);
    private static final BRelTime ONE_MIN = BRelTime.make((long)60000L);
    private static final BRelTime FIVE_MIN = BRelTime.make((long)300000L);
    private static final BRelTime FIFTEEN_MIN = BRelTime.make((long)900000L);
    private static final BRelTime THIRTY_MIN = BRelTime.make((long)1800000L);
    private static final BRelTime HOURLY = BRelTime.make((long)3600000L);
    private final RollupValue rollupVal;
    private final BITable<BHistoryRecord> collection;
    private BAbsTime startTime = null;
    private BAbsTime endTime = null;
    private BRelTime rollupTimeOffset = null;
    private BRollupInterval rollupInterval = null;
    private Cursor<BHistoryRecord> c;
    private BHistoryRecord currentRecord;
    private BAbsTime incrementStart = null;
    private BAbsTime incrementEnd = null;
    private BHistoryRecord lastRecord = null;
    private BAbsTime newTimestamp = null;
    private boolean skipLastIteration = true;

    public RollupCursor(RollupValue rollupVal, BITable<BHistoryRecord> collection, BRollupInterval interval) {
        this(rollupVal, collection, BRelTime.DEFAULT);
        this.rollupInterval = interval;
        this.incrementTimeIntervals();
        if (this.endTime != null && !this.endTime.isNull() && this.incrementEnd != null && this.incrementEnd.isAfter(this.endTime)) {
            this.incrementEnd = (BAbsTime)this.endTime.newCopy();
        }
    }

    public RollupCursor(RollupValue rollupVal, BITable<BHistoryRecord> collection, BRelTime rollupInterval) {
        this.rollupVal = rollupVal;
        this.collection = collection;
        this.rollupTimeOffset = rollupInterval;
        BTimeZone timezone = null;
        if (collection != null) {
            BFacets tableFacets = collection.getTableFacets();
            timezone = (BTimeZone)tableFacets.get("TimeZone", null);
            this.startTime = (BAbsTime)tableFacets.get("startTime", (BObject)BAbsTime.NULL);
            this.endTime = (BAbsTime)tableFacets.get("endTime", (BObject)BAbsTime.NULL);
            if (this.startTime.isNull()) {
                this.startTime = (BAbsTime)tableFacets.get("firstTimestamp", (BObject)BAbsTime.NULL);
            }
            if (this.endTime.isNull()) {
                this.endTime = (BAbsTime)tableFacets.get("lastTimestamp", (BObject)BAbsTime.NULL);
            }
        }
        this.c = collection.cursor();
        if (this.startTime.isNull() || this.endTime.isNull()) {
            while (this.c.next()) {
                if (this.c.get() == null) continue;
                BAbsTime timestamp = ((BHistoryRecord)this.c.get()).getTimestamp();
                if (this.startTime.isNull()) {
                    this.startTime = timestamp;
                    if (!this.endTime.isNull()) break;
                }
                this.endTime = timestamp;
            }
            this.c = collection.cursor();
        }
        if (!this.startTime.isNull() && !this.endTime.isNull()) {
            this.incrementStart = (BAbsTime)this.startTime.newCopy();
            this.incrementEnd = this.incrementStart.add(rollupInterval);
            if (this.incrementEnd.isAfter(this.endTime)) {
                this.incrementEnd = (BAbsTime)this.endTime.newCopy();
            }
            this.newTimestamp = this.incrementStart.subtract(rollupInterval);
        }
        if (timezone != null) {
            if (this.startTime != null && !this.startTime.isNull()) {
                this.startTime = BAbsTime.make((long)this.startTime.getMillis(), (BTimeZone)timezone);
            }
            if (this.endTime != null && !this.endTime.isNull()) {
                this.endTime = BAbsTime.make((long)this.endTime.getMillis(), (BTimeZone)timezone);
            }
            if (this.incrementStart != null && !this.incrementStart.isNull()) {
                this.incrementStart = BAbsTime.make((long)this.incrementStart.getMillis(), (BTimeZone)timezone);
            }
            if (this.incrementEnd != null && !this.incrementEnd.isNull()) {
                this.incrementEnd = BAbsTime.make((long)this.incrementEnd.getMillis(), (BTimeZone)timezone);
            }
            if (this.newTimestamp != null && !this.newTimestamp.isNull()) {
                this.newTimestamp = BAbsTime.make((long)this.newTimestamp.getMillis(), (BTimeZone)timezone);
            }
        }
    }

    protected boolean advanceCursor() {
        if (this.startTime == null || this.endTime == null || this.startTime.isAfter(this.endTime)) {
            return false;
        }
        if (this.rollupInterval == BRollupInterval.none) {
            while (this.c.next()) {
                if (this.c.get() == null) continue;
                BAbsTime timestamp = ((BHistoryRecord)this.c.get()).getTimestamp();
                this.rollupVal.reset();
                this.rollupVal.addElement((BHistoryRecord)this.c.get());
                this.currentRecord = this.rollupVal.getValue(timestamp, timestamp);
                return true;
            }
            return false;
        }
        boolean continueLooking = true;
        if (this.incrementEnd.isAfter(this.endTime) && !this.skipLastIteration) {
            BAbsTime timestamp;
            continueLooking = true;
            if (this.lastRecord != null) {
                timestamp = this.lastRecord.getTimestamp();
                if (timestamp.isAfter(this.endTime)) {
                    continueLooking = false;
                } else if (timestamp.isAfter(this.incrementStart) && !timestamp.equals((Object)this.newTimestamp)) {
                    this.rollupVal.addElement(this.lastRecord);
                    this.lastRecord = null;
                } else {
                    this.lastRecord = null;
                }
            }
            if (continueLooking) {
                while (this.c.next()) {
                    if (this.c.get() == null) continue;
                    timestamp = ((BHistoryRecord)this.c.get()).getTimestamp();
                    if (timestamp.isAfter(this.endTime)) {
                        this.lastRecord = (BHistoryRecord)this.c.get();
                        break;
                    }
                    if (timestamp.isAfter(this.incrementStart) && !timestamp.equals((Object)this.newTimestamp)) {
                        this.rollupVal.addElement((BHistoryRecord)this.c.get());
                        continue;
                    }
                    this.lastRecord = null;
                }
            }
            this.newTimestamp = BAbsTime.make((long)this.endTime.getMillis(), (BTimeZone)this.endTime.getTimeZone());
            this.currentRecord = this.rollupVal.getValue(this.incrementStart, this.newTimestamp);
            this.rollupVal.reset();
            this.skipLastIteration = true;
            return true;
        }
        if (!this.incrementEnd.isAfter(this.endTime)) {
            BAbsTime timestamp;
            continueLooking = true;
            if (this.lastRecord != null) {
                timestamp = this.lastRecord.getTimestamp();
                if (timestamp.isAfter(this.incrementEnd)) {
                    continueLooking = false;
                } else if (timestamp.isAfter(this.incrementStart) && !timestamp.equals((Object)this.newTimestamp)) {
                    this.rollupVal.addElement(this.lastRecord);
                    this.lastRecord = null;
                } else {
                    this.lastRecord = null;
                }
            }
            if (continueLooking) {
                while (this.c.next()) {
                    if (this.c.get() == null) continue;
                    timestamp = ((BHistoryRecord)this.c.get()).getTimestamp();
                    if (timestamp.isAfter(this.incrementEnd)) {
                        this.lastRecord = (BHistoryRecord)this.c.get();
                        break;
                    }
                    if (timestamp.isAfter(this.incrementStart) && !timestamp.equals((Object)this.newTimestamp)) {
                        this.rollupVal.addElement((BHistoryRecord)this.c.get());
                        continue;
                    }
                    this.lastRecord = null;
                }
            }
            this.newTimestamp = BAbsTime.make((long)this.incrementEnd.getMillis(), (BTimeZone)this.incrementEnd.getTimeZone());
            this.currentRecord = this.rollupVal.getValue(this.incrementStart, this.newTimestamp);
            this.rollupVal.reset();
            this.skipLastIteration = this.incrementEnd.equals((Object)this.endTime);
            this.incrementTimeIntervals();
            return true;
        }
        return false;
    }

    protected BHistoryRecord doGet() {
        return this.currentRecord;
    }

    private void incrementTimeIntervals() {
        if (null == this.rollupInterval) {
            this.incrementStart = this.incrementStart.add(this.rollupTimeOffset);
            this.incrementEnd = this.incrementEnd.add(this.rollupTimeOffset);
            return;
        }
        this.incrementStart = this.incrementEnd;
        if (this.rollupInterval == BRollupInterval.none) {
            return;
        }
        if (this.rollupInterval == BRollupInterval.oneMin) {
            this.incrementEnd = this.incrementStart.add(ONE_MIN);
        } else if (this.rollupInterval == BRollupInterval.fiveMin) {
            this.incrementEnd = this.incrementStart.add(FIVE_MIN);
        } else if (this.rollupInterval == BRollupInterval.fifteenMin) {
            this.incrementEnd = this.incrementStart.add(FIFTEEN_MIN);
        } else if (this.rollupInterval == BRollupInterval.thirtyMin) {
            this.incrementEnd = this.incrementStart.add(THIRTY_MIN);
        } else if (this.rollupInterval == BRollupInterval.hourly) {
            this.incrementEnd = this.incrementStart.add(HOURLY);
        } else if (this.rollupInterval == BRollupInterval.yearly) {
            this.incrementEnd = this.incrementStart.nextYear();
        } else if (this.rollupInterval == BRollupInterval.monthly) {
            this.incrementEnd = this.incrementStart.nextMonth();
        } else if (this.rollupInterval == BRollupInterval.daily) {
            this.incrementEnd = this.incrementStart.nextDay();
        }
    }
}

