/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.rollup;

import com.tridium.history.rollup.BHistoryRollupRecord;
import com.tridium.history.rollup.TrendRecordRollupValue;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BNumericTrendRecord;
import javax.baja.history.BTrendFlags;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;

public class CollectiveRollupValue
extends TrendRecordRollupValue {
    private double sum;
    private int count;
    private double min;
    private double max;
    private boolean firstElement = true;

    public CollectiveRollupValue() {
    }

    public CollectiveRollupValue(BStatus excludeStatus, BTrendFlags exclude, BTrendFlags excludeMergeFlags) {
        super(excludeStatus, exclude, excludeMergeFlags);
    }

    @Override
    protected synchronized void doAddElement(BHistoryRecord rec) {
        if (rec instanceof BNumericTrendRecord) {
            double val = ((BNumericTrendRecord)rec).getValue();
            if (this.firstElement) {
                this.max = val;
                this.min = val;
                this.firstElement = false;
            } else {
                if (val > this.max) {
                    this.max = val;
                }
                if (val < this.min) {
                    this.min = val;
                }
            }
            this.sum += val;
            ++this.count;
        }
    }

    @Override
    public BHistoryRecord getValue(BAbsTime start, BAbsTime end) {
        return new BHistoryRollupRecord(start, end, this.count, this.min, this.max, this.count > 0 ? this.sum / (double)this.count : 0.0, this.sum);
    }

    @Override
    public synchronized void reset() {
        this.sum = 0.0;
        this.count = 0;
        this.max = 0.0;
        this.min = 0.0;
        this.firstElement = true;
    }
}

