/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.log;

import com.tridium.util.ThrowableUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.ITruncatable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="logName", type="String", defaultValue=""), @NiagaraProperty(name="severity", type="int", defaultValue="Level.SEVERE.intValue()"), @NiagaraProperty(name="message", type="String", defaultValue=""), @NiagaraProperty(name="exception", type="String", defaultValue="")})
public class BLogRecord
extends BHistoryRecord
implements ITruncatable {
    @Generated
    public static final Property logName = BLogRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property severity = BLogRecord.newProperty((int)0, (int)Level.SEVERE.intValue(), null);
    @Generated
    public static final Property message = BLogRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property exception = BLogRecord.newProperty((int)0, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLogRecord.class);
    public static final int STACK_TRACE_DEPTH;

    @Generated
    public String getLogName() {
        return this.getString(logName);
    }

    @Generated
    public void setLogName(String v) {
        this.setString(logName, v, null);
    }

    @Generated
    public int getSeverity() {
        return this.getInt(severity);
    }

    @Generated
    public void setSeverity(int v) {
        this.setInt(severity, v, null);
    }

    @Generated
    public String getMessage() {
        return this.getString(message);
    }

    @Generated
    public void setMessage(String v) {
        this.setString(message, v, null);
    }

    @Generated
    public String getException() {
        return this.getString(exception);
    }

    @Generated
    public void setException(String v) {
        this.setString(exception, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLogRecord() {
    }

    public BLogRecord(BAbsTime timestamp, String logName, int severity, String message, String exception) {
        super(timestamp);
        this.setLogName(logName);
        this.setSeverity(severity);
        this.setMessage(message);
        this.setException(exception);
    }

    public static BLogRecord fromRecord(LogRecord record) {
        return new BLogRecord(BAbsTime.make((long)record.getMillis()), record.getLoggerName(), record.getLevel().intValue(), record.getMessage() == null ? "" : record.getMessage(), BLogRecord.formatThrowable(record.getThrown()));
    }

    public BLogRecord setFromRecord(LogRecord record) {
        String msg;
        this.setTimestamp(BAbsTime.make((long)record.getMillis()));
        this.setLogName(record.getLoggerName());
        this.setSeverity(record.getLevel().intValue());
        String string = msg = record.getMessage() == null ? "" : record.getMessage();
        if (record.getParameters() != null) {
            this.setMessage(MessageFormat.format(msg, record.getParameters()));
        } else {
            this.setMessage(msg);
        }
        this.setException(BLogRecord.formatThrowable(record.getThrown()));
        return this;
    }

    private static String formatThrowable(Throwable e) {
        return ThrowableUtil.dumpToString((Throwable)e, (int)STACK_TRACE_DEPTH);
    }

    @Override
    public boolean isFixedSize() {
        return false;
    }

    @Override
    protected void doRead(DataInput in) throws IOException {
        this.setLogName(in.readUTF());
        this.setSeverity(in.readInt());
        this.setMessage(in.readUTF());
        this.setException(in.readUTF());
    }

    @Override
    protected void doWrite(DataOutput out) throws IOException {
        out.writeUTF(this.getLogName());
        out.writeInt(this.getSeverity());
        out.writeUTF(this.getMessage());
        out.writeUTF(this.getException());
    }

    @Override
    public String toString(Context ctx) {
        String ex;
        StringBuilder s = new StringBuilder(32);
        s.append(super.toString(ctx));
        s.append('[').append(this.severityToString(this.getSeverity())).append(']');
        String message = this.getMessage();
        if (message.length() != 0) {
            s.append(TextUtil.truncate((String)message, (int)60));
        }
        if ((ex = this.getException()).length() != 0) {
            s.append(TextUtil.truncate((String)ex, (int)60));
        }
        return s.toString();
    }

    private String severityToString(int severity) {
        Level level = Level.parse(Integer.toString(severity));
        if (level != null) {
            return level.getName();
        }
        return "UNKNOWN=" + severity;
    }

    @Override
    public boolean truncate(int maxBytes) {
        boolean truncated = false;
        ByteBuffer timestampBytes = new ByteBuffer(16);
        try {
            if (this.version == 1) {
                this.getTimestamp().encode((DataOutput)timestampBytes);
            } else {
                this.getTimestamp().encode48((DataOutput)timestampBytes);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        int fixedBytes = timestampBytes.getLength() + ByteBuffer.utfEncodedSize((String)this.getLogName()) + 4;
        if (fixedBytes > maxBytes - 4) {
            return false;
        }
        String exceptionString = this.getException();
        int exceptionBytes = ByteBuffer.utfEncodedSize((String)exceptionString);
        int exceptionLen = exceptionString.length();
        String messageString = this.getMessage();
        int messageBytes = ByteBuffer.utfEncodedSize((String)messageString);
        int messageLen = messageString.length();
        while (fixedBytes + exceptionBytes + messageBytes > maxBytes) {
            if (exceptionBytes > 2) {
                truncated = true;
                exceptionBytes -= ByteBuffer.utfEncodedSize((char)exceptionString.charAt(--exceptionLen));
                continue;
            }
            truncated = true;
            messageBytes -= ByteBuffer.utfEncodedSize((char)messageString.charAt(--messageLen));
        }
        if (truncated) {
            this.setException(exceptionString.substring(0, exceptionLen));
            this.setMessage(messageString.substring(0, messageLen));
        }
        return true;
    }

    static {
        String sdepth = AccessController.doPrivileged(() -> System.getProperty("niagara.loghistory.error.depth", "5"));
        int idepth = 5;
        try {
            idepth = Integer.parseInt(sdepth);
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            STACK_TRACE_DEPTH = Math.min(Math.max(1, idepth), 20);
        }
    }
}

