/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.io;

import com.tridium.history.collection.ColumnSpec;
import com.tridium.history.io.HistoryInput;
import java.io.DataInput;
import java.io.IOException;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Type;

public class RecordInput
extends HistoryInput {
    private BHistoryRecord rec;
    private boolean uniqueRecs = false;
    private BFacets tableFacets;
    private ColumnSpec[] specs;
    private int historyVersion = 2;

    public RecordInput(DataInput in) {
        super(in);
    }

    public void setUniqueRecords(boolean unique) {
        this.uniqueRecs = unique;
    }

    public void setHistoryVersion(int version) {
        this.historyVersion = version;
    }

    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    public ColumnSpec[] getColumnSpecs() {
        return this.specs;
    }

    @Override
    public void doReadHeader(DataInput in) throws IOException {
        this.tableFacets = (BFacets)BFacets.DEFAULT.decode(in);
        if (!in.readBoolean()) {
            return;
        }
        int columnCount = in.readInt();
        this.specs = new ColumnSpec[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            this.specs[i] = ColumnSpec.read(in);
        }
    }

    @Override
    public BObject doRead(DataInput in) throws IOException {
        return this.newRecord().read(in);
    }

    private BHistoryRecord newRecord() throws IOException {
        if (this.rec == null) {
            Type recType = this.getObjectType();
            this.rec = (BHistoryRecord)recType.getInstance();
        }
        if (this.uniqueRecs) {
            this.rec = (BHistoryRecord)this.rec.newCopy(true);
        }
        this.rec.setHistoryVersion(this.historyVersion);
        return this.rec;
    }
}

