/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import com.tridium.history.file.recstore.Block;
import com.tridium.history.file.recstore.Page;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;

public class WriteBlock
extends Block
implements DataOutput {
    public final Page page;
    private int start;
    private int pos;

    public WriteBlock(Page page, int size) {
        super(size);
        this.page = page;
    }

    public void start(int blockInPage, int blocksInRec, int recBlock) throws IOException {
        this.pos = this.start = 12 + blockInPage * this.size;
        this.writeInt(blocksInRec);
        this.writeInt(recBlock);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.pos < this.start || this.pos >= this.start + this.size) {
            throw new IOException("Write out of range: " + this.pos + " not in " + this.start + " - " + (this.start + this.size - 1));
        }
        this.page.buf[this.pos++] = (byte)b;
    }

    @Override
    public void write(byte[] wbuf) throws IOException {
        this.write(wbuf, 0, wbuf.length);
    }

    @Override
    public void write(byte[] wbuf, int woffset, int wlen) throws IOException {
        int max = this.start + this.size - this.pos;
        if (wlen > max) {
            throw new IOException("Block overflow: " + wlen + " > " + max);
        }
        System.arraycopy(wbuf, woffset, this.page.buf, this.pos, wlen);
        this.pos += wlen;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v >>> 0 & 0xFF);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.write((int)(v >>> 56) & 0xFF);
        this.write((int)(v >>> 48) & 0xFF);
        this.write((int)(v >>> 40) & 0xFF);
        this.write((int)(v >>> 32) & 0xFF);
        this.write((int)(v >>> 24) & 0xFF);
        this.write((int)(v >>> 16) & 0xFF);
        this.write((int)(v >>> 8) & 0xFF);
        this.write((int)(v >>> 0) & 0xFF);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int strlen = s.length();
        for (int i = 0; i < strlen; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int strlen = s.length();
        for (int i = 0; i < strlen; ++i) {
            char v = s.charAt(i);
            this.write(v >>> 8 & 0xFF);
            this.write(v >>> 0 & 0xFF);
        }
    }

    @Override
    public void writeUTF(String s) throws IOException, UTFDataFormatException {
        throw new UnsupportedOperationException("writeUTF not supported");
    }
}

