/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.db;

import com.tridium.bql.collection.TypeColumnList;
import com.tridium.collection.EmptyTableCursor;
import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.history.BDataRecoveryHistoryRecorder;
import com.tridium.history.db.BHistoryDbTable;
import com.tridium.history.db.BLocalDbHistory;
import com.tridium.history.db.ConfigIndex;
import com.tridium.history.db.HistoryDbCursor;
import com.tridium.history.db.LocalDbConnection;
import com.tridium.history.db.LocalDbCursor;
import com.tridium.history.file.ArchiveHistoryWorkbenchNotifier;
import com.tridium.history.file.BFileHistoryTable;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.archive.FileArchive;
import com.tridium.sys.resource.ResourceReport;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.dataRecovery.IDataRecoveryRecord;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryEvent;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.DatabaseClosedException;
import javax.baja.history.HistoryException;
import javax.baja.history.db.BArchiveHistoryProvider;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.PatternFilter;

@NiagaraType
public class BLocalHistoryDatabase
extends BHistoryDatabase {
    @Generated
    public static final Type TYPE = Sys.loadType(BLocalHistoryDatabase.class);
    public static final String ARCHIVE_ID = "history";
    public static Thread WARM_UP_THREAD = null;
    private static final int DEVICE_GROUPS = 10;
    private static final int HISTORY_GROUPS = 10;
    private static final ColumnList COLUMN_LIST = new TypeColumnList(BHistoryConfig.TYPE, Context.NULL);
    private static final int SPY_COLUMN_COUNT = 2;
    private final HashMap<BHistoryId, Optional<BHistoryDbTable>> byId = new HashMap(29);
    private File dbDir;
    private String localStationName = "local";
    private ConfigIndex configIndex;
    private boolean closing = false;
    private BDataRecoveryHistoryRecorder dataRecoveryRestorer;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BLocalHistoryDatabase(File dbDir) {
        this.dbDir = dbDir;
    }

    public BLocalHistoryDatabase(File dbDir, String localStationName) {
        this.dbDir = dbDir;
        this.localStationName = localStationName;
    }

    public BLocalHistoryDatabase(BHistoryService service) {
    }

    public String getDirectory() {
        if (this.dbDir == null) {
            return "";
        }
        return this.dbDir.getAbsolutePath();
    }

    @Override
    public HistoryDatabaseConnection getDbConnection(Context cx) {
        return new LocalDbConnection(this, cx);
    }

    public TableCursor<BHistoryConfig> cursor() {
        if (this.configIndex == null) {
            return new EmptyTableCursor((BITable)this);
        }
        return new HistoryDbCursor(this, this.configIndex.cursor());
    }

    public ColumnList getColumns() {
        return COLUMN_LIST;
    }

    @Override
    protected void doOpen() throws IOException {
        try {
            AccessController.doPrivileged(() -> {
                if (this.dbDir == null) {
                    FilePath dbPath;
                    this.dbDir = null;
                    BSystemPlatformService plat = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
                    String platPath = plat.getRuntimeDirectory(ARCHIVE_ID);
                    BFileSpace fs = (BFileSpace)BOrd.make((String)"file:").get();
                    BIFile checkDir = fs.findFile(dbPath = new FilePath(platPath));
                    if (checkDir == null) {
                        BDirectory dir = fs.makeDir(dbPath);
                        this.dbDir = ((BLocalFileStore)dir.getStore()).getLocalFile();
                    } else {
                        this.dbDir = ((BLocalFileStore)checkDir.getStore()).getLocalFile();
                    }
                } else if (!this.dbDir.exists()) {
                    this.dbDir.mkdirs();
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        if (Sys.getStation() != null) {
            this.localStationName = Sys.getStation().getStationName();
        }
        File oldLocal = this.getDeviceDirectoryRaw(this.localStationName);
        try {
            AccessController.doPrivileged(() -> {
                File newLocal;
                if (oldLocal.exists() && oldLocal.isDirectory() && !oldLocal.renameTo(newLocal = this.getDeviceDirectory(this.localStationName))) {
                    log.severe("Cannot rename local directory.  Old data for local histories is left in " + oldLocal.getAbsolutePath());
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        this.configIndex = new ConfigIndex(this);
        this.configIndex.init();
        Spy.ROOT.add("localHistory", (Spy)new SpyLocalHistoryDatabase(this));
        if (AccessController.doPrivileged(() -> System.getProperty("niagara.history.warmup", "true")).equalsIgnoreCase("true")) {
            WARM_UP_THREAD = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long maxAge = BRelTime.makeMinutes((int)5).getMillis();
                    try {
                        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                        maxAge = service.getLingerTime();
                    }
                    catch (Exception service) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(2000L);
                        long start = Clock.ticks();
                        BHistoryDatabase.log.info("Starting async warmup of history config index...");
                        int i = 0;
                        int lastClose = 0;
                        BHistoryDevice[] devices = BLocalHistoryDatabase.this.listDevices();
                        for (int j = devices.length - 1; j >= 0; --j) {
                            if ((i += BLocalHistoryDatabase.this.listHistories(devices[j]).length) - lastClose < 200) continue;
                            lastClose = i;
                            BLocalHistoryDatabase.this.closeUnusedTables(maxAge);
                        }
                        BHistoryDatabase.log.info("Async history config index warmup completed in " + (Clock.ticks() - start) + " ms.");
                    }
                    catch (Exception e) {
                        BHistoryDatabase.log.log(Level.SEVERE, "Problem during async history config index warmup.", e);
                    }
                    finally {
                        if (Thread.currentThread() == WARM_UP_THREAD) {
                            WARM_UP_THREAD = null;
                        }
                        BLocalHistoryDatabase.this.closeUnusedTables(maxAge);
                    }
                }
            }, "HistoryConfigIndexWarmUp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        this.closing = true;
        ArrayList<Optional<BHistoryDbTable>> tables = new ArrayList<Optional<BHistoryDbTable>>();
        HashMap<BHistoryId, Optional<BHistoryDbTable>> hashMap = this.byId;
        synchronized (hashMap) {
            tables.addAll(this.byId.values());
            this.byId.clear();
        }
        for (int i = 0; i < tables.size(); ++i) {
            if (tables.get(i) == null || !((Optional)tables.get(i)).isPresent()) continue;
            BHistoryDbTable table = (BHistoryDbTable)((Object)((Optional)tables.get(i)).get());
            table.close();
        }
        this.configIndex = null;
        this.closing = false;
        Spy.ROOT.remove("localHistory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFlush() {
        ArrayList<Optional<BHistoryDbTable>> tables = new ArrayList<Optional<BHistoryDbTable>>();
        HashMap<BHistoryId, Optional<BHistoryDbTable>> hashMap = this.byId;
        synchronized (hashMap) {
            tables.addAll(this.byId.values());
        }
        for (int i = 0; i < tables.size(); ++i) {
            if (tables.get(i) == null || !((Optional)tables.get(i)).isPresent()) continue;
            try {
                ((BHistoryDbTable)((Object)((Optional)tables.get(i)).get())).flush();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void createArchive() throws IOException {
        BSystemPlatformService sys = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
        if (sys == null || !sys.archiveEnabled(ARCHIVE_ID)) {
            return;
        }
        long t1 = System.currentTimeMillis();
        try {
            AccessController.doPrivileged(() -> {
                FileArchive archive = null;
                LocalDbCursor c = new LocalDbCursor(this, null);
                while (c.next()) {
                    BHistoryId id = (BHistoryId)((Object)((Object)c.get()));
                    BHistoryDbTable table = this.getTable(id);
                    if (!(table instanceof BFileHistoryTable)) continue;
                    BFileHistoryTable fileTable = (BFileHistoryTable)table;
                    fileTable.lock();
                    long ticks1 = Clock.ticks();
                    fileTable.flush();
                    File[] tableFiles = fileTable.getFiles();
                    for (int i = 0; i < tableFiles.length; ++i) {
                        if (tableFiles[i].isDirectory()) continue;
                        String relPath = this.getRelativePath(tableFiles[i]);
                        if (archive == null) {
                            archive = sys.createFileArchive(ARCHIVE_ID);
                        }
                        archive.writeFile(tableFiles[i], relPath);
                    }
                    long ticks2 = Clock.ticks();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Archived " + fileTable.getConfig().getId().encodeToString() + " (" + (ticks2 - ticks1) + "ms)");
                    }
                    fileTable.unlock();
                }
                if (archive != null) {
                    archive.close();
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        long t2 = System.currentTimeMillis();
        log.info("Saved history archive (" + (t2 - t1) + "ms)");
    }

    String getRelativePath(File file) {
        String dbDirPath = this.dbDir.getAbsolutePath();
        return file.getAbsolutePath().substring(dbDirPath.length() + 1);
    }

    @Override
    public BHistoryDevice[] listDevices() {
        this.checkOpen();
        return this.configIndex.listDevices(true);
    }

    BHistoryDevice[] listDevicesFromFile() {
        ArrayList result = new ArrayList();
        AccessController.doPrivileged(() -> {
            String[] segs = this.dbDir.list();
            for (int i = 0; i < segs.length; ++i) {
                if (segs[i].equals("station")) {
                    result.add(this.localStationName);
                    continue;
                }
                File segDir = new File(this.dbDir, segs[i]);
                if (!segDir.exists() || !segDir.isDirectory()) continue;
                String[] deviceList = segDir.list();
                result.ensureCapacity(result.size() + deviceList.length);
                for (int j = 0; j < deviceList.length; ++j) {
                    result.add(deviceList[j]);
                }
            }
            return null;
        });
        int devCount = result.size();
        BHistoryDevice[] devs = new BHistoryDevice[devCount];
        for (int i = 0; i < devCount; ++i) {
            devs[i] = new BHistoryDevice(this, (String)result.get(i));
        }
        return devs;
    }

    @Override
    public BIHistory[] listHistories(BHistoryDevice device) {
        this.checkOpen();
        return this.configIndex.listHistories(device, true);
    }

    BIHistory[] listHistoriesFromFile(BHistoryDevice device) {
        this.checkOpen();
        String devName = device.getDeviceName();
        File deviceDir = this.getDeviceDirectory(devName);
        ArrayList historyIds = null;
        try {
            historyIds = AccessController.doPrivileged(() -> {
                if (!deviceDir.exists()) {
                    return new ArrayList();
                }
                ArrayList<BLocalDbHistory> result = new ArrayList<BLocalDbHistory>();
                String[] segs = deviceDir.list();
                for (int i = 0; i < segs.length; ++i) {
                    File segDir = new File(deviceDir, segs[i]);
                    if (!segDir.isDirectory()) continue;
                    String[] historyList = segDir.list();
                    result.ensureCapacity(result.size() + historyList.length);
                    for (int j = 0; j < historyList.length; ++j) {
                        if (!historyList[j].endsWith(".hdb")) continue;
                        int len = historyList[j].length();
                        BHistoryId id = BHistoryId.make(devName, historyList[j].substring(0, len - 4));
                        result.add(new BLocalDbHistory(this, id));
                    }
                }
                return result;
            });
        }
        catch (PrivilegedActionException e) {
            throw (HistoryException)((Object)e.getException());
        }
        return historyIds.toArray(new BIHistory[0]);
    }

    @Override
    public boolean deviceExists(String deviceName) {
        this.checkOpen();
        return this.configIndex.deviceExists(deviceName);
    }

    @Override
    public BHistoryDevice getDevice(String deviceName) {
        this.checkOpen();
        if (this.deviceExists(deviceName)) {
            return new BHistoryDevice(this, deviceName);
        }
        return null;
    }

    @Override
    protected void checkOpen() throws DatabaseClosedException {
        super.checkOpen();
    }

    @Override
    public BHistoryConfig getConfig(BHistoryId id) {
        this.checkOpen();
        return this.configIndex.get(id);
    }

    @Override
    public void setConfig(BHistoryConfig newConfig) {
        this.checkOpen();
        BHistoryId id = newConfig.getId();
        if (this.configIndex.get(id) == null) {
            return;
        }
        BHistoryDbTable table = this.getTable(id);
        BHistoryConfig oldConfig = table.getConfig();
        table.setConfig(newConfig);
        this.configIndex.update(id, newConfig);
        if (this.hasHistoryEventListeners() && !newConfig.equivalent((Object)oldConfig)) {
            this.fireHistoryEvent(BHistoryEvent.makeConfigChanged(id, newConfig));
        }
    }

    void deleteDirectory(File dirToRemove) {
        if (dirToRemove != null) {
            File fDirToRemove = dirToRemove;
            AccessController.doPrivileged(() -> {
                File[] subFiles = fDirToRemove.listFiles();
                if (subFiles != null) {
                    for (File file : subFiles) {
                        if (file.isDirectory()) {
                            this.deleteDirectory(file);
                            continue;
                        }
                        if (file.delete()) continue;
                        throw new HistoryException("Cannot delete file " + file + ".");
                    }
                }
                if (!fDirToRemove.delete()) {
                    throw new HistoryException("Cannot delete directory " + fDirToRemove + ".");
                }
                return null;
            });
        }
    }

    public BHistoryConfig[] getConfigs(String systemTagPatterns) {
        BHistoryDevice[] devices = this.listDevices();
        if (devices == null) {
            return null;
        }
        ArrayList<BHistoryConfig> configs = new ArrayList<BHistoryConfig>();
        PatternFilter[] patterns = PatternFilter.parseList((String)systemTagPatterns);
        if (patterns.length < 1) {
            return null;
        }
        for (int k = 0; k < devices.length; ++k) {
            BIHistory[] histories = this.listHistories(devices[k]);
            if (histories == null) continue;
            for (int m = 0; m < histories.length; ++m) {
                BHistoryConfig config = histories[m].getConfig();
                if (!BLocalHistoryDatabase.acceptSystemTags(config, patterns)) continue;
                configs.add(config);
            }
        }
        if (configs.size() < 1) {
            return null;
        }
        return configs.toArray(new BHistoryConfig[0]);
    }

    public static final boolean acceptSystemTags(BHistoryConfig config, PatternFilter[] systemTagPatterns) {
        String[] sysTags = config.getSystemTags().getNames();
        if (sysTags == null || sysTags.length == 0) {
            sysTags = new String[]{""};
        }
        for (int j = 0; j < sysTags.length; ++j) {
            for (int i = 0; i < systemTagPatterns.length; ++i) {
                if (!systemTagPatterns[i].accept(sysTags[j])) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BHistoryDbTable getTable(BHistoryId id) throws HistoryException {
        BHistoryDbTable table;
        block30: {
            table = null;
            if (id != null) {
                Object optional;
                HashMap<BHistoryId, Optional<BHistoryDbTable>> hashMap = this.byId;
                synchronized (hashMap) {
                    optional = this.byId.get((Object)id);
                    if (optional != null) {
                        while (!((Optional)optional).isPresent()) {
                            try {
                                this.byId.wait(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if ((optional = this.byId.get((Object)id)) != null) continue;
                        }
                        if (optional != null) {
                            table = ((Optional)optional).get();
                        } else {
                            this.byId.put(id, Optional.empty());
                        }
                    } else {
                        this.byId.put(id, Optional.empty());
                    }
                }
                boolean init = table == null;
                try {
                    if (!init) {
                        optional = table.getTableLock();
                        synchronized (optional) {
                            boolean bl = init = !table.isOpen();
                            if (!init) {
                                table.updateLastAccess();
                            }
                        }
                    }
                    if (!init) break block30;
                    try {
                        table = AccessController.doPrivileged(() -> {
                            BFileHistoryTable t = null;
                            File f = this.getFile(id, false);
                            if (f.exists()) {
                                try {
                                    t = BFileHistoryTable.createFromFile(this, f, this.isLocal(id));
                                    t.open();
                                }
                                catch (HistoryException e) {
                                    throw e;
                                }
                                catch (Exception e) {
                                    throw new HistoryException(e);
                                }
                            }
                            return t;
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (HistoryException)((Object)e.getException());
                    }
                }
                finally {
                    if (init) {
                        HashMap<BHistoryId, Optional<BHistoryDbTable>> hashMap2 = this.byId;
                        synchronized (hashMap2) {
                            if (table != null) {
                                this.byId.put(id, Optional.of(table));
                            } else {
                                this.byId.remove((Object)id);
                            }
                            this.byId.notifyAll();
                        }
                    }
                }
            }
        }
        return table;
    }

    void removeTable(BHistoryId id) {
        this.byId.remove((Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tableClosed(BHistoryDbTable table) {
        if (this.closing) {
            return;
        }
        if (table.getDatabase() != this) {
            return;
        }
        BHistoryConfig config = table.getConfig();
        if (config != null) {
            HashMap<BHistoryId, Optional<BHistoryDbTable>> hashMap = this.byId;
            synchronized (hashMap) {
                this.byId.remove((Object)config.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeUnusedTables(long maxAge) {
        ArrayList<Optional<BHistoryDbTable>> tables = new ArrayList<Optional<BHistoryDbTable>>();
        HashMap<BHistoryId, Optional<BHistoryDbTable>> hashMap = this.byId;
        synchronized (hashMap) {
            tables.addAll(this.byId.values());
        }
        long now = Clock.ticks();
        int tableCount = tables.size();
        for (int i = 0; i < tableCount; ++i) {
            if (tables.get(i) == null || !((Optional)tables.get(i)).isPresent()) continue;
            BHistoryDbTable table = (BHistoryDbTable)((Object)((Optional)tables.get(i)).get());
            Object object = table.getTableLock();
            synchronized (object) {
                if (!table.checkLastAccess(now, maxAge)) {
                    table.close();
                }
                continue;
            }
        }
    }

    public boolean isLocal(BHistoryId id) {
        return id.getDeviceName().equals(this.localStationName);
    }

    public String getLocalStationName() {
        return this.localStationName;
    }

    public File getDeviceDirectory(String deviceName) {
        File dir = null;
        if (deviceName.equals(this.localStationName)) {
            dir = new File(this.dbDir, "station");
        } else {
            int dgid = (deviceName.hashCode() & Integer.MAX_VALUE) % 10;
            String dgname = "seg" + dgid;
            dir = new File(this.dbDir, dgname + File.separatorChar + deviceName);
        }
        return dir;
    }

    private File getDeviceDirectoryRaw(String deviceName) {
        int dgid = (deviceName.hashCode() & Integer.MAX_VALUE) % 10;
        String dgname = "seg" + dgid;
        return new File(this.dbDir, dgname + File.separatorChar + deviceName);
    }

    public File getFile(BHistoryId id, boolean mkdirs) {
        String deviceName = id.getDeviceName();
        String historyName = id.getHistoryName();
        File deviceDir = this.getDeviceDirectory(deviceName);
        int hgid = (historyName.hashCode() & Integer.MAX_VALUE) % 10;
        String hgname = "seg" + hgid;
        File f = new File(deviceDir, hgname);
        if (mkdirs) {
            try {
                AccessController.doPrivileged(() -> {
                    f.mkdirs();
                    return null;
                });
            }
            catch (PrivilegedActionException e) {
                BHistoryService.logger.severe("Cannot create " + f + ": " + e.getMessage());
            }
        }
        return new File(f, historyName + ".hdb");
    }

    @Override
    public void dataRecoveryReserve() throws Exception {
        if (this.dataRecoveryRestorer != null) {
            this.dataRecoveryRestorer.resetHistoryIdMap();
        }
    }

    @Override
    public boolean dataRecoveryRestore(IDataRecoveryRecord rec) throws Exception {
        if (this.dataRecoveryRestorer != null) {
            return this.dataRecoveryRestorer.restore(this, rec);
        }
        return false;
    }

    @Override
    public void dataRecoveryRestoreComplete() {
        if (this.dataRecoveryRestorer != null) {
            this.dataRecoveryRestorer.restoreComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataRecoverySpy(SpyWriter out, Iterator<IDataRecoveryRecord> iterator) throws Exception {
        Hashtable<DataRecoverySpyStat, DataRecoverySpyStat> map = new Hashtable<DataRecoverySpyStat, DataRecoverySpyStat>();
        int totalEvents = 0;
        int count = 0;
        BHistoryEvent referenceEvent = BHistoryEvent.makeDbSaved();
        HashMap<Integer, String> encounterOrderToHistoryName = new HashMap<Integer, String>();
        while (iterator.hasNext()) {
            try {
                IDataRecoveryRecord rec = iterator.next();
                byte[] key = rec.getKey();
                ByteBuffer keyBuffer = new ByteBuffer(key);
                byte[] data = rec.getData();
                Object event = null;
                int len = -1;
                if (data == null || data.length == 0) {
                    event = referenceEvent.decode((DataInput)keyBuffer);
                    len = key.length;
                } else {
                    DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
                    BDataRecoveryHistoryRecorder.HistoryNameEntry nameEntry = new BDataRecoveryHistoryRecorder.HistoryNameEntry();
                    nameEntry.fromRecoveryBytes(dis);
                    event = nameEntry;
                    len = data.length;
                    encounterOrderToHistoryName.put(nameEntry.getEncounterOrder(), nameEntry.getHistoryName());
                }
                DataRecoverySpyStat stat = (DataRecoverySpyStat)map.get(new DataRecoverySpyStat(event));
                if (stat == null) {
                    stat = new DataRecoverySpyStat(event);
                    map.put(stat, stat);
                    ++count;
                }
                stat.event = event;
                ++stat.occurrences;
                stat.totalSize += len;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ++totalEvents;
            }
        }
        if (count > 0) {
            Object[] sorted = map.values().toArray(new DataRecoverySpyStat[0]);
            SortUtil.rsort((Object[])sorted);
            int len = sorted.length;
            String title = totalEvents + " History Events Recently Recorded in data recovery";
            if (len > BDataRecoveryComponentRecorder.SPY_EVENT_LIMIT) {
                len = BDataRecoveryComponentRecorder.SPY_EVENT_LIMIT;
                title = title + " (truncated to " + len + " rows)";
            }
            out.startTable(true);
            out.trTitle((Object)title, 4);
            out.w((Object)"<tr><th>Occurrences</th><th>Total Bytes</th><th>Avg Bytes</th><th>Last History Event of its Type</th></tr>\n");
            for (int i = 0; i < len; ++i) {
                String description;
                double avg = (double)((DataRecoverySpyStat)sorted[i]).totalSize / (double)((DataRecoverySpyStat)sorted[i]).occurrences;
                if (((DataRecoverySpyStat)sorted[i]).event instanceof BHistoryEvent) {
                    BHistoryEvent historyEvent = (BHistoryEvent)((Object)((DataRecoverySpyStat)sorted[i]).event);
                    description = historyEvent.toString(null);
                    try {
                        String actualHistoryName = (String)encounterOrderToHistoryName.get(Integer.valueOf(historyEvent.getHistoryId().getHistoryName()));
                        if (actualHistoryName != null) {
                            BHistoryId alternativeHistoryId = BHistoryId.make(historyEvent.getHistoryId().getDeviceName(), actualHistoryName);
                            description = BHistoryEvent.makeReplayEvent(historyEvent, alternativeHistoryId, true).toString(null);
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    description = ((BDataRecoveryHistoryRecorder.HistoryNameEntry)((DataRecoverySpyStat)sorted[i]).event).toString();
                }
                out.tr((Object)("" + ((DataRecoverySpyStat)sorted[i]).occurrences), (Object)("" + ((DataRecoverySpyStat)sorted[i]).totalSize), (Object)("" + avg), (Object)description);
            }
            out.endTable();
        }
        encounterOrderToHistoryName.clear();
    }

    public static final BPermissions getPermissionsForId(BHistoryDatabase db, BHistoryId id, Context cx) {
        if (cx != null && cx.getUser() != null && db.getType().is(TYPE) && db.getConfig(id) != null) {
            return cx.getUser().getPermissionsFor((BIProtected)new BLocalDbHistory((BLocalHistoryDatabase)db, id));
        }
        return BPermissions.all;
    }

    public static final BPermissions getPermissionsForDevice(BHistoryDatabase db, String deviceName, Context cx) {
        if (cx != null && cx.getUser() != null) {
            return cx.getUser().getPermissionsFor((BIProtected)new BHistoryDevice(db, deviceName));
        }
        return BPermissions.all;
    }

    @Override
    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 1002) {
            this.dataRecoveryRestorer = (BDataRecoveryHistoryRecorder)a;
            return null;
        }
        return super.fw(x, a, b, c, d);
    }

    private void reportResources(ResourceReport r) {
        int historyCount = 0;
        try (TableCursor<BHistoryConfig> cur = this.cursor();){
            while (cur.next()) {
                cur.get();
                ++historyCount;
            }
        }
        r.put("history.count", "" + historyCount);
    }

    ConfigIndex getConfigIndex() {
        return this.configIndex;
    }

    Object getTableCache() {
        return this.byId;
    }

    private void collectStats(Hashtable<String, FileHistoryTableStats> byName, Hashtable<BTypeSpec, FileHistoryTableStats> byTypeSpec) {
        LocalDbCursor c = new LocalDbCursor(this, null);
        while (c.next()) {
            BHistoryId id = (BHistoryId)((Object)c.get());
            BHistoryDbTable t = this.getTable(id);
            if (!(t instanceof BFileHistoryTable)) continue;
            BFileHistoryTable fileTable = (BFileHistoryTable)t;
            String name = fileTable.getConfig().getId().getHistoryName();
            byName.put(name, new FileHistoryTableStats(fileTable));
            BTypeSpec ts = fileTable.getConfig().getRecordType();
            FileHistoryTableStats stats = byTypeSpec.get(ts);
            if (stats == null) {
                stats = new FileHistoryTableStats(fileTable);
                byTypeSpec.put(ts, stats);
                continue;
            }
            stats.add(fileTable);
        }
    }

    public void dumpStats(PrintWriter out) throws IOException {
        Hashtable<BTypeSpec, FileHistoryTableStats> byTypeSpec = new Hashtable<BTypeSpec, FileHistoryTableStats>();
        Hashtable<String, FileHistoryTableStats> byName = new Hashtable<String, FileHistoryTableStats>();
        this.collectStats(byName, byTypeSpec);
        out.println(BAbsTime.now().toString());
        Iterator<String> e = byName.keySet().iterator();
        out.println("Name\t\tRecords\tAppends\tHdr Wr\tPg Wr");
        while (e.hasNext()) {
            String name = e.next();
            FileHistoryTableStats stats = byName.get(name);
            out.printf("%s\t%d\t%d\t%d\t%d\n", name, stats.recordCount, stats.totalRecords, stats.totalHeaderWrites, stats.totalPageWrites);
        }
        for (BTypeSpec ts : byTypeSpec.keySet()) {
            FileHistoryTableStats stats = byTypeSpec.get(ts);
            out.println(ts);
            long totalWrites = stats.totalPageWrites + stats.totalHeaderWrites;
            out.printf("\tRecords %d\n", stats.recordCount);
            out.printf("\tAppends %d\n", stats.totalRecords);
            out.printf("\tHeader %d\n", stats.totalHeaderWrites);
            out.printf("\tPage %d\n", stats.totalPageWrites);
            if (totalWrites != 0L) {
                out.printf("\trecords per write %d\n", stats.totalRecords / totalWrites);
                continue;
            }
            out.println("\trecords per write N/A");
        }
        out.flush();
    }

    public class SpyLocalHistoryDatabase
    extends SpyDir {
        private BLocalHistoryDatabase db;

        public SpyLocalHistoryDatabase(BLocalHistoryDatabase db) {
            this.db = db;
        }

        public Spy find(String name) {
            BHistoryId id = BHistoryId.make(this.db.getLocalStationName(), name);
            BHistoryDbTable table = this.db.getTable(id);
            return table.getTableSpy();
        }

        public void write(SpyWriter out) throws IOException {
            Hashtable byTypeSpec = new Hashtable();
            Hashtable byName = new Hashtable();
            this.db.collectStats(byName, byTypeSpec);
            out.startProps();
            out.trTitle((Object)this.db.getType().getTypeName(), 2);
            out.prop((Object)"dbDir", (Object)this.db.dbDir);
            out.prop((Object)"closing", this.db.closing);
            List<BArchiveHistoryProvider> archiveHistoryProviders = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getArchiveHistoryProviders().listProviders(false);
            for (BArchiveHistoryProvider provider : archiveHistoryProviders) {
                String rowName = provider.isOperational() ? "Operational Archive History Provider" : "Nonoperational Archive History Provider";
                out.prop((Object)rowName, (Object)provider.toDisplayPathString(null));
            }
            out.endProps();
            if (ArchiveHistoryWorkbenchNotifier.isSingletonLoaded()) {
                ArchiveHistoryWorkbenchNotifier.getInstance().spy(out);
            }
            out.nl();
            out.println("NOTE: Statistics are collected only since station boot AND while history is open");
            out.nl();
            out.startTable(true);
            out.w((Object)"<tr>");
            out.thTitle((Object)"Name");
            out.thTitle((Object)"Records");
            out.thTitle((Object)"Total Appends");
            out.thTitle((Object)"Header Writes");
            out.thTitle((Object)"Page Writes");
            out.w((Object)"</tr>");
            for (String name : byName.keySet()) {
                FileHistoryTableStats stats = (FileHistoryTableStats)byName.get(name);
                out.w((Object)"<tr>");
                out.td().a(name, (Object)name).endTd();
                out.td((Object)stats.recordCount);
                out.td((Object)stats.totalRecords);
                out.td((Object)stats.totalHeaderWrites);
                out.td((Object)stats.totalPageWrites);
                out.w((Object)"</tr>");
            }
            out.endTable();
            for (BTypeSpec ts : byTypeSpec.keySet()) {
                FileHistoryTableStats stats = (FileHistoryTableStats)byTypeSpec.get(ts);
                out.startProps();
                out.trTitle((Object)ts, 2);
                long totalWrites = stats.totalPageWrites + stats.totalHeaderWrites;
                out.prop((Object)"total records appended", (double)stats.totalRecords);
                out.prop((Object)"header writes", (double)stats.totalHeaderWrites);
                out.prop((Object)"page writes", (double)stats.totalPageWrites);
                out.prop((Object)"total writes", (double)totalWrites);
                if (totalWrites != 0L) {
                    out.prop((Object)"records per write", (double)(stats.totalRecords / totalWrites));
                } else {
                    out.prop((Object)"records per write", (Object)"N/A");
                }
                out.endProps();
            }
        }
    }

    class FileHistoryTableStats {
        int recordCount;
        long totalRecords;
        long totalPageWrites;
        long totalHeaderWrites;

        FileHistoryTableStats(BFileHistoryTable table) {
            this.recordCount = table.getRecordCount();
            this.totalRecords = table.getTotalRecordAppends();
            this.totalHeaderWrites = table.getHeaderWriteCount();
            this.totalPageWrites = table.getPageWriteCount();
        }

        void add(BFileHistoryTable table) {
            this.recordCount += table.getRecordCount();
            this.totalRecords += (long)table.getTotalRecordAppends();
            this.totalHeaderWrites += (long)table.getHeaderWriteCount();
            this.totalPageWrites += (long)table.getPageWriteCount();
        }
    }

    static class DataRecoverySpyStat
    implements Comparable<DataRecoverySpyStat> {
        Object event;
        int occurrences = 0;
        int totalSize = 0;
        int hashCode = -1;

        public DataRecoverySpyStat(Object event) {
            this.event = event;
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                int x;
                if (this.event instanceof BHistoryEvent) {
                    BHistoryEvent historyEvent = (BHistoryEvent)((Object)this.event);
                    x = 11;
                    x ^= historyEvent.getId();
                    BHistoryId histId = historyEvent.getHistoryId();
                    if (histId != null) {
                        x ^= histId.hashCode();
                    }
                } else {
                    BDataRecoveryHistoryRecorder.HistoryNameEntry nameEntry = (BDataRecoveryHistoryRecorder.HistoryNameEntry)this.event;
                    x = nameEntry.getHistoryName().hashCode();
                }
                this.hashCode = x;
            }
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof DataRecoverySpyStat) {
                DataRecoverySpyStat obj = (DataRecoverySpyStat)o;
                if (this.event instanceof BHistoryEvent) {
                    BHistoryEvent historyEvent = (BHistoryEvent)((Object)this.event);
                    BHistoryEvent objHistoryEvent = (BHistoryEvent)((Object)obj.event);
                    return historyEvent.getId() == objHistoryEvent.getId() && (historyEvent.getHistoryId() == objHistoryEvent.getHistoryId() || historyEvent.getHistoryId() != null && historyEvent.getHistoryId().equals((Object)objHistoryEvent.getHistoryId()));
                }
                BDataRecoveryHistoryRecorder.HistoryNameEntry nameEntry = (BDataRecoveryHistoryRecorder.HistoryNameEntry)this.event;
                BDataRecoveryHistoryRecorder.HistoryNameEntry objNameEntry = (BDataRecoveryHistoryRecorder.HistoryNameEntry)obj.event;
                return nameEntry.getHistoryName().equals(objNameEntry.getHistoryName());
            }
            return false;
        }

        @Override
        public int compareTo(DataRecoverySpyStat cdss) {
            int delta = this.occurrences - cdss.occurrences;
            if (delta == 0) {
                return 0;
            }
            if (delta < 0) {
                return -1;
            }
            return 1;
        }
    }
}

