/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history;

import com.tridium.history.HistoryConfigChange;
import java.util.ArrayList;
import javax.baja.history.BHistoryConfig;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;

public class HistoryConfigChanges {
    private ArrayList<HistoryConfigChange> list = new ArrayList(2);

    public static HistoryConfigChanges compare(BHistoryConfig oldConfig, BHistoryConfig newConfig) {
        Property newProp;
        HistoryConfigChanges result = new HistoryConfigChanges();
        if (newConfig == oldConfig) {
            return result;
        }
        SlotCursor oldProps = oldConfig.getProperties();
        while (oldProps.next()) {
            Property oldProp = oldProps.property();
            newProp = newConfig.getProperty(oldProp.getName());
            if (newProp == null) {
                result.add(HistoryConfigChange.makeRemoved(oldProp, oldProps.get()));
                continue;
            }
            BValue oldValue = oldProps.get();
            BValue newValue = newConfig.get(newProp);
            if (HistoryConfigChanges.equalProps(oldConfig, oldProp, newConfig, newProp) && oldValue.equivalent((Object)newValue)) continue;
            HistoryConfigChange change = HistoryConfigChange.makeChanged(oldProp, oldValue, newProp, newValue);
            result.add(change);
        }
        SlotCursor newProps = newConfig.getProperties();
        while (newProps.next()) {
            newProp = newProps.property();
            Property oldProp = oldConfig.getProperty(newProp.getName());
            if (oldProp != null) continue;
            result.add(HistoryConfigChange.makeAdded(newProp, newProps.get()));
        }
        return result;
    }

    private static boolean equalProps(BHistoryConfig c1, Property p1, BHistoryConfig c2, Property p2) {
        if (p1 == p2) {
            return true;
        }
        if (!p1.getName().equals(p2.getName())) {
            return false;
        }
        if (!p1.getType().equals(p2.getType())) {
            return false;
        }
        if (c1.getFlags((Slot)p1) != c2.getFlags((Slot)p2)) {
            return false;
        }
        return c1.getSlotFacets((Slot)p1).equals((Object)c2.getSlotFacets((Slot)p2));
    }

    public static void addMissingMetadata(BHistoryConfig oldConfig, BHistoryConfig newConfig, HistoryConfigChanges changes) {
        int size = changes.getChangeCount();
        for (int i = 0; i < size; ++i) {
            HistoryConfigChange change = changes.get(i);
            Property oldProp = change.getOldProperty();
            try {
                if (change.getChangeType() != 1 || oldProp == null || !Flags.isMetadata((BComplex)oldConfig, (Slot)oldProp)) continue;
                newConfig.add(oldProp.getName(), change.getOldValue(), oldConfig.getFlags((Slot)oldProp), oldConfig.getSlotFacets((Slot)oldProp), null);
                continue;
            }
            catch (Exception e) {
                String propName = oldProp != null ? oldProp.getName() : "null";
                System.out.println("Could not re-add missing dynamic metadata slot '" + propName + "' to the new config from the old config for " + (Object)((Object)oldConfig.getId()));
                e.printStackTrace();
            }
        }
    }

    public int getChangeCount() {
        return this.list.size();
    }

    public HistoryConfigChange get(int i) {
        return this.list.get(i);
    }

    public HistoryConfigChange get(String propName) {
        int count = this.list.size();
        for (int i = 0; i < count; ++i) {
            HistoryConfigChange change = this.list.get(i);
            Property prop = change.getOldProperty();
            if (prop != null && prop.getName().equals(propName)) {
                return change;
            }
            prop = change.getNewProperty();
            if (prop == null || !prop.getName().equals(propName)) continue;
            return change;
        }
        return null;
    }

    public String toString() {
        StringBuilder s = new StringBuilder(64);
        s.append("HistoryConfigChanges:\n");
        int count = this.list.size();
        for (int i = 0; i < count; ++i) {
            s.append("  ").append(this.list.get(i)).append('\n');
        }
        return s.toString();
    }

    public void add(HistoryConfigChange change) {
        this.list.add(change);
    }
}

