/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.util;

import com.tridium.json.JSONException;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.web.RestUtil;
import com.tridium.web.WebUtil;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import com.tridiumx.analytics.naming.AnalyticTrendCursor;
import com.tridiumx.analytics.naming.BAnalyticTrendRecord;
import com.tridiumx.analytics.naming.BAnalyticsStatusValue;
import java.io.IOException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Slot;
import javax.baja.units.BUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class AnalyticQueryServlet
extends HttpServlet {
    public static final int ERR_CODE_UNRESOLVED = 2;
    public static final int ERR_CODE_INTERNAL = 2;
    private static final Pattern boxTablePattern = Pattern.compile("/boxTable/.+");
    private static final Logger log = Logger.getLogger("analyticChart");

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block16: {
            resp.setHeader("transfer-encoding", "chunked");
            try {
                Context cx = (Context)req.getAttribute("niagara.context");
                RestUtil util = new RestUtil(req, resp);
                if (!util.acceptJson()) {
                    resp.sendError(406);
                    return;
                }
                RestUtil.Accept accept = util.getJsonAccept();
                if (accept.isCustomMediaType() && !accept.getCustomProtocol().equals("analytics")) {
                    resp.sendError(406);
                    return;
                }
                util.respond(accept, "application/json").respondNoCache();
                Writer writer = null;
                try {
                    if (util.matches(boxTablePattern)) {
                        BObject response;
                        String escapedOrd = util.get(1);
                        BOrd ord = BOrd.make((String)SlotPath.unescape((String)escapedOrd)).relativizeToSession().normalize();
                        writer = this.getWriter(resp);
                        OrdTarget target = ord.resolve(null, cx);
                        if (!target.canRead()) {
                            resp.sendError(404);
                        }
                        if ((response = target.get()) instanceof BITable) {
                            BITable dataTable = (BITable)response;
                            BFacets tFacets = dataTable.getTableFacets();
                            BBoolean mtf = (BBoolean)tFacets.get("mt");
                            if (mtf != null && mtf.getBoolean()) {
                                BInteger mtColCount = (BInteger)tFacets.get("tc");
                                int mtCount = mtColCount != null ? mtColCount.getInt() : 0;
                                this.encodeTableData(writer, dataTable, mtf.getBoolean(), mtCount);
                            } else {
                                this.encodeTableData(writer, dataTable, false, 1);
                            }
                        } else if (response instanceof BAnalyticsStatusValue) {
                            BAnalyticsStatusValue statusValue = (BAnalyticsStatusValue)response;
                            this.encodeStatusValue(writer, statusValue);
                        }
                        break block16;
                    }
                    resp.sendError(404);
                    return;
                }
                catch (Exception ex) {
                    if (writer != null) {
                        this.encodeErrorData(writer, ex);
                    }
                }
            }
            catch (Exception e) {
                if (WebUtil.isAbortException((Throwable)e)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "Connection Aborted", e);
                    }
                    return;
                }
                log.log(Level.SEVERE, "ServletException", e);
                if (e instanceof ServletException || e instanceof IOException) break block16;
                log.log(Level.SEVERE, e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeTableData(Writer out, BITable<?> table, boolean isMultiCol, int mtCount) throws Exception {
        BFacets facets = BFacets.NULL;
        try (TableCursor cursor = table.cursor();){
            boolean first = false;
            boolean skip = false;
            int cursorPos = 0;
            while (cursor.next()) {
                if (!skip) {
                    if (!first) {
                        first = true;
                    } else {
                        out.append('\n');
                    }
                }
                JSONWriter json = QuickJSONWriter.make((Appendable)out);
                Object entry = cursor.get();
                boolean used = false;
                if (entry instanceof BAnalyticTrendRecord) {
                    BAnalyticTrendRecord c = (BAnalyticTrendRecord)((Object)entry);
                    BAbsTime t = c.getTimestamp();
                    if (isMultiCol) {
                        skip = !this.encodeMinifiedMultiValueRecord(json, c, facets, table.getColumns(), cursorPos);
                    } else {
                        if (cursorPos == 0) {
                            facets = ((AnalyticTrendCursor)cursor).getFirstRecord().getSlotFacets((Slot)BAnalyticTrendRecord.value);
                        }
                        BValue v = c.getValue();
                        skip = !AnalyticQueryServlet.encodeMinifiedGenericValueRecord(json, t, v, c.getTrendFlags(), c.getStatus(), facets, cursorPos == 0);
                    }
                    ++cursorPos;
                    used = true;
                }
                if (used) continue;
                throw new IllegalStateException("Cursor.get() must return a javax.baja.collection.Row or javax.baja.sys.BComponent with timestamp and value properties: " + entry.getClass());
            }
        }
    }

    private boolean encodeMinifiedMultiValueRecord(JSONWriter out, BAnalyticTrendRecord c, BFacets facets, ColumnList colList, int cursorPos) throws Exception {
        if (c != null) {
            BString seriesName;
            int colCount = (colList.size() - 1) / 3;
            BAbsTime timestamp = c.getTimestamp();
            out.object();
            out.key("t").value((Object)timestamp.encodeToString());
            JSONWriter arrayWriter = out.key("v").array();
            for (int cIndex = 1; cIndex <= colCount; ++cIndex) {
                BInterpolationTrendFlags trendFlags;
                JSONWriter obj = arrayWriter.object();
                String colName = "value" + cIndex;
                BValue value = c.get(colName);
                AnalyticQueryServlet.writeMinifiedValue(obj.key("v"), value);
                BStatus status = (BStatus)c.get("status" + cIndex);
                if (status != null) {
                    obj.key("s").value((long)status.getBits());
                }
                if ((trendFlags = (BInterpolationTrendFlags)c.get("tf" + cIndex)) != null) {
                    obj.key("r").value((long)trendFlags.getBits());
                }
                if (cursorPos == 0) {
                    Column column = colList.get(colName);
                    String displayName = column.getDisplayName(null);
                    obj.key("sn").value((Object)displayName);
                }
                arrayWriter.endObject();
            }
            arrayWriter.endArray();
            BUnit unit = (BUnit)facets.get("units");
            if (unit != null) {
                out.key("u").value((Object)unit.encodeToString());
            }
            if ((seriesName = (BString)facets.get("seriesName")) != null) {
                out.key("sn").value((Object)seriesName);
            }
        } else {
            throw new LocalizableException("webChart", "webChart.msg.valueRequired");
        }
        out.endObject();
        return true;
    }

    public static boolean encodeMinifiedGenericValueRecord(JSONWriter out, BAbsTime timestamp, BValue value, BInterpolationTrendFlags trendFlags, BStatus status, BFacets facets, boolean addFacets) throws Exception {
        if (value == null || timestamp == null) {
            throw new LocalizableException("webChart", "webChart.msg.valueRequired");
        }
        AnalyticQueryServlet.encodeMinifiedEntry(out, timestamp, value, trendFlags, status, facets, addFacets);
        return true;
    }

    public static void encodeMinifiedEntry(JSONWriter out, BAbsTime timestamp, BValue value, BInterpolationTrendFlags trendFlags, BStatus status, BFacets facets, boolean addFacets) throws Exception {
        out.object();
        out.key("t").value((Object)timestamp.encodeToString());
        out.key("v");
        AnalyticQueryServlet.writeMinifiedValue(out, value);
        if (trendFlags != null) {
            out.key("r").value((long)trendFlags.getBits());
        }
        if (status != null) {
            out.key("s").value((long)status.getBits());
        }
        if (addFacets) {
            BUnit unit = (BUnit)facets.get("units");
            if (unit != null) {
                out.key("u").value((Object)unit.encodeToString());
            } else {
                out.key("u").value((Object)BUnit.DEFAULT);
            }
            String seriesName = String.valueOf(facets.get("seriesName"));
            if (seriesName != null) {
                out.key("sn").value((Object)facets.get("seriesName"));
            }
        }
        out.endObject();
    }

    public static void writeMinifiedValue(JSONWriter out, BValue value) throws Exception {
        try {
            if (value instanceof BDouble) {
                out.value(((BDouble)value).getDouble());
            } else if (value instanceof BFloat) {
                out.value((double)((BFloat)value).getFloat());
            } else if (value instanceof BInteger) {
                out.value((long)((BInteger)value).getInt());
            } else if (value instanceof BLong) {
                out.value(((BLong)value).getLong());
            } else if (value instanceof BEnum) {
                out.value((long)((BEnum)value).getOrdinal());
            } else {
                out.value((Object)value.asSimple().encodeToString());
            }
        }
        catch (JSONException e) {
            if ("JSON does not allow non-finite numbers.".equals(e.getMessage())) {
                out.value((Object)value.asSimple().encodeToString());
            }
            throw e;
        }
    }

    private void encodeStatusValue(Writer writer, BAnalyticsStatusValue statusValue) throws Exception {
        BOrd ord;
        BUnit unit;
        BStatus status;
        JSONWriter out = QuickJSONWriter.make((Appendable)writer);
        out.object();
        out.key("t").value((Object)BAbsTime.now().encodeToString());
        out.key("v");
        AnalyticQueryServlet.writeMinifiedValue(out, statusValue.getValueValue());
        BInterpolationTrendFlags trendFlags = statusValue.getTrendFlags();
        if (trendFlags != null) {
            out.key("r").value((long)trendFlags.getBits());
        }
        if ((status = statusValue.getStatus()) != null) {
            out.key("s").value((long)status.getBits());
        }
        if ((unit = statusValue.getUnit()) != null) {
            out.key("u").value((Object)unit.encodeToString());
        } else {
            out.key("u").value((Object)BUnit.DEFAULT);
        }
        String seriesName = statusValue.getSeriesName();
        if (seriesName != null) {
            out.key("sn").value((Object)seriesName);
        }
        if ((ord = statusValue.getOrd()) != null) {
            out.key("o").value((Object)ord.encodeToString());
        }
        out.endObject();
    }

    private void encodeErrorData(Writer writer, Exception ex) {
        JSONWriter out = QuickJSONWriter.make((Appendable)writer);
        out.object();
        if (ex instanceof UnresolvedException) {
            out.key("errcode").value(2L);
        } else {
            out.key("errcode").value(2L);
        }
        out.key("message").value((Object)ex.getMessage());
        out.key("type").value((Object)"err");
        out.endObject();
    }

    private Writer getWriter(HttpServletResponse resp) throws IOException {
        return resp.getWriter();
    }
}

