/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.util;

import java.io.IOException;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BUuid;

public class Alarms {
    private static volatile BAlarmService svc;
    private static volatile AlarmDbConnection alarmDbConnection;

    private Alarms() {
    }

    public static void ackAlarm(BAlarmRecord rec, Context cx) {
        if (rec.getAckState() != BAckState.acked) {
            BUser u = null;
            if (cx != null) {
                u = cx.getUser();
            }
            if (u != null) {
                rec.setUser(u.getUsername());
            }
            rec.setAckTime(Clock.time());
            rec.setAckState(BAckState.acked);
        }
    }

    public static void addNote(BAlarmRecord rec, String newNote, Context cx) {
        if (newNote == null) {
            return;
        }
        if ((newNote = newNote.trim()).length() == 0) {
            return;
        }
        newNote = Alarms.formatNote(newNote, cx);
        String prevNotes = null;
        BObject prev = rec.getAlarmFacet("notes");
        if (prev != null) {
            prevNotes = prev.toString(null).trim();
        }
        if (prevNotes != null && prevNotes.length() > 0) {
            newNote = newNote + "\n\n\n" + prevNotes;
        }
        rec.addAlarmFacet("notes", (BIDataValue)BString.make((String)newNote));
    }

    public static void clear(BAlarmRecord rec, String note) {
        Alarms.ackAlarm(rec, null);
        Alarms.toNormal(rec);
        if (note != null) {
            Alarms.addNote(rec, note, null);
        }
    }

    public static String formatNote(String msg, Context cx) {
        StringBuilder buf = new StringBuilder(500);
        buf.append("*** ");
        buf.append(Clock.time().toString());
        if (cx != null && cx.getUser() != null) {
            buf.append(" - ").append(cx.getUser().getUsername());
        }
        buf.append(" ***\n");
        buf.append(msg.trim());
        return buf.toString();
    }

    public static BAlarmRecord getAlarm(String uuid) throws Exception {
        return Alarms.getAlarm((BUuid)BUuid.DEFAULT.decodeFromString(uuid));
    }

    public static BAlarmRecord getAlarm(BUuid uuid) throws Exception {
        return Alarms.getConnection().getRecord(uuid);
    }

    public static BAlarmClass getAlarmClass(BAlarmRecord rec) throws Exception {
        BAlarmService s = Alarms.svc();
        BAlarmClass ret = s.lookupAlarmClass(rec.getAlarmClass());
        if (ret == null) {
            return s.getDefaultAlarmClass();
        }
        return ret;
    }

    public static BAlarmClass[] getAlarmClasses() {
        return (BAlarmClass[])Alarms.svc().getChildren(BAlarmClass.class);
    }

    public static AlarmDbConnection getConnection() {
        if (alarmDbConnection == null) {
            alarmDbConnection = Alarms.svc().getAlarmDb().getDbConnection(null);
        }
        return alarmDbConnection;
    }

    public static void closeConnection() {
        if (alarmDbConnection != null) {
            alarmDbConnection.close();
            alarmDbConnection = null;
        }
    }

    public static Cursor<BAlarmRecord> openAlarms() throws IOException {
        return Alarms.getConnection().getOpenAlarms();
    }

    public static BBoolean save(BAlarmRecord rec) {
        try {
            Alarms.getConnection().update(rec);
            if (rec.getAckState() == BAckState.ackPending) {
                Alarms.svc().ackAlarm(rec);
            } else {
                Alarms.svc().routeAlarm(rec);
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            return BBoolean.FALSE;
        }
        return BBoolean.TRUE;
    }

    public static BAlarmService svc() {
        if (svc != null && svc.isRunning()) {
            return svc;
        }
        try {
            svc = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        }
        catch (ServiceNotFoundException x) {
            x.printStackTrace();
        }
        return svc;
    }

    public static void toNormal(BAlarmRecord rec) {
        if (rec.getSourceState() != BSourceState.normal) {
            rec.setNormalTime(Clock.time());
            rec.setSourceState(BSourceState.normal);
        }
    }
}

