/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.trend;

import com.tridiumx.analytics.trend.AbstractTrend;
import com.tridiumx.analytics.trend.AbstractTrendWrapper;
import javax.baja.sys.BAbsTime;
import javax.baja.util.BDaysOfWeekBits;
import javax.bajax.analytics.data.AnalyticValue;

public class FilteredNiagaraTrend
extends AbstractTrendWrapper {
    private BDaysOfWeekBits dowInclusion = BDaysOfWeekBits.DEFAULT;

    public FilteredNiagaraTrend(AbstractTrend trend) {
        super(trend);
        if (trend.getContext() != null) {
            this.dowInclusion = trend.getContext().getDowInclusion();
        }
    }

    @Override
    protected AnalyticValue getNext() {
        if (!this.trend.hasNext()) {
            return null;
        }
        AnalyticValue avValue = this.trend.next();
        BAbsTime ts = BAbsTime.make((long)avValue.getTimestamp());
        while (avValue != null && !this.include(ts)) {
            avValue = null;
            if (!this.trend.hasNext()) break;
            avValue = this.trend.next();
            ts = BAbsTime.make((long)avValue.getTimestamp());
        }
        return avValue;
    }

    private boolean include(BAbsTime timestamp) {
        if (this.dowInclusion != null && this.dowInclusion != BDaysOfWeekBits.DEFAULT) {
            return this.dowInclusion.includes(timestamp);
        }
        return true;
    }
}

