/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.naming;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.util.BBinderCacheScheme;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.naming.AnalyticTarget;
import com.tridiumx.analytics.naming.BAbstractTrendResolver;
import com.tridiumx.analytics.util.Strings;
import com.tridiumx.analytics.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.baja.collection.BITable;
import javax.baja.hierarchy.BHierarchyScheme;
import javax.baja.hierarchy.BHierarchyService;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.InvalidOrdBaseException;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBlob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.BCombination;

@NiagaraType
public abstract class BAnalyticOrdScheme
extends BBinderCacheScheme {
    @Generated
    public static final Type TYPE = Sys.loadType(BAnalyticOrdScheme.class);
    private static BHierarchyService hierSvc;

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BAnalyticOrdScheme(String scheme) {
        super(scheme);
    }

    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        try {
            BAnalyticService service = BAnalyticService.getInstance();
            if (Sys.isStation() && !service.isSteady()) {
                return base;
            }
            BISession session = this.toSession(base);
            if (session instanceof BFoxSession) {
                return this.resolveFox((BFoxSession)session, base, query);
            }
            Map<String, String> args = this.parseQuery(query);
            if (!args.containsKey("node")) {
                BString hierarchyOrd = (BString)base.getFacet("hierarchyQuery");
                if (hierarchyOrd != null && this.isHierarchyBase(base)) {
                    args.put("node", hierarchyOrd.getString());
                } else {
                    String node = Utils.resolveNode(base, this.getId());
                    if ("slot:".equals(node)) {
                        BINavNode navNode = (BINavNode)base.get();
                        node = navNode.getNavOrd().relativizeToSession().toString(null);
                    }
                    if (node != null) {
                        args.put("node", node);
                    }
                }
            }
            AnalyticContext cx = this.getAnalyticContext(base, args);
            BUnit unit = cx.getUnit(false);
            if (cx.getNode() == null) {
                cx.setNode(Utils.resolveNode(base));
            }
            BFacets facets = cx.getFacets();
            BObject val = this.resolve(cx);
            if (facets != null) {
                if (unit != null && unit.isNull()) {
                    facets = BFacets.makeRemove((BFacets)facets, (String)"units");
                } else if (cx.getAggregation(false) == BCombination.count || cx.getAggregation(false) == BCombination.loadFactor) {
                    facets = BFacets.makeRemove((BFacets)facets, (String)"units");
                } else if (cx.getRollup(false) == BCombination.count || cx.getRollup(false) == BCombination.loadFactor) {
                    facets = BFacets.makeRemove((BFacets)facets, (String)"units");
                }
            }
            if (args.get("remoteFox") != null && !(val instanceof BITable)) {
                BComponent comp = new BComponent();
                comp.add("facets", (BValue)facets);
                comp.add("value", (BValue)val);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(baos);
                ValueDocEncoder encoder = new ValueDocEncoder((OutputStream)gzos);
                encoder.encodeDocument((BValue)comp);
                encoder.close();
                val = BString.make((String)BBlob.make((byte[])baos.toByteArray()).encodeToString());
            }
            return new AnalyticTarget(base, val, facets);
        }
        catch (Exception x) {
            x.printStackTrace();
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            throw new RuntimeException(x);
        }
    }

    protected Map<String, String> parseQuery(OrdQuery query) {
        return Strings.decodeQueryString(query.getBody());
    }

    public AnalyticContext getAnalyticContext(OrdTarget base, Map<String, String> args) {
        return AnalyticContext.make(args, (Context)base);
    }

    protected abstract BObject resolve(AnalyticContext var1);

    protected abstract BAbstractTrendResolver getResolver(AnalyticContext var1, AnalyticTrend var2);

    protected boolean isHierarchyBase(OrdTarget base) {
        OrdQuery[] qList = base.getOrdQueries();
        OrdQuery lastBaseQuery = null;
        int index = -1;
        int slotSchemeIndex = -1;
        for (index = 0; index < qList.length; ++index) {
            OrdQuery q = qList[index];
            if ("slot".equals(q.getScheme())) {
                slotSchemeIndex = index;
            }
            if (q.getScheme().equals(this.getId())) break;
            lastBaseQuery = q;
        }
        if (lastBaseQuery == null) {
            return false;
        }
        String lastScheme = lastBaseQuery.getScheme();
        if ("slot".equals(lastScheme) && "".equals(lastBaseQuery.getBody())) {
            if (slotSchemeIndex == 0) {
                return true;
            }
            if (slotSchemeIndex > 0) {
                lastScheme = qList[slotSchemeIndex - 1].getScheme();
            }
        }
        return BHierarchyScheme.INSTANCE.getId().equals(lastScheme);
    }

    private OrdTarget resolveFox(BFoxSession session, OrdTarget base, OrdQuery query) throws Exception {
        if (Sys.isStation() && !BAnalyticService.getInstance().isSteady()) {
            return base;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(query.toString());
        TreeMap<String, String> map = new TreeMap<String, String>();
        BString hierarchyQuery = (BString)base.getFacet("hierarchyQuery");
        if (hierarchyQuery != null) {
            map.put("node", hierarchyQuery.toString(null));
        } else {
            BObject baseObject = base.get();
            if (baseObject instanceof BINavNode) {
                BOrd baseOrd = Utils.getNodeOrd(baseObject);
                map.put("node", baseOrd.relativizeToSession().toString(null));
            } else {
                map.put("node", base.getOrd().relativizeToSession().toString(null));
            }
        }
        map.put("timeZone", TimeZone.getDefault().getID());
        map.put("remoteFox", "true");
        buf.append('&').append(Strings.encodeQueryString(map));
        BOrd ord = BOrd.make((String)buf.toString());
        BFoxClientConnection conn = session.getConnection();
        BDataChannel channel = (BDataChannel)conn.getChannels().get("data");
        BObject res = channel.resolve(ord, new String[0]);
        BFacets facets = BFacets.NULL;
        if (!(res instanceof BITable)) {
            BBlob blob = (BBlob)BBlob.DEFAULT.decodeFromString(res.toString(null));
            ByteArrayInputStream bin = new ByteArrayInputStream(blob.copyBytes());
            GZIPInputStream zin = new GZIPInputStream(bin);
            ValueDocDecoder vd = new ValueDocDecoder((InputStream)zin);
            res = vd.decodeDocument(true);
            facets = (BFacets)res.asComponent().get("facets");
            res = res.asComponent().get("value");
        }
        return new AnalyticTarget(base, res, facets);
    }

    private BISession toSession(OrdTarget baseTarget) {
        if (baseTarget == null) {
            throw new InvalidOrdBaseException("null");
        }
        BISession session = null;
        for (OrdTarget target = baseTarget; target != null && (session = BOrd.toSession((BObject)target.get())) == null; target = target.getBaseOrdTarget()) {
        }
        if (session != null) {
            return session;
        }
        throw new InvalidOrdBaseException("" + baseTarget.get());
    }
}

