/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.data;

import com.tridiumx.analytics.data.AbstractAnalyticValue;
import com.tridiumx.analytics.data.AnalyticDataPolicy;
import com.tridiumx.analytics.data.BooleanValue;
import com.tridiumx.analytics.data.EnumValue;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.data.ObjectValue;
import com.tridiumx.analytics.naming.BAnalyticTrendFlagValue;
import com.tridiumx.analytics.util.Utils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.baja.history.BEnumTrendRecord;
import javax.baja.history.BHistoryRecord;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.util.BTypeSpec;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticBoolean;
import javax.bajax.analytics.data.AnalyticEnum;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticValue;

public class Values
implements AnalyticConstants {
    public static final int INVALID_FLAGS = 87;

    public static boolean getBoolean(Object input) {
        if (input instanceof AnalyticValue) {
            input = ((AnalyticValue)input).toBoolean();
        }
        if (input instanceof BIBoolean) {
            return ((BIBoolean)input).getBoolean();
        }
        if (input instanceof Boolean) {
            return (Boolean)input;
        }
        if (input instanceof BINumeric) {
            return !Utils.isEqualTo(((BINumeric)input).getNumeric(), 0.0);
        }
        if (input instanceof Number) {
            return ((Number)input).intValue() != 0;
        }
        if (input instanceof BIEnum) {
            return ((BIEnum)input).getEnum().getOrdinal() != 0;
        }
        if (input instanceof Enum) {
            return ((Enum)input).ordinal() != 0;
        }
        String str = input instanceof BObject ? ((BObject)input).toString(null) : input.toString();
        return Utils.STATUS_LIST.contains(str);
    }

    public static int getEnum(Object input) {
        if (input instanceof BIEnum) {
            return ((BIEnum)input).getEnum().getOrdinal();
        }
        if (input instanceof Enum) {
            return ((Enum)input).ordinal();
        }
        if (input instanceof BEnumTrendRecord) {
            return ((BEnumTrendRecord)input).getValue().getOrdinal();
        }
        if (input instanceof BObject && BTypeSpec.make((String)"bacnet", (String)"BacnetEnumTrendRecord").equals((Object)((BObject)input).getType().getTypeSpec())) {
            for (Method m : input.getClass().getDeclaredMethods()) {
                if (m.getName() != "getValue") continue;
                try {
                    return ((BDynamicEnum)m.invoke(input, (Object[])null)).getOrdinal();
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        return (int)Values.getNumeric(input);
    }

    public static double getNumeric(Object val) {
        if (val instanceof BINumeric) {
            return ((BINumeric)val).getNumeric();
        }
        if (val instanceof BAbsTime) {
            return ((BAbsTime)val).getMillis();
        }
        if (val instanceof BRelTime) {
            return ((BRelTime)val).getMillis();
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        if (val instanceof BIBoolean) {
            if (((BIBoolean)val).getBoolean()) {
                return 1.0;
            }
            return 0.0;
        }
        if (val instanceof BIEnum) {
            return ((BIEnum)val).getEnum().getOrdinal();
        }
        if (val instanceof Enum) {
            return ((Enum)val).ordinal();
        }
        if (val instanceof AnalyticValue) {
            val = ((AnalyticValue)val).toNumeric();
        }
        try {
            if (val instanceof BObject) {
                return Double.parseDouble(((BObject)val).toString(null));
            }
            return Double.parseDouble(val.toString());
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public static BSimple getSimple(AnalyticValue val) {
        switch (val.getValueType()) {
            case 0: {
                return BBoolean.make((boolean)val.toBoolean());
            }
            case 1: {
                return BDynamicEnum.make((int)val.toEnum());
            }
            case 2: {
                return BDouble.make((double)val.toNumeric());
            }
        }
        return BString.make((String)val.toString());
    }

    public static String getString(Object val) {
        return Values.getString(val, null);
    }

    public static String getString(Object val, Context context) {
        if (val instanceof BString) {
            return ((BString)val).getString();
        }
        if (val instanceof BObject) {
            return ((BObject)val).toString(context);
        }
        return val.toString();
    }

    public static BStatus getStatus(Object o) {
        if (o instanceof BStatus) {
            return (BStatus)o;
        }
        if (o instanceof BIStatus) {
            return ((BIStatus)o).getStatus();
        }
        if (o instanceof AnalyticValue) {
            return BStatus.make((int)((AnalyticValue)o).getStatus());
        }
        return BStatus.ok;
    }

    public static int getStatusBits(Object sts) {
        if (sts instanceof AnalyticValue) {
            return ((AnalyticValue)sts).getStatus();
        }
        return Values.getStatus(sts).getBits();
    }

    public static BStatusValue getStatusValue(AnalyticValue val) {
        BStatus status = Values.getStatus(val);
        switch (val.getValueType()) {
            case 0: {
                return new BStatusBoolean(val.toBoolean(), status);
            }
            case 1: {
                return new BStatusEnum((BEnum)BDynamicEnum.make((int)val.toEnum()), status);
            }
            case 2: {
                return new BStatusNumeric(val.toNumeric(), status);
            }
        }
        return new BStatusString(val.toString(), status);
    }

    public static BAnalyticTrendFlagValue getAdvancedStatusValue(AnalyticValue val) {
        BStatusValue statusValue = Values.getStatusValue(val);
        BAnalyticTrendFlagValue trendFlagValue = BAnalyticTrendFlagValue.getInstance(statusValue);
        trendFlagValue.setTrendFlags(((AbstractAnalyticValue)val).getTrendFlags());
        return trendFlagValue;
    }

    public static boolean isAlarm(int bits) {
        return (bits & 8) != 0;
    }

    public static boolean isBoolean(Object val) {
        if (val instanceof BIBoolean) {
            return true;
        }
        if (val instanceof Boolean) {
            return true;
        }
        return val instanceof AnalyticBoolean;
    }

    public static boolean isDisabled(int bits) {
        return (bits & 1) != 0;
    }

    public static boolean isDown(int bits) {
        return (bits & 4) != 0;
    }

    public static boolean isFault(int bits) {
        return (bits & 2) != 0;
    }

    public static boolean isEnum(Object input) {
        if (input instanceof BIEnum) {
            return true;
        }
        if (input instanceof Enum) {
            return true;
        }
        if (input instanceof BEnumTrendRecord) {
            return true;
        }
        if (input instanceof BObject && BTypeSpec.make((String)"bacnet", (String)"BacnetEnumTrendRecord").equals((Object)((BObject)input).getType().getTypeSpec())) {
            return true;
        }
        return input instanceof AnalyticEnum;
    }

    public static boolean isNumeric(Object val) {
        if (val instanceof BINumeric) {
            return true;
        }
        if (val instanceof BRelTime) {
            return true;
        }
        if (val instanceof BAbsTime) {
            return true;
        }
        if (val instanceof Number) {
            return true;
        }
        return val instanceof AnalyticNumeric;
    }

    public static boolean isNull(int bits) {
        return (bits & 0x40) != 0;
    }

    public static boolean isOk(int bits) {
        return bits == 0;
    }

    public static boolean isOverridden(int bits) {
        return (bits & 0x20) != 0;
    }

    public static boolean isStale(int bits) {
        return (bits & 0x10) != 0;
    }

    public static boolean isUnackedAlarm(int bits) {
        return (bits & 0x80) != 0;
    }

    public static boolean isValid(int bits) {
        if (bits == 0) {
            return true;
        }
        return (bits & 0x57) == 0;
    }

    public static boolean isValid(int bits, int invalidFlags) {
        if (invalidFlags == 0) {
            return true;
        }
        if (invalidFlags == 255) {
            return bits == 0;
        }
        return (bits & invalidFlags) == 0;
    }

    public static boolean isValidRange(double rowValue, boolean highLimitUnspecified, boolean lowLimitUnspecified, double highLimitValue, double lowLimitValue) {
        if (!highLimitUnspecified && !lowLimitUnspecified) {
            return rowValue <= highLimitValue && rowValue >= lowLimitValue;
        }
        if (highLimitUnspecified) {
            return rowValue >= lowLimitValue;
        }
        if (lowLimitUnspecified) {
            return rowValue <= highLimitValue;
        }
        return true;
    }

    public static boolean isValidValue(double rowValue, int valueBits) {
        if (valueBits == 1) {
            return Double.isFinite(rowValue);
        }
        return false;
    }

    public static AnalyticValue make(AnalyticContext arg) {
        if (arg == null) {
            return Values.makeString();
        }
        return Values.make(arg.getDataPolicy());
    }

    public static AnalyticValue make(AnalyticDataPolicy arg) {
        if (arg == null) {
            return Values.makeString();
        }
        BFacets f = arg.getFacets();
        if (f.get("trueText") != null) {
            return Values.makeBoolean();
        }
        if (f.get("falseText") != null) {
            return Values.makeBoolean();
        }
        if (f.get("range") != null) {
            return Values.makeEnum();
        }
        if (f.get("units") != null) {
            return Values.makeNumeric();
        }
        if (f.get("precision") != null) {
            return Values.makeNumeric();
        }
        if (f.get("max") != null) {
            return Values.makeNumeric();
        }
        if (f.get("min") != null) {
            return Values.makeNumeric();
        }
        return Values.makeString();
    }

    public static AnalyticValue make(Object obj) {
        if (obj == null) {
            return Values.makeString();
        }
        long ts = 0L;
        int sts = 0;
        if (obj instanceof BIStatus) {
            sts = ((BIStatus)obj).getStatus().getBits();
        }
        ts = obj instanceof BHistoryRecord ? ((BHistoryRecord)obj).getTimestamp().getMillis() : System.currentTimeMillis();
        if (Values.isNumeric(obj)) {
            return Values.makeNumeric().setValue(obj).setTimestamp(ts).setStatus(sts);
        }
        if (Values.isBoolean(obj)) {
            return Values.makeBoolean().setValue(obj).setTimestamp(ts).setStatus(sts);
        }
        if (obj instanceof AnalyticContext) {
            return Values.make((AnalyticContext)obj);
        }
        if (obj instanceof AnalyticDataPolicy) {
            return Values.make((AnalyticDataPolicy)obj);
        }
        if (Values.isEnum(obj)) {
            return Values.makeEnum().setValue(obj).setTimestamp(ts).setStatus(sts);
        }
        return Values.makeString().setValue(obj).setTimestamp(ts).setStatus(sts);
    }

    public static AnalyticBoolean makeBoolean() {
        return new BooleanValue();
    }

    public static AnalyticBoolean makeBoolean(boolean val) {
        return new BooleanValue(val);
    }

    public static AnalyticEnum makeEnum() {
        return new EnumValue();
    }

    public static AnalyticEnum makeEnum(int val) {
        return new EnumValue(val);
    }

    public static AnalyticNumeric makeNumeric() {
        return new NumericValue();
    }

    public static AnalyticNumeric makeNumeric(double val) {
        return new NumericValue(val);
    }

    public static AnalyticValue makeString() {
        return new ObjectValue();
    }

    public static AnalyticValue makeString(Object val) {
        return new ObjectValue(val);
    }

    public static String toString(int sts) {
        if (Values.isDisabled(sts)) {
            return "disabled";
        }
        if (Values.isFault(sts)) {
            return "fault";
        }
        if (Values.isDown(sts)) {
            return "down";
        }
        if (Values.isAlarm(sts)) {
            return "alarm";
        }
        if (Values.isStale(sts)) {
            return "stale";
        }
        if (Values.isOverridden(sts)) {
            return "overridden";
        }
        if (Values.isNull(sts)) {
            return "null";
        }
        if (Values.isUnackedAlarm(sts)) {
            return "unackedAlarm";
        }
        return "ok";
    }
}

