/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.combine;

import com.tridiumx.analytics.combine.AbstractCombiner;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.history.BInterpolationTrendFlags;
import com.tridiumx.analytics.util.Utils;
import javax.bajax.analytics.data.AnalyticValue;

public class LoadFactorCombiner
extends AbstractCombiner {
    private NumericValue analytic = new NumericValue();
    private double totalValue;
    private double maxValue;

    public LoadFactorCombiner() {
        this(13);
    }

    public LoadFactorCombiner(int type) {
        super(type);
        this.reset();
    }

    @Override
    public AnalyticValue getValue() {
        double avg = 0.0;
        int count = this.getCount();
        if (count != 0) {
            avg = this.totalValue / (double)count;
        }
        if (!Utils.isEqualTo(this.maxValue, 0.0)) {
            this.analytic.setValue(avg / this.maxValue);
        }
        return this.analytic;
    }

    @Override
    protected void doReset() {
        this.maxValue = 0.0;
        this.totalValue = 0.0;
        this.analytic.set(0L, 0.0, 64, BInterpolationTrendFlags.DEFAULT);
    }

    @Override
    protected boolean doUpdate(AnalyticValue arg) {
        if (this.getCount() == 0) {
            this.totalValue = this.maxValue = arg.toNumeric();
            this.analytic.setTimestamp(arg.getTimestamp());
            this.analytic.setStatus(arg.getStatus());
        } else {
            this.totalValue += arg.toNumeric();
            if (arg.toNumeric() > this.maxValue) {
                this.maxValue = arg.toNumeric();
            }
            this.analytic.setTimestamp(arg.getTimestamp());
            this.analytic.orStatus(arg);
        }
        this.analytic.orTrendFlags(arg);
        return true;
    }
}

