/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.data.Values;
import com.tridiumx.analytics.util.Utils;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.time.BAnalyticTimeRange;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="trendIn", type="BBlockPin", defaultValue="new BBlockPin()", flags=8), @NiagaraProperty(name="mode", type="BEnum", defaultValue="BDynamicEnum.make((int)MILLIS_MINUTE)", flags=8, facets={@Facet(value="BFacets.makeEnum(MODE)")}), @NiagaraProperty(name="searchLimit", type="BRelTime", defaultValue="BRelTime.HOUR", flags=8), @NiagaraProperty(name="makesTrends", type="boolean", defaultValue="false", flags=8)})
public class BValueDurationBlock
extends BOutputBlock
implements AnalyticConstants {
    public static final BEnumRange MODE = BEnumRange.make((int[])new int[]{1, 1000, 60000, 3600000}, (String[])new String[]{Utils.lex("millis"), Utils.lex("seconds"), Utils.lex("minutes"), Utils.lex("hours")});
    @Generated
    public static final Property trendIn = BValueDurationBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Property mode = BValueDurationBlock.newProperty((int)8, (BValue)BDynamicEnum.make((int)60000), (BFacets)BFacets.makeEnum((BEnumRange)MODE));
    @Generated
    public static final Property searchLimit = BValueDurationBlock.newProperty((int)8, (BValue)BRelTime.HOUR, null);
    @Generated
    public static final Property makesTrends = BValueDurationBlock.newProperty((int)8, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BValueDurationBlock.class);

    @Generated
    public BBlockPin getTrendIn() {
        return (BBlockPin)this.get(trendIn);
    }

    @Generated
    public void setTrendIn(BBlockPin v) {
        this.set(trendIn, (BValue)v, null);
    }

    @Generated
    public BEnum getMode() {
        return (BEnum)this.get(mode);
    }

    @Generated
    public void setMode(BEnum v) {
        this.set(mode, (BValue)v, null);
    }

    @Generated
    public BRelTime getSearchLimit() {
        return (BRelTime)this.get(searchLimit);
    }

    @Generated
    public void setSearchLimit(BRelTime v) {
        this.set(searchLimit, (BValue)v, null);
    }

    @Generated
    public boolean getMakesTrends() {
        return this.getBoolean(makesTrends);
    }

    @Generated
    public void setMakesTrends(boolean v) {
        this.setBoolean(makesTrends, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        AnalyticValue current = this.getInput(0).getValue(cx);
        try (AnalyticTrend trend = this.getInput(0).getTrend(this.prepareContext(cx));){
            cx = trend.getContext();
            long end = cx.getEndTime();
            long lastTs = cx.getStartTime();
            boolean wasEqual = false;
            while (trend.hasNext()) {
                AnalyticValue row = trend.next();
                if (end > 0L && row.getTimestamp() > end) break;
                boolean areEqual = row.statusValueEquals(current);
                if (areEqual) {
                    if (!wasEqual) {
                        lastTs = row.getTimestamp();
                    }
                } else {
                    lastTs = row.getTimestamp();
                }
                wasEqual = areEqual;
                if (row.getTimestamp() != end) continue;
            }
            double res = end - lastTs;
            res /= (double)this.getMode().getOrdinal();
            if (current instanceof AnalyticNumeric) {
                AnalyticNumeric ret = (AnalyticNumeric)current;
                ret.setValue(res);
                AnalyticNumeric analyticNumeric = ret;
                return analyticNumeric;
            }
            AnalyticValue analyticValue = Values.makeNumeric(res).setTimestamp(current.getTimestamp()).setStatus(current.getStatus());
            return analyticValue;
        }
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        if (!this.getMakesTrends()) {
            return false;
        }
        return super.hasTrend(cx);
    }

    private AnalyticContext prepareContext(AnalyticContext cx) {
        AnalyticContextWrapper w = new AnalyticContextWrapper(cx);
        BAbsTime now = Clock.time();
        BAbsTime start = now.subtract(this.getSearchLimit());
        w.setTimeRange(BAnalyticTimeRange.make(start, now));
        return w;
    }

    private static class MyTrend
    extends BlockTrend {
        AnalyticNumeric cache = null;
        AnalyticValue current = null;
        double mode;

        public MyTrend(BValueDurationBlock block, AnalyticContext cx) {
            super(block, cx);
            this.mode = block.getMode().getOrdinal();
        }

        @Override
        protected AnalyticValue getNext() {
            if (!this.advance()) {
                return null;
            }
            if (this.current == null) {
                this.current = this.getValue(0).newCopy();
                this.cache = Values.makeNumeric(0.0);
                this.cache.setStatus(this.current.getStatus());
                this.cache.setTimestamp(this.current.getTimestamp());
                return this.cache;
            }
            if (!this.current.statusValueEquals(this.getValue(0))) {
                this.current = this.getValue(0).newCopy();
                this.cache.setValue(0.0);
                this.cache.setStatus(this.current.getStatus());
                this.cache.setTimestamp(this.current.getTimestamp());
                return this.cache;
            }
            long ts = this.getValue(0).getTimestamp();
            this.cache.setTimestamp(ts);
            double res = ts - this.current.getTimestamp();
            this.cache.setValue(res /= this.mode);
            return this.cache;
        }
    }
}

