/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.trend.AbstractTrend;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.time.Interval;

@NiagaraType
@NiagaraProperty(name="makesTrends", type="boolean", defaultValue="false", flags=8)
public class BIntervalCountBlock
extends BOutputBlock {
    @Generated
    public static final Property makesTrends = BIntervalCountBlock.newProperty((int)8, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BIntervalCountBlock.class);

    @Generated
    public boolean getMakesTrends() {
        return this.getBoolean(makesTrends);
    }

    @Generated
    public void setMakesTrends(boolean v) {
        this.setBoolean(makesTrends, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        Interval ivl = cx.getInterval(true);
        return AnalyticValue.makeNumeric().setValue(ivl.count(cx.getStartTime(), cx.getEndTime()));
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(cx);
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        return this.getMakesTrends();
    }

    private static class MyTrend
    extends AbstractTrend {
        private NumericValue cache = new NumericValue();
        private Interval interval;
        private int count = 0;
        private long ts;

        MyTrend(AnalyticContext cx) {
            super(cx);
            this.interval = cx.getInterval(true);
            this.ts = cx.getStartTime();
            this.count = this.interval.count(this.ts, cx.getEndTime());
        }

        @Override
        protected AnalyticValue getNext() {
            this.cache.setTimestamp(this.ts).setValue(this.count).setStatus(0);
            this.ts = this.interval.next(this.ts);
            return this.cache;
        }
    }
}

