/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.data.Values;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.bajax.analytics.AnalyticConstants;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.algorithm.BBlockPin;
import javax.bajax.analytics.algorithm.BOutputBlock;
import javax.bajax.analytics.algorithm.BlockTrend;
import javax.bajax.analytics.data.AnalyticNumeric;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.time.BAnalyticTimeRange;

@NiagaraType
@NiagaraProperty(name="trendIn", type="BBlockPin", defaultValue="new BBlockPin()", flags=8)
public class BConsumptionToDemandBlock
extends BOutputBlock
implements AnalyticConstants {
    @Generated
    public static final Property trendIn = BConsumptionToDemandBlock.newProperty((int)8, (BValue)new BBlockPin(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BConsumptionToDemandBlock.class);

    @Generated
    public BBlockPin getTrendIn() {
        return (BBlockPin)this.get(trendIn);
    }

    @Generated
    public void setTrendIn(BBlockPin v) {
        this.set(trendIn, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        AnalyticValue current = this.getInput(0).getValue(cx);
        cx = new AnalyticContextWrapper(cx);
        BAbsTime now = Clock.time();
        BAbsTime start = now.subtract(BRelTime.HOUR);
        cx.setTimeRange(BAnalyticTimeRange.make(start, now));
        try (AnalyticTrend trend = this.getInput(0).getTrend(cx);){
            long end = cx.getEndTime();
            AnalyticValue last = null;
            AnalyticValue row = null;
            double currentValue = current.toNumeric();
            while (trend.hasNext() && (row = trend.next()).getTimestamp() <= end) {
                if (last == null) {
                    last = row;
                    continue;
                }
                if (!row.isValid()) continue;
                last = row;
            }
            if (last == null) {
                AnalyticValue analyticValue = current.setStatus(64);
                return analyticValue;
            }
            long time = current.getTimestamp() - last.getTimestamp();
            if (time <= 0L) {
                AnalyticValue analyticValue = current.setStatus(64);
                return analyticValue;
            }
            if (trend.isTotalize() && !cx.getHisTotEnabled()) {
                currentValue -= last.toNumeric();
            }
            double val = currentValue * (3600000.0 / (double)time);
            if (current instanceof AnalyticNumeric) {
                AnalyticNumeric ret = (AnalyticNumeric)current;
                ret.setValue(val);
                AnalyticNumeric analyticNumeric = ret;
                return analyticNumeric;
            }
            AnalyticValue analyticValue = Values.makeNumeric(val).setTimestamp(current.getTimestamp()).setStatus(current.getStatus());
            return analyticValue;
        }
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        return new MyTrend(this, cx);
    }

    private static class MyTrend
    extends BlockTrend {
        AnalyticNumeric cache = null;
        AnalyticValue last = null;

        public MyTrend(BConsumptionToDemandBlock block, AnalyticContext cx) {
            super(block, cx);
        }

        @Override
        protected AnalyticValue getNext() {
            while (this.advance()) {
                AnalyticValue row = this.getValue(0);
                if (this.last == null) {
                    this.last = row.newCopy();
                    this.cache = AnalyticValue.makeNumeric();
                    continue;
                }
                long time = row.getTimestamp() - this.last.getTimestamp();
                if (time <= 0L) continue;
                double val = row.toNumeric() * (3600000.0 / (double)time);
                this.cache.setValue(val).setTimestamp(this.last.getTimestamp()).setStatus(this.last.getStatus());
                this.last.copyTimestamp(row).copyStatus(row);
                return this.cache;
            }
            return null;
        }
    }
}

