/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.analytics.algorithm;

import com.tridium.util.PxUtil;
import com.tridiumx.analytics.AnalyticContextWrapper;
import com.tridiumx.analytics.BAnalyticService;
import com.tridiumx.analytics.algorithm.Algorithm;
import com.tridiumx.analytics.algorithm.BAlgorithmFolder;
import com.tridiumx.analytics.algorithm.BResultBlock;
import com.tridiumx.analytics.data.AnalyticDataPolicy;
import com.tridiumx.analytics.data.NumericValue;
import com.tridiumx.analytics.trend.EmptyTrend;
import com.tridiumx.analytics.util.BConfigurableObject;
import com.tridiumx.analytics.util.Utils;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicReference;
import javax.baja.agent.AgentList;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.bajax.analytics.AnalyticContext;
import javax.bajax.analytics.data.AnalyticTrend;
import javax.bajax.analytics.data.AnalyticValue;
import javax.bajax.analytics.data.BCombination;
import javax.bajax.analytics.time.BInterval;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="result", type="BResultBlock", defaultValue="new BResultBlock()"), @NiagaraProperty(name="facets", type="BFacets", defaultValue="BFacets.NULL"), @NiagaraProperty(name="makesTrends", type="boolean", defaultValue="true"), @NiagaraProperty(name="aggregation", type="BCombination", defaultValue="BCombination.first"), @NiagaraProperty(name="rollup", type="BCombination", defaultValue="BCombination.first"), @NiagaraProperty(name="minInterval", type="BInterval", defaultValue="BInterval.none"), @NiagaraProperty(name="maxInterval", type="BInterval", defaultValue="BInterval.none")})
public class BAlgorithm
extends BConfigurableObject
implements Algorithm,
AnalyticDataPolicy {
    @Generated
    public static final Property result = BAlgorithm.newProperty((int)0, (BValue)new BResultBlock(), null);
    @Generated
    public static final Property facets = BAlgorithm.newProperty((int)0, (BValue)BFacets.NULL, null);
    @Generated
    public static final Property makesTrends = BAlgorithm.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property aggregation = BAlgorithm.newProperty((int)0, (BValue)BCombination.first, null);
    @Generated
    public static final Property rollup = BAlgorithm.newProperty((int)0, (BValue)BCombination.first, null);
    @Generated
    public static final Property minInterval = BAlgorithm.newProperty((int)0, (BValue)BInterval.none, null);
    @Generated
    public static final Property maxInterval = BAlgorithm.newProperty((int)0, (BValue)BInterval.none, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAlgorithm.class);
    private volatile AtomicReference<Id> refId = new AtomicReference();
    private ThreadLocal<HashSet<BINavNode>> preventLoops = new ThreadLocal();
    private volatile Id registeredId;

    @Generated
    public BResultBlock getResult() {
        return (BResultBlock)this.get(result);
    }

    @Generated
    public void setResult(BResultBlock v) {
        this.set(result, (BValue)v, null);
    }

    @Override
    @Generated
    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    @Generated
    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    @Generated
    public boolean getMakesTrends() {
        return this.getBoolean(makesTrends);
    }

    @Generated
    public void setMakesTrends(boolean v) {
        this.setBoolean(makesTrends, v, null);
    }

    @Generated
    public BCombination getAggregation() {
        return (BCombination)this.get(aggregation);
    }

    @Generated
    public void setAggregation(BCombination v) {
        this.set(aggregation, (BValue)v, null);
    }

    @Generated
    public BCombination getRollup() {
        return (BCombination)this.get(rollup);
    }

    @Generated
    public void setRollup(BCombination v) {
        this.set(rollup, (BValue)v, null);
    }

    @Generated
    public BInterval getMinInterval() {
        return (BInterval)this.get(minInterval);
    }

    @Generated
    public void setMinInterval(BInterval v) {
        this.set(minInterval, (BValue)v, null);
    }

    @Generated
    public BInterval getMaxInterval() {
        return (BInterval)this.get(maxInterval);
    }

    @Generated
    public void setMaxInterval(BInterval v) {
        this.set(maxInterval, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("wiresheet:WebWiresheet");
        list.toTop("wiresheet:WireSheet");
        return PxUtil.movePxViewsToTop((AgentList)list);
    }

    @Override
    public Id getDataId() {
        this.refId.compareAndSet(null, Id.newId((String)"alg", (String)this.getName()));
        return this.refId.get();
    }

    @Override
    public BCombination getDefaultAggregation() {
        return this.getAggregation();
    }

    @Override
    public BCombination getDefaultRollup() {
        return this.getRollup();
    }

    public BIcon getIcon() {
        return Utils.iconAlgorithm;
    }

    @Override
    public AnalyticTrend getTrend(AnalyticContext cx) {
        if (!(BAnalyticService.getInstance().isSteady() && this.getMakesTrends() && this.getEnabled())) {
            return new EmptyTrend(cx);
        }
        if (this.getMinInterval() != BInterval.none && cx.getInterval(true).getOrdinal() < this.getMinInterval().getOrdinal()) {
            cx = new AnalyticContextWrapper(cx);
            cx.setInterval(this.getMinInterval());
        } else if (this.getMaxInterval() != BInterval.none && cx.getInterval(true).getOrdinal() > this.getMaxInterval().getOrdinal()) {
            cx = new AnalyticContextWrapper(cx);
            cx.setInterval(this.getMaxInterval());
        }
        return this.getResult().getTrend(cx);
    }

    @Override
    public AnalyticValue getValue(AnalyticContext cx) {
        if (!BAnalyticService.getInstance().isSteady() || !this.getEnabled()) {
            return new NumericValue(0.0, 64);
        }
        if (this.getMinInterval() != BInterval.none && cx.getInterval(true).getOrdinal() < this.getMinInterval().getOrdinal()) {
            cx = new AnalyticContextWrapper(cx);
            cx.setInterval(this.getMinInterval());
        } else if (this.getMaxInterval() != BInterval.none && cx.getInterval(true).getOrdinal() > this.getMaxInterval().getOrdinal()) {
            cx = new AnalyticContextWrapper(cx);
            cx.setInterval(this.getMaxInterval());
        }
        return this.getResult().getValue(cx);
    }

    @Override
    public boolean hasTrend(AnalyticContext cx) {
        if (!this.getEnabled()) {
            return false;
        }
        if (!this.getMakesTrends()) {
            return false;
        }
        return this.getResult().hasTrend(cx);
    }

    public boolean isParentLegal(BComponent parent) {
        if (!this.isRunning()) {
            return true;
        }
        return parent instanceof BAlgorithmFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAvailable(BINavNode node) {
        if (!this.getEnabled()) {
            return false;
        }
        if (this.preventLoops.get() == null) {
            this.preventLoops.set(new HashSet());
        } else if (this.preventLoops.get().contains(node)) {
            return false;
        }
        HashSet<BINavNode> noloops = this.preventLoops.get();
        try {
            noloops.add(node);
            boolean bl = this.getResult().isAvailable(node);
            return bl;
        }
        finally {
            noloops.remove(node);
            if (noloops.size() == 0) {
                this.preventLoops.set(null);
            }
        }
    }

    public void started() throws Exception {
        this.updateConfig();
        if (Sys.atSteadyState()) {
            this.atSteadyState();
        }
        super.started();
    }

    public void stopped() throws Exception {
        BAnalyticService svc = BAnalyticService.getInstance();
        if (svc != null && this.registeredId != null) {
            svc.unregisterAlgorithm(this.registeredId, this);
        }
        this.registeredId = null;
        super.stopped();
    }

    @Override
    protected void configOk() {
        if (!this.getStatus().isOk()) {
            this.setStatus(BStatus.ok);
        }
        if (this.getFaultCause().length() > 0) {
            this.setFaultCause("");
        }
    }

    protected void configFail(String reason) {
        if (this.getStatus().isOk()) {
            this.setStatus(BStatus.fault);
        }
        if (!this.getFaultCause().equals(reason)) {
            Utils.log().severe(() -> this.toPathString() + ": " + reason);
            this.setFaultCause(reason);
        }
    }

    @Override
    protected synchronized void updateConfig() {
        Id tmp;
        BAnalyticService svc = BAnalyticService.getInstance();
        if (this.registeredId != null) {
            svc.unregisterAlgorithm(this.registeredId, this);
            this.refId.set(null);
            this.registeredId = null;
        }
        if (!svc.registerAlgorithm(tmp = this.getDataId(), this)) {
            this.configFail(Utils.lex("duplicateDataId"));
            return;
        }
        this.registeredId = tmp;
        this.configOk();
    }
}

