/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetMigrator;

import com.tridium.bacnetAws.ui.device.BBacnetAwsDeviceManager;
import com.tridium.migrator.MigrationUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import javax.baja.migration.BIPxElementConverter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
public class BBacnetWsToAwsPxConverter
extends BObject
implements BIPxElementConverter {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetWsToAwsPxConverter.class);
    private static final List<String> convertTypeSpec = Collections.singletonList("bacnetws:BacnetWsDeviceManager");
    private static final Map<String, String> newTypeMap;
    private static final Map<String, String> moduleMap;
    private static final Map<String, String> newTypeModuleMap;
    private static final int MODULE_NDX = 0;
    private static final int TYPE_NDX = 1;
    private static final String MODULE_BACNETWS = "bacnetws";
    private static final String MODULE_DEF_AWS = "bacAws=bacnetAws";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypeSpecs() {
        return convertTypeSpec;
    }

    public XElem convertXElem(XElem pxElem, String typespecName, Version sourceVersion) {
        String[] moduleAndType = typespecName.split(":");
        String moduleStr = moduleAndType[0];
        String typeStr = moduleAndType[1];
        if (MODULE_BACNETWS.equals(moduleStr) && "BacnetWsDeviceManager".equals(typeStr)) {
            this.migrateType(pxElem, MODULE_DEF_AWS, "bacAws:BacnetAwsDeviceManager");
        }
        return pxElem;
    }

    public BValue newInstance(String moduleName, String typeName) {
        BValue inst = null;
        if (MODULE_BACNETWS.equals(moduleName)) {
            if ("BacnetWsDeviceManager".equals(typeName)) {
                inst = BBacnetAwsDeviceManager.TYPE.getInstance().asValue();
            } else {
                log.config("BacnetWsToAwsConverter:couldn't match typeName '" + typeName + "'");
            }
        } else {
            log.config("BacnetWsToAwsConverter:couldn't match moduleName '" + moduleName + "'");
        }
        return inst;
    }

    public Optional<String> newTypeName(String typeName) {
        return Optional.ofNullable(newTypeMap.get(typeName));
    }

    public Optional<String> newModule(String moduleName) {
        return Optional.ofNullable(moduleMap.get(moduleName));
    }

    public Optional<String> newTypeSpec(String typeName) {
        String newTypeName = newTypeMap.get(typeName);
        if (newTypeName != null) {
            return Optional.of(newTypeModuleMap.get(newTypeName) + ":" + newTypeName);
        }
        return Optional.empty();
    }

    private void migrateType(XElem elem, String moduleStr, String typeStr) {
        MigrationUtils.logInfoByModule((String)"bacnetMigrator", (String)"wsToAws.convert", (Object[])new Object[]{elem.get("n", "unnamedObject"), elem.get("t", "unknown"), moduleStr, typeStr});
        if (log.isLoggable(Level.FINER)) {
            log.finer("Migrating " + elem.get("n", "unnamedObject") + " of type " + elem.get("t", "unknown") + " to " + moduleStr + ":" + typeStr);
        }
        elem.setAttr("m", moduleStr);
        elem.setAttr("t", typeStr);
    }

    public String toString(Context c) {
        return "BacnetWsToAwsConverter";
    }

    static {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        typeMap.put("BacnetWsDeviceManager", "BacnetAwsDeviceManager");
        newTypeMap = Collections.unmodifiableMap(typeMap);
        typeMap = new HashMap();
        typeMap.put(MODULE_BACNETWS, "bacnetAws");
        moduleMap = Collections.unmodifiableMap(typeMap);
        HashMap<String, String> typeModuleMap = new HashMap<String, String>();
        typeModuleMap.put("BacnetAwsDeviceManager", "bacnetAws");
        newTypeModuleMap = Collections.unmodifiableMap(typeModuleMap);
    }
}

