/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetMigrator;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;
import javax.baja.xml.XElem;

@NiagaraType
public class BBacnetLinkLayerConverter
extends BObject
implements BIBogElementConverter {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetLinkLayerConverter.class);
    private static final List<String> convertTypes = new ArrayList<String>();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public List<String> getConvertTypes() {
        return convertTypes;
    }

    public XElem convertXElem(XElem x, String typeSpecName, Version sourceVersion) throws Exception {
        String[] moduleAndType = typeSpecName.split(":");
        if (moduleAndType[1].equals("BacnetIpLinkLayer")) {
            XElem[] elems;
            for (XElem xlm : elems = x.elems("p")) {
                if (!xlm.get("n", "").equals("adapterId")) continue;
                String adapterIdValue = xlm.get("v", "-1@{none=-1}");
                if (adapterIdValue.contains(",en0") || adapterIdValue.contains(",eth0")) {
                    log.info("BacnetLinkLayerConverter (IP): Found en0/eth0 in adapterId; leaving BACnet/IP adapter settings alone.");
                    return x;
                }
                log.warning("BacnetLinkLayerConverter (IP): Resetting BACnet/IP adapter selection to 'none'.");
                String newAdapterIdValue = "-1" + adapterIdValue.substring(adapterIdValue.indexOf("@"));
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Old Adapter ID value:" + adapterIdValue + "\nNew Adapter ID value:" + newAdapterIdValue);
                }
                xlm.setAttr("v", newAdapterIdValue);
                break;
            }
            for (XElem xlm : elems) {
                String n = xlm.get("n", "");
                if (!n.equals("adapter") && !n.equals("ipAddress")) continue;
                String v = xlm.get("v", "-1@{none=-1}");
                String newV = "-1" + v.substring(v.indexOf("@"));
                xlm.setAttr("v", newV);
                log.info("resetting " + n + " to 'none'");
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Old value:" + v + "\nNew value:" + newV);
            }
        }
        return x;
    }

    static {
        convertTypes.add("bacnet:BacnetIpLinkLayer");
    }
}

