/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.systemDb.orient.queryGeneration;

import com.orientechnologies.orient.core.id.ORID;
import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.systemDb.BSystemDb;
import com.tridium.systemDb.orient.BOrientSystemDb;
import com.tridium.systemDb.orient.OrientSystemDbConnection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.neql.AndExpression;
import javax.baja.neql.AstNode;
import javax.baja.neql.BinaryExpression;
import javax.baja.neql.ContextExpression;
import javax.baja.neql.EqualExpression;
import javax.baja.neql.EvalOnExpression;
import javax.baja.neql.Expression;
import javax.baja.neql.GetRelationExpression;
import javax.baja.neql.GetTagExpression;
import javax.baja.neql.GreaterExpression;
import javax.baja.neql.GreaterOrEqualExpression;
import javax.baja.neql.LessExpression;
import javax.baja.neql.LessOrEqualExpression;
import javax.baja.neql.LikeExpression;
import javax.baja.neql.LiteralExpression;
import javax.baja.neql.LogicalExpression;
import javax.baja.neql.NeqlQuery;
import javax.baja.neql.NotEqualExpression;
import javax.baja.neql.NotExpression;
import javax.baja.neql.OrExpression;
import javax.baja.neql.Select;
import javax.baja.neql.Traverse;
import javax.baja.neql.TraverseInExpression;
import javax.baja.neql.TraverseOutExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BNumber;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;

public class OrientGeneratingVisitor {
    private final ORID scopeId;
    private final Context context;
    private final BObject base;
    private final NeqlQuery query;
    private final String contextNamespace;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private boolean containsEvalOn;
    private String evalOnScope;

    private OrientGeneratingVisitor(ORID scopeId, BObject base, NeqlQuery query, Context context) {
        this.scopeId = scopeId;
        this.query = query;
        this.context = context;
        this.base = base != null ? base : Sys.getStation();
        this.contextNamespace = context != null ? context.getFacets().gets("namespace", null) : null;
    }

    public static OrientGeneratingVisitor makeVisitor(ORID scopeId, BObject base, NeqlQuery query, Context context) {
        Objects.requireNonNull(query, "query must be non-null.");
        return new OrientGeneratingVisitor(scopeId, base, query, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTranslation() throws Exception {
        long start = DiagnosticUtil.startIfLoggable((String)"OrientGeneratingVisitor.getTranslation");
        try {
            int limit;
            String translation;
            AstNode current = this.query.getAst();
            switch (current.getNodeType()) {
                case 16: {
                    translation = this.translateTraverse((Traverse)current);
                    break;
                }
                case 1: {
                    translation = this.translateSelect((Select)current);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("OrientGeneratingVisitor does not support " + current);
                }
            }
            int n = limit = this.context != null ? this.context.getFacets().geti("queryLimit", -1) : -1;
            if (limit > 0 && limit < Integer.MAX_VALUE) {
                translation = translation + " LIMIT " + limit;
            }
            String string = translation;
            return string;
        }
        finally {
            DiagnosticUtil.complete((long)start, (String)"OrientGeneratingVisitor.getTranslation", (Object)this.query);
        }
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    private String translateSelect(Select select) throws ContextMissingException {
        String distinctTag;
        Expression predicateExp = select.getPredicate();
        if (predicateExp == null) {
            throw new IllegalStateException("NEQL select queries must have a predicate.");
        }
        if (predicateExp.getNodeType() == 17 || predicateExp.getNodeType() == 18) {
            throw new UnsupportedOperationException("Unable to translate NEQL query to Orient SQL at this time. (query = " + this.query.toString() + ")");
        }
        String string = distinctTag = this.context != null ? this.context.getFacets().gets("distinctTag", null) : null;
        if (distinctTag != null) {
            distinctTag = OrientSystemDbConnection.escapeToOrientForm(distinctTag);
        }
        this.containsEvalOn = OrientGeneratingVisitor.containsEvalOn(predicateExp);
        if (this.containsEvalOn) {
            String start = distinctTag != null ? "SELECT DISTINCT " + distinctTag + " FROM (" : "SELECT DISTINCT * FROM (";
            if (this.scopeId != null) {
                this.evalOnScope = "$scope";
                String predicate = this.translatePredicate(predicateExp);
                String scope = "(SELECT FROM (TRAVERSE out('scopedEdge') FROM " + this.scopeId + ") WHERE $depth > 0)";
                return start + "SELECT EXPAND(intersect((" + predicate + "), " + this.evalOnScope + ")) LET " + this.evalOnScope + " = " + scope + ')';
            }
            this.evalOnScope = "V";
            String predicate = this.translatePredicate(predicateExp);
            return start + predicate + ')';
        }
        String result = "SELECT";
        if (distinctTag != null) {
            result = result + " DISTINCT " + distinctTag;
        }
        String predicate = this.translatePredicate(predicateExp);
        if (this.scopeId != null) {
            String scope = "(TRAVERSE out('scopedEdge') FROM " + this.scopeId + ')';
            result = result + " FROM " + scope + " WHERE $depth > 0 AND " + predicate;
        } else {
            result = result + " FROM V WHERE " + predicate;
        }
        return result;
    }

    private String translateTraverse(Traverse traverse) throws Exception {
        if (this.scopeId == null) {
            throw new Exception("Traverse query must include a baseId");
        }
        String direction = traverse.isOutbound() ? "out" : "in";
        Id relId = traverse.getRelationId();
        String relation = this.getNameAndKey(relId.getDictionary(), relId.getName());
        String scope = "SELECT FROM (TRAVERSE " + direction + "('" + relation + "') FROM " + this.scopeId + " MAXDEPTH 1) WHERE $depth = 1";
        Expression predicateExp = traverse.getPredicate();
        if (predicateExp != null) {
            this.containsEvalOn = OrientGeneratingVisitor.containsEvalOn(predicateExp);
            if (this.containsEvalOn) {
                this.evalOnScope = "$scope";
                String predicate = this.translatePredicate(predicateExp);
                return "SELECT EXPAND(intersect((" + predicate + "), " + this.evalOnScope + ")) LET " + this.evalOnScope + " = (" + scope + ')';
            }
            String predicate = this.translatePredicate(predicateExp);
            return scope + " AND " + predicate;
        }
        return scope;
    }

    private static boolean containsEvalOn(Expression expression) {
        return expression.getNodeType() == 19 || expression instanceof BinaryExpression && (OrientGeneratingVisitor.containsEvalOn(((BinaryExpression)expression).getLeft()) || OrientGeneratingVisitor.containsEvalOn(((BinaryExpression)expression).getRight()));
    }

    private String translatePredicate(Expression predicate) throws ContextMissingException {
        StringBuilder predicateBuilder = new StringBuilder();
        this.visit((AstNode)predicate, predicateBuilder);
        if (predicate.getNodeType() == 3) {
            predicateBuilder.append(" IS NOT NULL");
        }
        return predicateBuilder.toString();
    }

    private void visit(AstNode node, StringBuilder builder) throws ContextMissingException {
        switch (node.getNodeType()) {
            case 6: {
                this.visitAnd((AndExpression)node, builder);
                break;
            }
            case 3: {
                this.visitGetTag((GetTagExpression)node, builder);
                break;
            }
            case 8: {
                this.visitEqual((EqualExpression)node, builder);
                break;
            }
            case 10: {
                this.visitLess((LessExpression)node, builder);
                break;
            }
            case 11: {
                this.visitLessEq((LessOrEqualExpression)node, builder);
                break;
            }
            case 20: {
                this.visitLike((LikeExpression)node, builder);
                break;
            }
            case 5: {
                this.visitLiteral((LiteralExpression)node, builder);
                break;
            }
            case 4: {
                this.visitGetRelation((GetRelationExpression)node, builder);
                break;
            }
            case 12: {
                this.visitGreater((GreaterExpression)node, builder);
                break;
            }
            case 13: {
                this.visitGreaterEq((GreaterOrEqualExpression)node, builder);
                break;
            }
            case 9: {
                this.visitNotEqual((NotEqualExpression)node, builder);
                break;
            }
            case 7: {
                this.visitOr((OrExpression)node, builder);
                break;
            }
            case 17: {
                this.visitTraverseIn((TraverseInExpression)node, builder);
                break;
            }
            case 18: {
                this.visitTraverseOut((TraverseOutExpression)node, builder);
                break;
            }
            case 19: {
                this.visitEvalOn((EvalOnExpression)node, builder);
                break;
            }
            case 15: {
                this.visitNot((NotExpression)node, builder);
                break;
            }
            case 14: {
                this.visitContext((ContextExpression)node, builder);
                break;
            }
            default: {
                throw new IllegalStateException("Node " + node + " not supported");
            }
        }
    }

    private void visitAnd(AndExpression and, StringBuilder builder) throws ContextMissingException {
        if (this.containsEvalOn) {
            Expression leftExpression = and.getLeft();
            Expression rightExpression = and.getRight();
            String left = this.getLogicalSideTranslation((LogicalExpression)and, leftExpression);
            String right = this.getLogicalSideTranslation((LogicalExpression)and, rightExpression);
            builder.append("SELECT EXPAND(intersect((");
            if (!OrientGeneratingVisitor.containsEvalOn(leftExpression)) {
                builder.append(right).append("), (").append(left);
            } else if (!OrientGeneratingVisitor.containsEvalOn(rightExpression)) {
                builder.append(left).append("), (").append(right);
            } else {
                builder.append(left).append("), (").append(right);
                if (this.scopeId != null) {
                    builder.append("), (SELECT FROM ").append(this.evalOnScope);
                }
            }
            builder.append(")))");
        } else {
            this.getLogicalTranslation(and.getLeft(), " AND ", and.getRight(), builder);
        }
    }

    private void visitOr(OrExpression or, StringBuilder builder) throws ContextMissingException {
        if (this.containsEvalOn) {
            Expression leftExpression = or.getLeft();
            Expression rightExpression = or.getRight();
            String left = this.getLogicalSideTranslation((LogicalExpression)or, leftExpression);
            String right = this.getLogicalSideTranslation((LogicalExpression)or, rightExpression);
            builder.append("SELECT EXPAND(unionall((");
            if (!OrientGeneratingVisitor.containsEvalOn(leftExpression)) {
                builder.append(right).append("), (").append(left);
            } else if (!OrientGeneratingVisitor.containsEvalOn(rightExpression)) {
                builder.append(left).append("), (").append(right);
            } else {
                if (this.scopeId != null) {
                    builder.append("SELECT FROM " + this.evalOnScope + " LIMIT 0), (");
                }
                builder.append(left).append("), (").append(right);
            }
            builder.append(")))");
        } else {
            this.getLogicalTranslation(or.getLeft(), " OR ", or.getRight(), builder);
        }
    }

    private String getLogicalSideTranslation(LogicalExpression parentExpression, Expression side) throws ContextMissingException {
        StringBuilder translation = new StringBuilder();
        this.getDeepTranslationForLogicalSide(translation, side, parentExpression.getNodeType());
        return translation.toString();
    }

    private void getDeepTranslationForLogicalSide(StringBuilder translation, Expression expression, int logicalNodeType) throws ContextMissingException {
        if (expression.getNodeType() == logicalNodeType) {
            LogicalExpression logicalExpression = (LogicalExpression)expression;
            this.getDeepTranslationForLogicalSide(translation, logicalExpression.getLeft(), logicalNodeType);
            translation.append("), (");
            this.getDeepTranslationForLogicalSide(translation, logicalExpression.getRight(), logicalNodeType);
        } else {
            this.buildLogicalSideTranslation(translation, expression);
        }
    }

    private void buildLogicalSideTranslation(StringBuilder translation, Expression side) throws ContextMissingException {
        if (side.getNodeType() == 3) {
            translation.append("SELECT FROM ").append(this.evalOnScope).append(" WHERE ");
            this.visitGetTag((GetTagExpression)side, translation);
            translation.append(" IS NOT NULL");
        } else {
            this.visit((AstNode)side, translation);
        }
    }

    private void getLogicalTranslation(Expression exp1, String op, Expression exp2, StringBuilder builder) throws ContextMissingException {
        builder.append('(');
        this.visit((AstNode)exp1, builder);
        if (exp1.getNodeType() == 3) {
            builder.append(" IS NOT NULL");
        }
        builder.append(op);
        this.visit((AstNode)exp2, builder);
        if (exp2.getNodeType() == 3) {
            builder.append(" IS NOT NULL");
        }
        builder.append(')');
    }

    private void visitContext(ContextExpression con, StringBuilder builder) throws ContextMissingException {
        GetTagExpression inner = (GetTagExpression)con.getExpression();
        String key = inner.getKey();
        if (this.context == null) {
            throw new ContextMissingException("No context given to the translator.");
        }
        BObject bObj = this.context.getFacets().getFacet(key);
        if (bObj == null) {
            throw new ContextMissingException("No facet " + key + " in the context given to the translator.");
        }
        LiteralExpression litExp = new LiteralExpression(bObj.toDataValue());
        this.visit((AstNode)litExp, builder);
    }

    private void visitGetRelation(GetRelationExpression getR, StringBuilder builder) {
        builder.append(this.getNameAndKey(getR.getNamespace(), getR.getKey()));
    }

    private void visitGetTag(GetTagExpression getT, StringBuilder builder) {
        builder.append(this.getNameAndKey(getT.getNamespace(), getT.getKey()));
    }

    private void visitEqual(EqualExpression eq, StringBuilder builder) throws ContextMissingException {
        this.getComparisonTranslation(eq.getLeft(), " = ", eq.getRight(), builder);
    }

    private void visitNotEqual(NotEqualExpression neq, StringBuilder builder) throws ContextMissingException {
        this.getComparisonTranslation(neq.getLeft(), " <> ", neq.getRight(), builder);
    }

    private void visitGreater(GreaterExpression grt, StringBuilder builder) throws ContextMissingException {
        this.getComparisonTranslation(grt.getLeft(), " > ", grt.getRight(), " < ", builder);
    }

    private void visitGreaterEq(GreaterOrEqualExpression goe, StringBuilder builder) throws ContextMissingException {
        this.getComparisonTranslation(goe.getLeft(), " >= ", goe.getRight(), " <= ", builder);
    }

    private void visitLess(LessExpression less, StringBuilder builder) throws ContextMissingException {
        this.getComparisonTranslation(less.getLeft(), " < ", less.getRight(), " > ", builder);
    }

    private void visitLessEq(LessOrEqualExpression loe, StringBuilder builder) throws ContextMissingException {
        this.getComparisonTranslation(loe.getLeft(), " <= ", loe.getRight(), " >= ", builder);
    }

    private void visitLike(LikeExpression like, StringBuilder builder) throws ContextMissingException {
        this.getComparisonTranslation(like.getLeft(), " MATCHES ", like.getRight(), builder);
    }

    private void getComparisonTranslation(Expression exp1, String op, Expression exp2, StringBuilder builder) throws ContextMissingException {
        this.getComparisonTranslation(exp1, op, exp2, null, builder);
    }

    private void getComparisonTranslation(Expression exp1, String op, Expression exp2, String inverseOp, StringBuilder builder) throws ContextMissingException {
        int exp1NodeType = exp1.getNodeType();
        int exp2NodeType = exp2.getNodeType();
        if (exp1NodeType == 19 && exp2NodeType == 19) {
            throw new IllegalStateException("Both sides of an expression cannot be evalOn expressions");
        }
        if (exp1NodeType == 19) {
            this.handleEvalOn((EvalOnExpression)exp1, op, exp2, builder);
        } else if (exp2NodeType == 19) {
            op = inverseOp != null ? inverseOp : op;
            this.handleEvalOn((EvalOnExpression)exp2, op, exp1, builder);
        } else if (this.containsEvalOn) {
            builder.append("SELECT FROM ").append(this.evalOnScope).append(" WHERE ");
            this.visit((AstNode)exp1, builder);
            builder.append(op);
            this.visit((AstNode)exp2, builder);
            if (exp1.getNodeType() == 3) {
                builder.append(" AND ");
                this.visitGetTag((GetTagExpression)exp1, builder);
                builder.append(" IS NOT NULL");
            } else if (exp2.getNodeType() == 3) {
                builder.append(" AND ");
                this.visitGetTag((GetTagExpression)exp2, builder);
                builder.append(" IS NOT NULL");
            }
        } else {
            this.visit((AstNode)exp1, builder);
            builder.append(op);
            this.visit((AstNode)exp2, builder);
            if (exp1.getNodeType() == 3) {
                builder.append(" AND ");
                this.visitGetTag((GetTagExpression)exp1, builder);
                builder.append(" IS NOT NULL");
            } else if (exp2.getNodeType() == 3) {
                builder.append(" AND ");
                this.visitGetTag((GetTagExpression)exp2, builder);
                builder.append(" IS NOT NULL");
            }
        }
    }

    private void visitEvalOn(EvalOnExpression evalOn, StringBuilder builder) throws ContextMissingException {
        this.handleEvalOn(evalOn, null, null, builder);
    }

    private void handleEvalOn(EvalOnExpression evalOn, String op, Expression right, StringBuilder builder) throws ContextMissingException {
        List<String> relationIds = this.getEvalOnRelationIds(evalOn);
        if (this.scopeId != null) {
            builder.append("SELECT EXPAND(").append(OrientGeneratingVisitor.getExpandBack(evalOn, relationIds)).append(") FROM (SELECT FROM (SELECT EXPAND(").append(OrientGeneratingVisitor.getExpandForward(evalOn, relationIds)).append(") FROM ").append(this.evalOnScope).append(") WHERE ");
        } else {
            builder.append("SELECT EXPAND(").append(OrientGeneratingVisitor.getExpandBack(evalOn, relationIds)).append(") FROM ").append(this.evalOnScope).append(" WHERE ");
        }
        this.visit((AstNode)evalOn.getExpression(), builder);
        if (op != null) {
            builder.append(op);
            this.visit((AstNode)right, builder);
            GetTagExpression getTagExpression = evalOn.getExpression().getNodeType() == 3 ? (GetTagExpression)evalOn.getExpression() : (GetTagExpression)right;
            builder.append(" AND ");
            this.visitGetTag(getTagExpression, builder);
            builder.append(" IS NOT NULL");
        } else if (evalOn.getExpression().getNodeType() == 3) {
            builder.append(" IS NOT NULL");
        }
        if (this.scopeId != null) {
            builder.append(')');
        }
    }

    private List<String> getEvalOnRelationIds(EvalOnExpression evalOn) {
        EvalOnExpression current = evalOn;
        ArrayList<String> relationIds = new ArrayList<String>();
        while (current.getNodeType() == 19) {
            Expression targetExpression = current.getTarget();
            current = targetExpression.getNodeType() == 17 ? ((TraverseInExpression)targetExpression).getExpression() : ((TraverseOutExpression)targetExpression).getExpression();
            relationIds.add(this.getRelationString((Expression)current));
        }
        return relationIds;
    }

    private String getRelationString(Expression expression) {
        GetRelationExpression relationExpression = expression.getNodeType() == 19 ? (GetRelationExpression)((EvalOnExpression)expression).getExpression() : (GetRelationExpression)expression;
        return this.getNameAndKey(relationExpression.getNamespace(), relationExpression.getKey());
    }

    private static String getExpandBack(EvalOnExpression evalOn, List<String> relationIds) {
        boolean out = evalOn.getTarget().getNodeType() == 18;
        String dir = out ? "in" : "out";
        StringJoiner relationIdJoiner = new StringJoiner(".");
        for (String relationId : relationIds) {
            relationIdJoiner.add(dir + "('" + relationId + "')");
        }
        return relationIdJoiner.toString();
    }

    private static String getExpandForward(EvalOnExpression evalOn, List<String> relationIds) {
        boolean out = evalOn.getTarget().getNodeType() == 18;
        String dir = out ? "out" : "in";
        StringJoiner relationIdJoiner = new StringJoiner(".");
        ListIterator<String> iterator = relationIds.listIterator(relationIds.size());
        while (iterator.hasPrevious()) {
            relationIdJoiner.add(dir + "('" + iterator.previous() + "')");
        }
        return relationIdJoiner.toString();
    }

    private void visitLiteral(LiteralExpression node, StringBuilder builder) {
        try {
            BIDataValue nodeValue = node.getValue();
            Type nodeType = nodeValue.getType();
            if (nodeType == BBoolean.TYPE || nodeType.is(BNumber.TYPE)) {
                builder.append(nodeValue.encodeToString());
            } else {
                String nodeValueStr = nodeType == BOrd.TYPE ? this.resolveOrdLiteral((BOrd)nodeValue) : nodeValue.encodeToString();
                String literal = "literal_" + this.parameters.size();
                this.parameters.put(literal, nodeValueStr);
                builder.append(':').append(literal);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Node value failed to be encoded.", e);
        }
    }

    private String resolveOrdLiteral(BOrd ord) {
        BObject bObject = null;
        try {
            bObject = ord.resolve(this.base, this.context).get();
        }
        catch (Exception e) {
            BOrientSystemDb.getLogger().log(Level.FINE, e, () -> "Unable to resolve the Ord with base : " + this.base + " and context : " + this.context);
        }
        BOrd result = ord;
        if (bObject instanceof Entity) {
            try {
                result = BSystemDb.toSystemDbOrd((Entity)((Entity)bObject));
            }
            catch (BSystemDb.InvalidEntityException e) {
                BOrientSystemDb.getLogger().log(Level.FINE, e, () -> "Unable to convert ORD: " + ord + " to a SystemDB ORD.");
            }
        } else if (bObject != null && BOrientSystemDb.getLogger().isLoggable(Level.FINE)) {
            BOrientSystemDb.getLogger().fine(result + " resolved to a non Entity. It will pass through to the DB.");
        }
        return result.toString();
    }

    private void visitNot(NotExpression not, StringBuilder builder) throws ContextMissingException {
        if (not.getExpression().getNodeType() == 3) {
            this.visitGetTag((GetTagExpression)not.getExpression(), builder);
            builder.append(" IS NULL");
        } else {
            builder.append("NOT (");
            this.visit((AstNode)not.getExpression(), builder);
            builder.append(')');
        }
    }

    private void visitTraverseIn(TraverseInExpression in, StringBuilder builder) throws ContextMissingException {
        this.traverseTranslation("in", (AstNode)in, builder);
    }

    private void visitTraverseOut(TraverseOutExpression out, StringBuilder builder) throws ContextMissingException {
        this.traverseTranslation("out", (AstNode)out, builder);
    }

    private void traverseTranslation(String prefix, AstNode given, StringBuilder builder) throws ContextMissingException {
        AstNode current = given;
        int nodeType = current.getNodeType();
        while (nodeType == 18 || nodeType == 17) {
            current = nodeType == 18 ? ((TraverseOutExpression)current).getExpression() : ((TraverseInExpression)current).getExpression();
            if ((nodeType = current.getNodeType()) == 3 || nodeType == 4) {
                builder.append(prefix).append("('");
                this.visit(current, builder);
                builder.append("').");
                break;
            }
            if (nodeType != 19) continue;
            builder.append(prefix).append("('");
            this.visit((AstNode)((EvalOnExpression)current).getExpression(), builder);
            builder.append("').");
            current = ((EvalOnExpression)current).getTarget();
            nodeType = current.getNodeType();
        }
    }

    private String getNameAndKey(String namespace, String key) {
        if (namespace == null || namespace.isEmpty()) {
            if (this.contextNamespace != null) {
                namespace = this.contextNamespace;
            } else {
                return OrientSystemDbConnection.escapeToOrientForm(key);
            }
        }
        return OrientSystemDbConnection.escapeToOrientForm(namespace + ':' + key);
    }

    private static class ContextMissingException
    extends Exception {
        ContextMissingException(String sMsg) {
            super(sMsg);
        }
    }
}

