/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.util;

import com.tridium.snmp.BSnmpDevice;
import com.tridium.snmp.datatypes.BMibListEntry;
import com.tridium.snmp.datatypes.BMibListTable;
import com.tridium.snmp.enums.BSnmpMipEntryTypeEnum;
import com.tridium.snmp.enums.BSnmpVariableTypeEnum;
import com.tridium.snmp.point.BSnmpPointDeviceExt;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import com.tridium.snmp.util.DisplayHintParser;
import java.util.Vector;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSnmpWalkMibJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpWalkMibJob.class);
    BSnmpDevice device;
    BMibListTable mibTable;
    public static BIcon icon = BIcon.std((String)"find.png");
    BSnmpPointDeviceExt deviceExt;
    boolean walkCanceled = false;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSnmpWalkMibJob() {
    }

    public BSnmpWalkMibJob(BSnmpDevice device, BMibListTable mibList) {
        this.device = device;
        this.mibTable = mibList;
    }

    public void doCancel(Context cx) {
        this.walkCanceled = true;
        super.doCancel(cx);
    }

    public void run(Context cx) throws Exception {
        this.progress(0);
        this.log().start("Walking MIB...");
        BMibListEntry[] createList = this.mibTable.getPointListCopy();
        int total = createList.length;
        if (total <= 0) {
            total = 1;
        }
        int iteration = 0;
        for (int i = 0; i < createList.length; ++i) {
            Vector<SnmpVarBind> vars;
            String displayHint = createList[i].getDisplayHint();
            BSnmpVariableTypeEnum variabletype = createList[i].getVariableType();
            if (this.walkCanceled) break;
            this.progress((int)((float)iteration / (float)total * 100.0f));
            ++iteration;
            BSnmpMipEntryTypeEnum entryType = createList[i].getElementType();
            if (entryType.equals((Object)BSnmpMipEntryTypeEnum.sequenceElement)) {
                String colOid;
                boolean keepLooking = true;
                String currentOid = colOid = createList[i].getOid();
                this.log().message("Reading table values for " + createList[i].getEntryName() + " (" + currentOid + ")...");
                createList[i].clearChildren();
                int count = 1;
                while (keepLooking && !this.walkCanceled) {
                    SnmpPDU pdu = this.device.updateGetNext(currentOid);
                    if (pdu == null) {
                        keepLooking = false;
                        continue;
                    }
                    Vector<SnmpVarBind> vars2 = pdu.getVariableBindings();
                    if (vars2 == null || vars2.size() <= 0) {
                        keepLooking = false;
                        continue;
                    }
                    SnmpVarBind varBind = vars2.elementAt(0);
                    String oid = varBind.getObjectID().toString();
                    if (oid.startsWith(colOid) && !oid.equals(colOid) && !oid.equals(currentOid)) {
                        String nodeName;
                        int lastDecimal = oid.lastIndexOf(46);
                        if (lastDecimal >= 0 && lastDecimal + 1 < oid.length()) {
                            String rowId = oid.substring(colOid.length() + 1);
                            nodeName = createList[i].getEntryName() + "_" + rowId;
                        } else {
                            nodeName = createList[i].getEntryName() + "_" + count;
                        }
                        BMibListEntry newChild = new BMibListEntry(nodeName, oid, createList[i].getObjectSyntax(), createList[i].getDisplayHint(), createList[i].getVariableType(), createList[i].getAccess(), createList[i].getStatus(), createList[i].getDesc(), BSnmpMipEntryTypeEnum.sequenceValue);
                        SnmpVar var = varBind.getVariable();
                        String value = this.applyDisplayHint(displayHint, variabletype, var);
                        newChild.setValue(value);
                        newChild.setEnumRange(createList[i].getEnumRange());
                        createList[i].addChild(newChild);
                        currentOid = oid;
                    } else {
                        keepLooking = false;
                    }
                    ++count;
                }
                continue;
            }
            if (!entryType.isAccessibleValue()) continue;
            String currentOid = createList[i].getOid();
            this.log().message("Reading present value for " + createList[i].getEntryName() + " (" + currentOid + ")...");
            SnmpPDU pdu = this.device.updateGet(currentOid);
            if (pdu == null || (vars = pdu.getVariableBindings()) == null || vars.size() <= 0) continue;
            SnmpVarBind varBind = vars.elementAt(0);
            SnmpVar var = varBind.getVariable();
            String value = this.applyDisplayHint(displayHint, variabletype, var);
            createList[i].setValue(value);
        }
        if (this.walkCanceled) {
            throw new JobCancelException();
        }
        this.log().success("MIB Walk Complete");
        ((BSnmpPointDeviceExt)this.device.getPoints()).fireMibWalkedEvent(new BMibListTable(createList));
    }

    private String applyDisplayHint(String displayHint, BSnmpVariableTypeEnum variabletype, SnmpVar var) throws Exception {
        String value = var.toStringValue();
        if (displayHint == null || displayHint.equals("")) {
            return value;
        }
        if (variabletype == BSnmpVariableTypeEnum.integerType || variabletype == BSnmpVariableTypeEnum.counter || variabletype == BSnmpVariableTypeEnum.gauge || variabletype == BSnmpVariableTypeEnum.timeticks) {
            value = DisplayHintParser.numericDisplay(var.toStringValue(), displayHint);
        } else if (variabletype == BSnmpVariableTypeEnum.stringType && var instanceof SnmpString) {
            value = DisplayHintParser.stringDisplay(((SnmpString)var).getRawData(), displayHint);
        }
        return value;
    }

    public BIcon getIcon() {
        return icon;
    }
}

