/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.mib.MibObject;
import com.tridium.snmp.snmptypes.SnmpConst;
import com.tridium.snmp.snmptypes.SnmpInt;
import com.tridium.snmp.snmptypes.SnmpNull;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpString;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.sys.BModule;
import javax.baja.sys.Sys;

public class TridiumStation
implements MibObject,
SnmpConst {
    private BSnmpNetwork snmp;
    public static final int LEVEL = 8;
    public static final int VERSION = 1;
    public static final int ACTION = 2;
    public static final int ALARM_TABLE = 3;
    public static final int INPUT = 4;
    public static final int NO_ACTION = 0;
    public static final int ACK_ALL = 1;

    public TridiumStation(BSnmpNetwork snmp) {
        this.snmp = snmp;
    }

    @Override
    public SnmpVar getValue(SnmpOID oid) {
        long[] aOid = oid.toLongArray();
        switch ((int)aOid[8]) {
            case 1: {
                BModule baja = Sys.getBajaModule();
                BModule snmp = Sys.getModuleForClass(BSnmpNetwork.class);
                String s = baja.getModuleName() + " [" + baja.getVendor(RuntimeProfile.rt) + " " + baja.getVendorVersion(RuntimeProfile.rt) + "]; " + snmp.getModuleName() + " [" + snmp.getVendor(RuntimeProfile.rt) + " " + snmp.getVendorVersion(RuntimeProfile.rt) + "]";
                return new SnmpString(s);
            }
            case 2: {
                return new SnmpInt(0);
            }
        }
        return new SnmpNull();
    }

    @Override
    public SnmpOID getNextOid(SnmpOID oid) {
        long[] aOid = oid.toLongArray();
        if (aOid.length <= 9) {
            return new SnmpOID("1.3.6.1.4.1.4131.1.1.0.0");
        }
        switch ((int)aOid[8]) {
            case 1: 
            case 2: {
                aOid[8] = aOid[8] + 1L;
                break;
            }
            default: {
                return null;
            }
        }
        return new SnmpOID(aOid);
    }

    @Override
    public int validateForSet(SnmpVarBind varbind) {
        SnmpOID oid = varbind.getObjectID();
        long[] aOid = oid.toLongArray();
        if (aOid.length <= 8) {
            return 6;
        }
        switch ((int)aOid[8]) {
            case 2: {
                try {
                    ((SnmpInt)varbind.getVariable()).intValue();
                    break;
                }
                catch (Exception e) {
                    return 7;
                }
            }
            default: {
                return 6;
            }
        }
        return 0;
    }

    @Override
    public int setValue(SnmpVarBind varbind, SnmpPDU resp) {
        SnmpOID oid = varbind.getObjectID();
        long[] aOid = oid.toLongArray();
        switch ((int)aOid[8]) {
            case 2: {
                int action;
                try {
                    action = ((SnmpInt)varbind.getVariable()).intValue();
                }
                catch (Exception e) {
                    return 3;
                }
                switch (action) {
                    case 1: {
                        this.snmp.alarms().acknowledgeAll();
                    }
                }
                resp.addVariableBinding(new SnmpVarBind(oid, new SnmpInt(action)));
                break;
            }
            default: {
                return 2;
            }
        }
        return 0;
    }
}

