/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp.mib;

import com.tridium.snmp.mib.MibObject;
import com.tridium.snmp.mib.table.TableEntry;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.util.SnmpUtil;

public abstract class MibTable
implements MibObject {
    private int numberRows;
    private int numberColumns;

    public abstract int getObjectLevel();

    public abstract int getLastId();

    public abstract TableEntry getNextEntry(int var1);

    public abstract String getFirstOid();

    public int getNumberRows() {
        return this.numberRows;
    }

    public int getNumberColumns() {
        return this.numberColumns;
    }

    public void setNumberRows(int numberRows) {
        this.numberRows = numberRows;
    }

    public void setNumberColumns(int numberColumns) {
        this.numberColumns = numberColumns;
    }

    boolean isOidForMyTable(long[] aOid) {
        int colNdx = this.getObjectLevel();
        if (aOid.length < colNdx) {
            return false;
        }
        long[] myOid = SnmpUtil.getLongArray(this.getFirstOid());
        for (int i = 0; i < colNdx; ++i) {
            if (aOid[i] == myOid[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public SnmpOID getNextOid(SnmpOID oid) {
        long[] aOid = oid.toLongArrayCopy();
        int colNdx = this.getObjectLevel();
        int rowNdx = colNdx + 1;
        TableEntry entry = this.getNextEntry(0);
        if (entry == null) {
            return null;
        }
        long firstRowNum = entry.getIndex();
        if (!this.isOidForMyTable(aOid) || aOid.length < colNdx || aOid[colNdx] == 0L) {
            return new SnmpOID(this.getFirstOid() + "." + firstRowNum);
        }
        if (aOid[colNdx] > (long)this.getLastId()) {
            return null;
        }
        if (aOid.length == rowNdx) {
            return new SnmpOID(oid + "." + firstRowNum);
        }
        long rowNum = aOid[rowNdx];
        entry = this.getNextEntry((int)rowNum);
        if (entry == null) {
            if (aOid[colNdx] >= (long)this.getLastId()) {
                return null;
            }
            int n = colNdx;
            aOid[n] = aOid[n] + 1L;
            aOid[rowNdx] = this.getNextEntry(0).getIndex();
        } else {
            aOid[rowNdx] = entry.getIndex();
        }
        return new SnmpOID(aOid);
    }
}

