/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.snmp;

import com.tridium.snmp.BSnmpNetwork;
import com.tridium.snmp.BSnmpNetworkObject;
import com.tridium.snmp.alarm.BSnmpAlarmDeviceExt;
import com.tridium.snmp.datatypes.BMibListTable;
import com.tridium.snmp.point.BSnmpPointDeviceExt;
import com.tridium.snmp.point.BSnmpProxyExt;
import com.tridium.snmp.snmptypes.SnmpNull;
import com.tridium.snmp.snmptypes.SnmpOID;
import com.tridium.snmp.snmptypes.SnmpPDU;
import com.tridium.snmp.snmptypes.SnmpVar;
import com.tridium.snmp.snmptypes.SnmpVarBind;
import com.tridium.snmp.table.BSnmpTable;
import com.tridium.snmp.util.BSnmpWalkMibJob;
import com.tridium.util.ArrayUtil;
import java.net.InetAddress;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="retryCount", type="int", defaultValue="2"), @NiagaraProperty(name="responseTimeout", type="BRelTime", defaultValue="BRelTime.make(2000)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.make(true))")}), @NiagaraProperty(name="ipAddress", type="String", defaultValue=""), @NiagaraProperty(name="port", type="int", defaultValue="SnmpConst.DEFAULT_SNMP_PORT", facets={@Facet(value="BFacets.makeInt(null, 0, 65535)")}), @NiagaraProperty(name="snmpVersion", type="int", defaultValue="2", facets={@Facet(value="BFacets.makeInt(null, 1, 2)")}), @NiagaraProperty(name="community", type="String", defaultValue="public"), @NiagaraProperty(name="maxVariableBindingsPerRequest", type="int", defaultValue="10", facets={@Facet(value="BFacets.makeInt(null, 0, Integer.MAX_VALUE)")}), @NiagaraProperty(name="points", type="BPointDeviceExt", defaultValue="new BSnmpPointDeviceExt()", override=true), @NiagaraProperty(name="traps", type="BSnmpAlarmDeviceExt", defaultValue="new BSnmpAlarmDeviceExt()"), @NiagaraProperty(name="mib", type="String", defaultValue="")})
@NiagaraAction(name="walkMib", parameterType="BMibListTable", defaultValue="new BMibListTable()", returnType="BOrd", flags=4)
public class BSnmpDevice
extends BSnmpNetworkObject
implements BIPollable {
    @Generated
    public static final Property pollFrequency = BSnmpDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property retryCount = BSnmpDevice.newProperty((int)0, (int)2, null);
    @Generated
    public static final Property responseTimeout = BSnmpDevice.newProperty((int)0, (BValue)BRelTime.make((long)2000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)true)));
    @Generated
    public static final Property ipAddress = BSnmpDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property port = BSnmpDevice.newProperty((int)0, (int)161, (BFacets)BFacets.makeInt(null, (int)0, (int)65535));
    @Generated
    public static final Property snmpVersion = BSnmpDevice.newProperty((int)0, (int)2, (BFacets)BFacets.makeInt(null, (int)1, (int)2));
    @Generated
    public static final Property community = BSnmpDevice.newProperty((int)0, (String)"public", null);
    @Generated
    public static final Property maxVariableBindingsPerRequest = BSnmpDevice.newProperty((int)0, (int)10, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    @Generated
    public static final Property points = BSnmpDevice.newProperty((int)0, (BValue)new BSnmpPointDeviceExt(), null);
    @Generated
    public static final Property traps = BSnmpDevice.newProperty((int)0, (BValue)new BSnmpAlarmDeviceExt(), null);
    @Generated
    public static final Property mib = BSnmpDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Action walkMib = BSnmpDevice.newAction((int)4, (BValue)new BMibListTable(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpDevice.class);
    Vector<BSnmpTable> tables = null;
    BSnmpNetwork net = null;

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    @Generated
    public void setRetryCount(int v) {
        this.setInt(retryCount, v, null);
    }

    @Generated
    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    @Generated
    public void setResponseTimeout(BRelTime v) {
        this.set(responseTimeout, (BValue)v, null);
    }

    @Generated
    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    @Generated
    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public int getSnmpVersion() {
        return this.getInt(snmpVersion);
    }

    @Generated
    public void setSnmpVersion(int v) {
        this.setInt(snmpVersion, v, null);
    }

    @Generated
    public String getCommunity() {
        return this.getString(community);
    }

    @Generated
    public void setCommunity(String v) {
        this.setString(community, v, null);
    }

    @Generated
    public int getMaxVariableBindingsPerRequest() {
        return this.getInt(maxVariableBindingsPerRequest);
    }

    @Generated
    public void setMaxVariableBindingsPerRequest(int v) {
        this.setInt(maxVariableBindingsPerRequest, v, null);
    }

    @Generated
    public BSnmpAlarmDeviceExt getTraps() {
        return (BSnmpAlarmDeviceExt)this.get(traps);
    }

    @Generated
    public void setTraps(BSnmpAlarmDeviceExt v) {
        this.set(traps, (BValue)v, null);
    }

    @Generated
    public String getMib() {
        return this.getString(mib);
    }

    @Generated
    public void setMib(String v) {
        this.setString(mib, v, null);
    }

    @Generated
    public BOrd walkMib(BMibListTable parameter) {
        return (BOrd)this.invoke(walkMib, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.snmpNet().getPollScheduler().subscribe(this);
    }

    public void stopped() throws Exception {
        this.snmpNet().getPollScheduler().unsubscribe(this);
        super.stopped();
    }

    public String toString(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLexicon().getText("device.strings.snmpDevice")).append("[" + this.getIpAddress() + "]:");
        sb.append(this.isDown() ? this.getLexicon().getText("device.strings.down") : this.getLexicon().getText("device.strings.up"));
        return sb.toString();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p == status) {
            this.updateMyStatus();
        }
    }

    @Override
    protected IFuture postPing() {
        if (this.snmpNet() != null) {
            return this.snmpNet().postRequest((Runnable)new Invocation((BComponent)this, ping, null, null));
        }
        this.doPing();
        return null;
    }

    @Override
    public void doPing() {
        if (this.isDisabled() || this.isFault()) {
            return;
        }
        if (this.snmpNet() == null) {
            this.pingFail("No snmp network found");
            return;
        }
        SnmpPDU msg = new SnmpPDU(this, 160);
        SnmpOID oid = new SnmpOID("1.3.6.1.2.1.1.1.0");
        SnmpVarBind varBind = new SnmpVarBind(oid, new SnmpNull());
        msg.addVariableBinding(varBind);
        SnmpPDU pdu = this.snmpNet().sendAsyncRequest(msg, (int)this.getResponseTimeout().getMillis(), this.getRetryCount());
        if (this.snmpNet().log().isLoggable(Level.FINE)) {
            this.snmpNet().log().fine("ping(): SnmpDevice " + this.getName() + "[" + this.getIpAddress() + "] is " + (pdu == null ? "down" : "up"));
        }
        if (pdu != null) {
            this.pingOk();
        } else {
            this.pingFail(this.getLexicon().getText("pingFail"));
        }
    }

    public boolean isActive() {
        return !this.isDisabled() && !this.isDown() && !this.isFault() && this.net.isCommActive();
    }

    public void poll() {
        int i;
        if (!this.isActive() || !Sys.atSteadyState()) {
            return;
        }
        BControlPoint[] points = this.getPoints().getPoints();
        Array a = new Array(BSnmpProxyExt.class);
        for (i = 0; i < points.length; ++i) {
            BSnmpProxyExt pext;
            if (!(points[i].getProxyExt() instanceof BSnmpProxyExt) || !(pext = (BSnmpProxyExt)points[i].getProxyExt()).isCurrentlySubscribed() || pext.isConfigFault()) continue;
            a.add((Object)pext);
        }
        if (a.size() > 0) {
            this.updateInputs((BSnmpProxyExt[])a.trim());
        }
        if (this.tables != null) {
            for (i = 0; i < this.tables.size(); ++i) {
                this.tables.elementAt(i).poll();
            }
        }
    }

    private void updateMyStatus() {
        if (this.tables != null) {
            for (int i = 0; i < this.tables.size(); ++i) {
                this.tables.elementAt(i).updateStatus();
            }
        }
    }

    private void updateInputs(BSnmpProxyExt[] a) {
        int maxBindings = this.getMaxVariableBindingsPerRequest();
        int curNdx = 0;
        while (curNdx < a.length) {
            SnmpPDU msg = new SnmpPDU(this, 160);
            int firstNdx = curNdx;
            for (int i = 0; i < maxBindings && curNdx < a.length; ++i) {
                BSnmpProxyExt ai = a[curNdx++];
                SnmpOID oid = new SnmpOID(ai.getObjectIdentifier());
                SnmpVarBind varBind = new SnmpVarBind(oid, new SnmpNull());
                msg.addVariableBinding(varBind);
            }
            SnmpPDU pdu = this.snmpNet().sendAsyncRequest(msg, (int)this.getResponseTimeout().getMillis(), this.getRetryCount());
            if (pdu == null) {
                this.snmpNet().log().severe("poll failed in " + this.getName());
                return;
            }
            int errorStatus = pdu.getErrstat();
            int errorIndex = pdu.getErrindex();
            if (errorIndex != 0) {
                int ndx = firstNdx + errorIndex - 1;
                a[ndx].readFail(SnmpPDU.translateErrorStatus(errorStatus));
                a = (BSnmpProxyExt[])ArrayUtil.removeOne((Object[])a, (int)ndx);
                curNdx = firstNdx;
                continue;
            }
            Vector<SnmpVarBind> vars = pdu.getVariableBindings();
            for (int i = 0; i < vars.size(); ++i) {
                BSnmpProxyExt ai = a[firstNdx + i];
                SnmpVarBind varBind = vars.elementAt(i);
                String oid = varBind.getObjectID().toString();
                if (oid.lastIndexOf(ai.getObjectIdentifier()) == -1) {
                    this.snmpNet().log().severe("poll error: " + oid + "!=" + ai.getObjectIdentifier());
                    continue;
                }
                ai.setValue(varBind.getVariable());
            }
        }
    }

    public void registerTable(BSnmpTable tab) {
        if (this.tables == null) {
            this.tables = new Vector();
        }
        if (this.tables.contains((Object)tab)) {
            return;
        }
        this.tables.add(tab);
    }

    public void unregisterTable(BSnmpTable tab) {
        if (this.tables == null) {
            return;
        }
        this.tables.removeElement((Object)tab);
    }

    public synchronized SnmpPDU updateGetNext(String oidEntry) {
        InetAddress inetAddr = this.getInetAddress();
        if (inetAddr == null) {
            return null;
        }
        SnmpPDU msg = new SnmpPDU();
        msg.setVersion(this.getVersion());
        msg.setReqid(this.snmpNet().getNextReqid());
        msg.setCommand(161);
        msg.setRemotePort(this.getPort());
        msg.setDestinationIp(inetAddr);
        msg.setCommunity(this.getCommunity());
        SnmpOID oid = new SnmpOID(oidEntry);
        SnmpVarBind varBind = new SnmpVarBind(oid, new SnmpNull());
        msg.addVariableBinding(varBind);
        SnmpPDU pdu = this.snmpNet().sendAsyncRequest(msg, (int)this.getResponseTimeout().getMillis(), this.getRetryCount());
        return pdu;
    }

    public synchronized SnmpPDU updateGet(String oidEntry) {
        InetAddress inetAddr = this.getInetAddress();
        if (inetAddr == null) {
            return null;
        }
        SnmpPDU msg = new SnmpPDU();
        msg.setVersion(this.getVersion());
        msg.setReqid(this.snmpNet().getNextReqid());
        msg.setCommand(160);
        msg.setRemotePort(this.getPort());
        msg.setDestinationIp(inetAddr);
        msg.setCommunity(this.getCommunity());
        SnmpOID oid = new SnmpOID(oidEntry);
        SnmpVarBind varBind = new SnmpVarBind(oid, new SnmpNull());
        msg.addVariableBinding(varBind);
        SnmpPDU pdu = this.snmpNet().sendAsyncRequest(msg, (int)this.getResponseTimeout().getMillis(), this.getRetryCount());
        return pdu;
    }

    public synchronized int setVar(SnmpVar var, String oid) {
        BSnmpNetwork network = this.snmpNet();
        SnmpPDU msg = new SnmpPDU();
        msg.setVersion(this.getVersion());
        msg.setReqid(network.getNextReqid());
        msg.setCommand(163);
        msg.setRemotePort(this.getPort());
        msg.setDestinationIp(this.getInetAddress());
        msg.setCommunity(this.getCommunity());
        SnmpVarBind varBind = new SnmpVarBind(new SnmpOID(oid), var);
        msg.addVariableBinding(varBind);
        SnmpPDU pdu = network.sendAsyncRequest(msg, (int)this.getResponseTimeout().getMillis(), this.getRetryCount());
        if (pdu == null) {
            return -1;
        }
        return pdu.getErrstat();
    }

    public BSnmpNetwork snmpNet() {
        if (this.net == null) {
            BComplex c = this.getParent();
            while (!(c instanceof BSnmpNetwork)) {
                c = c.getParent();
            }
            this.net = (BSnmpNetwork)c;
        }
        return this.net;
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.getIpAddress());
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getVersion() {
        if (this.getSnmpVersion() == 1) {
            return 0;
        }
        if (this.getSnmpVersion() == 2) {
            return 1;
        }
        this.setSnmpVersion(2);
        return 1;
    }

    public BOrd doWalkMib(BMibListTable mibList) {
        return new BSnmpWalkMibJob(this, mibList).submit(null);
    }
}

